/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.newts.cassandra;

import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.Session;
import com.google.common.io.CharStreams;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ServiceLoader;
import org.junit.rules.ExternalResource;
import org.opennms.newts.cassandra.CassandraSession;
import org.opennms.newts.cassandra.CassandraSessionImpl;
import org.opennms.newts.cassandra.Schema;
import org.testcontainers.containers.CassandraContainer;

public class NewtsInstance
extends ExternalResource {
    private static final String CASSANDRA_COMPRESSION = "NONE";
    private static final String CASSANDRA_KEYSPACE = "newts";
    private static final String CASSANDRA_USERNAME = "cassandra";
    private static final String CASSANDRA_PASSWORD = "cassandra";
    private static final String KEYSPACE_PLACEHOLDER = "$KEYSPACE$";
    private static final String REPLICATION_FACTOR_PLACEHOLDER = "$REPLICATION_FACTOR$";
    private static ServiceLoader<Schema> schemaLoader = ServiceLoader.load(Schema.class);
    public CassandraContainer<?> cassandra = new CassandraContainer("cassandra:3.11.13");
    private String host;
    private int port;

    public void before() {
        this.cassandra.start();
        NewtsInstance.installSchema(this.cassandra, CASSANDRA_KEYSPACE, 1);
        this.host = this.cassandra.getHost();
        this.port = this.cassandra.getMappedPort(CassandraContainer.CQL_PORT.intValue());
    }

    public void after() {
        this.cassandra.stop();
    }

    public CassandraSession getCassandraSession() {
        return new CassandraSessionImpl(this.cassandra.getLocalDatacenter(), CASSANDRA_KEYSPACE, this.host, this.port, CASSANDRA_COMPRESSION, "cassandra", "cassandra", false);
    }

    public static void installSchema(CassandraContainer<?> cassandra, String keyspace, int replicationFactor) {
        try {
            String schemasString = "";
            for (Schema schema : schemaLoader) {
                schemasString = schemasString + CharStreams.toString((Readable)new InputStreamReader(schema.getInputStream()));
            }
            schemasString = schemasString.replace(KEYSPACE_PLACEHOLDER, keyspace);
            schemasString = schemasString.replace(REPLICATION_FACTOR_PLACEHOLDER, Integer.toString(replicationFactor));
            String[] lines = schemasString.split("\\r?\\n");
            StringBuffer sb = new StringBuffer();
            boolean foundCreateKeyspace = false;
            boolean skipNextLine = false;
            for (String line : lines) {
                if (line.startsWith("CREATE KEYSPACE")) {
                    if (!foundCreateKeyspace) {
                        foundCreateKeyspace = true;
                        sb.append(line);
                        sb.append("\n");
                        continue;
                    }
                    skipNextLine = true;
                    continue;
                }
                if (skipNextLine) {
                    skipNextLine = false;
                    continue;
                }
                sb.append(line);
                sb.append("\n");
            }
            Cluster cluster = cassandra.getCluster();
            try (Session session = cluster.connect();){
                for (String statement : sb.toString().split(";")) {
                    if (statement.trim().isEmpty()) continue;
                    session.execute(statement);
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public String getDatacenter() {
        return this.cassandra.getLocalDatacenter();
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public String getCompression() {
        return CASSANDRA_COMPRESSION;
    }

    public String getKeyspace() {
        return CASSANDRA_KEYSPACE;
    }

    public String getUsername() {
        return "cassandra";
    }

    public String getPassword() {
        return "cassandra";
    }
}

