/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.newts.graphite;

import com.codahale.metrics.Counter;
import com.codahale.metrics.MetricRegistry;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.socket.SocketChannel;
import io.netty.handler.codec.DelimiterBasedFrameDecoder;
import io.netty.handler.codec.Delimiters;
import io.netty.handler.codec.string.StringDecoder;
import io.netty.handler.codec.string.StringEncoder;
import javax.inject.Inject;
import org.opennms.newts.api.SampleRepository;
import org.opennms.newts.graphite.GraphiteHandler;

public class GraphiteInitializer
extends ChannelInitializer<SocketChannel> {
    private static final StringDecoder DECODER = new StringDecoder();
    private static final StringEncoder ENCODER = new StringEncoder();
    private final SampleRepository m_repository;
    private final Counter m_protocolErrors;
    private final Counter m_storageErrors;

    @Inject
    public GraphiteInitializer(SampleRepository repostory, MetricRegistry registry) {
        this.m_repository = repostory;
        this.m_protocolErrors = registry.counter(MetricRegistry.name((String)"graphite-listener", (String[])new String[]{"protocol-errors"}));
        this.m_storageErrors = registry.counter(MetricRegistry.name((String)"graphite-listener", (String[])new String[]{"storage-errors"}));
    }

    public void initChannel(SocketChannel ch) throws Exception {
        ChannelPipeline pipeline = ch.pipeline();
        pipeline.addLast(new ChannelHandler[]{new DelimiterBasedFrameDecoder(8192, Delimiters.lineDelimiter())});
        pipeline.addLast(new ChannelHandler[]{DECODER});
        pipeline.addLast(new ChannelHandler[]{ENCODER});
        pipeline.addLast(new ChannelHandler[]{new GraphiteHandler(this.m_repository, this)});
    }

    void protocolErrorsInc() {
        this.m_protocolErrors.inc();
    }

    void storageErrorsInc() {
        this.m_storageErrors.inc();
    }
}

