/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.newts.graphite;

import com.google.common.base.CharMatcher;
import com.google.common.base.Joiner;
import com.google.common.base.Optional;
import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.opennms.newts.api.MetricType;
import org.opennms.newts.api.Resource;
import org.opennms.newts.api.Sample;
import org.opennms.newts.api.SampleRepository;
import org.opennms.newts.api.Timestamp;
import org.opennms.newts.api.ValueType;
import org.opennms.newts.graphite.GraphiteInitializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GraphiteHandler
extends SimpleChannelInboundHandler<String> {
    private static final Logger LOG = LoggerFactory.getLogger(GraphiteHandler.class);
    private static final int DEFAULT_LINES_BUFFER = 50;
    private final ThreadPoolExecutor m_executor;
    private final SampleRepository m_repository;
    private final GraphiteInitializer m_parent;
    private List<String> m_lines;
    private AtomicInteger m_enQueued = new AtomicInteger(0);
    private static final Splitter s_lineTokenizer = Splitter.on((CharMatcher)CharMatcher.whitespace()).limit(3).trimResults();
    private static final Splitter s_pathTokenizer = Splitter.on((char)'.').trimResults();
    private static final Joiner s_pathJoiner = Joiner.on((char)':');

    public GraphiteHandler(SampleRepository repository, GraphiteInitializer parent) {
        LinkedBlockingQueue<Runnable> queue = new LinkedBlockingQueue<Runnable>();
        int concurrency = Runtime.getRuntime().availableProcessors();
        this.m_executor = new ThreadPoolExecutor(concurrency, concurrency, 0L, TimeUnit.MILLISECONDS, queue);
        this.m_executor.setRejectedExecutionHandler(new ThreadPoolExecutor.CallerRunsPolicy());
        this.m_repository = repository;
        this.m_parent = parent;
        this.m_lines = Lists.newArrayList();
        LOG.debug("Using storage concurrency of {}", (Object)concurrency);
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        cause.printStackTrace();
        ctx.close();
    }

    protected void channelRead0(ChannelHandlerContext ctx, String msg) throws Exception {
        this.enqueue(msg);
    }

    private void enqueue(String msg) {
        this.m_lines.add(msg);
        if (this.m_enQueued.incrementAndGet() >= 50) {
            final List<String> batch = this.m_lines;
            this.m_lines = Lists.newArrayList();
            this.m_enQueued.set(0);
            this.m_executor.execute(new Runnable(){

                @Override
                public void run() {
                    ArrayList samples = Lists.newArrayList();
                    for (String line : batch) {
                        try {
                            samples.add(GraphiteHandler.parseSample(line));
                        }
                        catch (Exception e) {
                            GraphiteHandler.this.m_parent.protocolErrorsInc();
                        }
                    }
                    try {
                        GraphiteHandler.this.m_repository.insert((Collection)samples);
                    }
                    catch (Exception e) {
                        LOG.warn("Unable to commit batch of {} samples ({})", (Object)samples.size(), (Object)e.getMessage());
                        GraphiteHandler.this.m_parent.storageErrorsInc();
                    }
                }
            });
        }
    }

    static Resource parseResource(String[] path) {
        HashMap attributes = Maps.newHashMap();
        for (int i = 0; i < path.length; ++i) {
            attributes.put(GraphiteHandler.index(i), path[i]);
        }
        return new Resource(s_pathJoiner.join((Object[])path), Optional.of((Object)attributes));
    }

    static Sample parseSample(String line) {
        List parts = s_lineTokenizer.splitToList((CharSequence)line);
        String[] path = s_pathTokenizer.splitToList((CharSequence)parts.get(0)).toArray(new String[0]);
        Resource resource = GraphiteHandler.parseResource(path.length > 1 ? Arrays.copyOf(path, path.length - 1) : path);
        String name = path.length > 1 ? path[path.length - 1] : "value";
        Double value = Double.parseDouble((String)parts.get(1));
        Long stamp = Long.parseLong((String)parts.get(2));
        return GraphiteHandler.sample(Timestamp.fromEpochSeconds((long)stamp), resource, name, value);
    }

    private static Sample sample(Timestamp timestamp, Resource resource, String name, Double value) {
        return new Sample(timestamp, resource, name, MetricType.GAUGE, ValueType.compose((Number)value, (MetricType)MetricType.GAUGE));
    }

    private static String index(int index) {
        return String.format("_%d", index);
    }
}

