/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core;

import com.datastax.driver.core.ColumnDefinitions;
import com.datastax.driver.core.DataType;
import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.SimpleStatement;
import com.datastax.driver.core.Statement;
import com.datastax.driver.core.TypeCodec;
import com.datastax.driver.core.exceptions.InvalidTypeException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;

public class BoundStatement
extends Statement {
    final PreparedStatement statement;
    final ByteBuffer[] values;

    public BoundStatement(PreparedStatement statement) {
        this.statement = statement;
        this.values = new ByteBuffer[statement.getVariables().size()];
        if (statement.getConsistencyLevel() != null) {
            this.setConsistencyLevel(statement.getConsistencyLevel());
        }
        if (statement.isTracing()) {
            this.enableTracing();
        }
        if (statement.getRetryPolicy() != null) {
            this.setRetryPolicy(statement.getRetryPolicy());
        }
    }

    public PreparedStatement preparedStatement() {
        return this.statement;
    }

    public boolean isSet(int i) {
        this.metadata().checkBounds(i);
        return this.values[i] != null;
    }

    public boolean isSet(String name) {
        return this.isSet(this.metadata().getFirstIdx(name));
    }

    public BoundStatement bind(Object ... values) {
        if (values.length > this.statement.getVariables().size()) {
            throw new IllegalArgumentException(String.format("Prepared statement has only %d variables, %d values provided", this.statement.getVariables().size(), values.length));
        }
        for (int i = 0; i < values.length; ++i) {
            Object toSet = values[i];
            if (toSet == null) {
                this.setValue(i, null);
                continue;
            }
            DataType columnType = this.statement.getVariables().getType(i);
            switch (columnType.getName()) {
                case LIST: {
                    if (!(toSet instanceof List)) {
                        throw new InvalidTypeException(String.format("Invalid type for value %d, column is a list but %s provided", i, toSet.getClass()));
                    }
                    List l = (List)toSet;
                    if (l.isEmpty()) break;
                    Class<?> providedClass = l.get(0).getClass();
                    Class<?> expectedClass = columnType.getTypeArguments().get(0).asJavaClass();
                    if (expectedClass.isAssignableFrom(providedClass)) break;
                    throw new InvalidTypeException(String.format("Invalid type for value %d of CQL type %s, expecting list of %s but provided list of %s", i, columnType, expectedClass, providedClass));
                }
                case SET: {
                    Class<?> providedClass;
                    Class<?> expectedClass;
                    if (!(toSet instanceof Set)) {
                        throw new InvalidTypeException(String.format("Invalid type for value %d, column is a set but %s provided", i, toSet.getClass()));
                    }
                    Set s = (Set)toSet;
                    if (s.isEmpty() || (expectedClass = columnType.getTypeArguments().get((int)0).getName().javaType).isAssignableFrom(providedClass = s.iterator().next().getClass())) break;
                    throw new InvalidTypeException(String.format("Invalid type for value %d of CQL type %s, expecting set of %s but provided set of %s", i, columnType, expectedClass, providedClass));
                }
                case MAP: {
                    if (!(toSet instanceof Map)) {
                        throw new InvalidTypeException(String.format("Invalid type for value %d, column is a map but %s provided", i, toSet.getClass()));
                    }
                    Map m = (Map)toSet;
                    if (m.isEmpty()) break;
                    Map.Entry entry = m.entrySet().iterator().next();
                    Class<?> providedKeysClass = entry.getKey().getClass();
                    Class<?> providedValuesClass = entry.getValue().getClass();
                    Class<?> expectedKeysClass = columnType.getTypeArguments().get((int)0).getName().javaType;
                    Class<?> expectedValuesClass = columnType.getTypeArguments().get((int)1).getName().javaType;
                    if (expectedKeysClass.isAssignableFrom(providedKeysClass) && expectedValuesClass.isAssignableFrom(providedValuesClass)) break;
                    throw new InvalidTypeException(String.format("Invalid type for value %d of CQL type %s, expecting map of %s->%s but provided set of %s->%s", i, columnType, expectedKeysClass, expectedValuesClass, providedKeysClass, providedValuesClass));
                }
                default: {
                    Class<?> providedClass = toSet.getClass();
                    Class<?> expectedClass = columnType.getName().javaType;
                    if (expectedClass.isAssignableFrom(providedClass)) break;
                    throw new InvalidTypeException(String.format("Invalid type for value %d of CQL type %s, expecting %s but %s provided", i, columnType, expectedClass, providedClass));
                }
            }
            this.setValue(i, columnType.codec().serialize(toSet));
        }
        return this;
    }

    @Override
    public ByteBuffer getRoutingKey() {
        if (this.statement.routingKey != null) {
            return this.statement.routingKey;
        }
        if (this.statement.routingKeyIndexes != null) {
            if (this.statement.routingKeyIndexes.length == 1) {
                return this.values[this.statement.routingKeyIndexes[0]];
            }
            ByteBuffer[] components = new ByteBuffer[this.statement.routingKeyIndexes.length];
            for (int i = 0; i < components.length; ++i) {
                ByteBuffer value = this.values[this.statement.routingKeyIndexes[i]];
                if (value == null) {
                    return null;
                }
                components[i] = value;
            }
            return SimpleStatement.compose(components);
        }
        return null;
    }

    @Override
    public String getKeyspace() {
        return this.statement.metadata.size() == 0 ? null : this.statement.metadata.getKeyspace(0);
    }

    public BoundStatement setBool(int i, boolean v) {
        this.metadata().checkType(i, DataType.Name.BOOLEAN);
        return this.setValue(i, TypeCodec.BooleanCodec.instance.serializeNoBoxing(v));
    }

    public BoundStatement setBool(String name, boolean v) {
        int[] indexes = this.metadata().getAllIdx(name);
        ByteBuffer value = TypeCodec.BooleanCodec.instance.serializeNoBoxing(v);
        for (int i = 0; i < indexes.length; ++i) {
            this.metadata().checkType(indexes[i], DataType.Name.BOOLEAN);
            this.setValue(indexes[i], value);
        }
        return this;
    }

    public BoundStatement setInt(int i, int v) {
        this.metadata().checkType(i, DataType.Name.INT);
        return this.setValue(i, TypeCodec.IntCodec.instance.serializeNoBoxing(v));
    }

    public BoundStatement setInt(String name, int v) {
        int[] indexes = this.metadata().getAllIdx(name);
        ByteBuffer value = TypeCodec.IntCodec.instance.serializeNoBoxing(v);
        for (int i = 0; i < indexes.length; ++i) {
            this.metadata().checkType(indexes[i], DataType.Name.INT);
            this.setValue(indexes[i], value);
        }
        return this;
    }

    public BoundStatement setLong(int i, long v) {
        this.metadata().checkType(i, DataType.Name.BIGINT, DataType.Name.COUNTER);
        return this.setValue(i, TypeCodec.LongCodec.instance.serializeNoBoxing(v));
    }

    public BoundStatement setLong(String name, long v) {
        int[] indexes = this.metadata().getAllIdx(name);
        ByteBuffer value = TypeCodec.LongCodec.instance.serializeNoBoxing(v);
        for (int i = 0; i < indexes.length; ++i) {
            this.metadata().checkType(indexes[i], DataType.Name.BIGINT, DataType.Name.COUNTER);
            this.setValue(indexes[i], value);
        }
        return this;
    }

    public BoundStatement setDate(int i, Date v) {
        this.metadata().checkType(i, DataType.Name.TIMESTAMP);
        return this.setValue(i, v == null ? null : TypeCodec.DateCodec.instance.serialize(v));
    }

    public BoundStatement setDate(String name, Date v) {
        int[] indexes = this.metadata().getAllIdx(name);
        ByteBuffer value = v == null ? null : TypeCodec.DateCodec.instance.serialize(v);
        for (int i = 0; i < indexes.length; ++i) {
            this.metadata().checkType(indexes[i], DataType.Name.TIMESTAMP);
            this.setValue(indexes[i], value);
        }
        return this;
    }

    public BoundStatement setFloat(int i, float v) {
        this.metadata().checkType(i, DataType.Name.FLOAT);
        return this.setValue(i, TypeCodec.FloatCodec.instance.serializeNoBoxing(v));
    }

    public BoundStatement setFloat(String name, float v) {
        int[] indexes = this.metadata().getAllIdx(name);
        ByteBuffer value = TypeCodec.FloatCodec.instance.serializeNoBoxing(v);
        for (int i = 0; i < indexes.length; ++i) {
            this.metadata().checkType(indexes[i], DataType.Name.FLOAT);
            this.setValue(indexes[i], value);
        }
        return this;
    }

    public BoundStatement setDouble(int i, double v) {
        this.metadata().checkType(i, DataType.Name.DOUBLE);
        return this.setValue(i, TypeCodec.DoubleCodec.instance.serializeNoBoxing(v));
    }

    public BoundStatement setDouble(String name, double v) {
        int[] indexes = this.metadata().getAllIdx(name);
        ByteBuffer value = TypeCodec.DoubleCodec.instance.serializeNoBoxing(v);
        for (int i = 0; i < indexes.length; ++i) {
            this.metadata().checkType(indexes[i], DataType.Name.DOUBLE);
            this.setValue(indexes[i], value);
        }
        return this;
    }

    public BoundStatement setString(int i, String v) {
        DataType.Name type = this.metadata().checkType(i, DataType.Name.VARCHAR, DataType.Name.TEXT, DataType.Name.ASCII);
        switch (type) {
            case ASCII: {
                return this.setValue(i, v == null ? null : TypeCodec.StringCodec.asciiInstance.serialize(v));
            }
            case TEXT: 
            case VARCHAR: {
                return this.setValue(i, v == null ? null : TypeCodec.StringCodec.utf8Instance.serialize(v));
            }
        }
        throw new AssertionError();
    }

    public BoundStatement setString(String name, String v) {
        int[] indexes = this.metadata().getAllIdx(name);
        for (int i = 0; i < indexes.length; ++i) {
            this.setString(indexes[i], v);
        }
        return this;
    }

    public BoundStatement setBytes(int i, ByteBuffer v) {
        this.metadata().checkType(i, DataType.Name.BLOB);
        return this.setBytesUnsafe(i, v);
    }

    public BoundStatement setBytes(String name, ByteBuffer v) {
        int[] indexes = this.metadata().getAllIdx(name);
        ByteBuffer value = v == null ? null : v.duplicate();
        for (int i = 0; i < indexes.length; ++i) {
            this.metadata().checkType(indexes[i], DataType.Name.BLOB);
            this.setValue(indexes[i], value);
        }
        return this;
    }

    public BoundStatement setBytesUnsafe(int i, ByteBuffer v) {
        return this.setValue(i, v == null ? null : v.duplicate());
    }

    public BoundStatement setBytesUnsafe(String name, ByteBuffer v) {
        int[] indexes = this.metadata().getAllIdx(name);
        ByteBuffer value = v == null ? null : v.duplicate();
        for (int i = 0; i < indexes.length; ++i) {
            this.setValue(indexes[i], value);
        }
        return this;
    }

    public BoundStatement setVarint(int i, BigInteger v) {
        this.metadata().checkType(i, DataType.Name.VARINT);
        return this.setValue(i, v == null ? null : TypeCodec.BigIntegerCodec.instance.serialize(v));
    }

    public BoundStatement setVarint(String name, BigInteger v) {
        int[] indexes = this.metadata().getAllIdx(name);
        ByteBuffer value = v == null ? null : TypeCodec.BigIntegerCodec.instance.serialize(v);
        for (int i = 0; i < indexes.length; ++i) {
            this.metadata().checkType(indexes[i], DataType.Name.VARINT);
            this.setValue(indexes[i], value);
        }
        return this;
    }

    public BoundStatement setDecimal(int i, BigDecimal v) {
        this.metadata().checkType(i, DataType.Name.DECIMAL);
        return this.setValue(i, v == null ? null : TypeCodec.DecimalCodec.instance.serialize(v));
    }

    public BoundStatement setDecimal(String name, BigDecimal v) {
        int[] indexes = this.metadata().getAllIdx(name);
        ByteBuffer value = v == null ? null : TypeCodec.DecimalCodec.instance.serialize(v);
        for (int i = 0; i < indexes.length; ++i) {
            this.metadata().checkType(indexes[i], DataType.Name.DECIMAL);
            this.setValue(indexes[i], value);
        }
        return this;
    }

    public BoundStatement setUUID(int i, UUID v) {
        DataType.Name type = this.metadata().checkType(i, DataType.Name.UUID, DataType.Name.TIMEUUID);
        if (v == null) {
            return this.setValue(i, null);
        }
        if (type == DataType.Name.TIMEUUID && v.version() != 1) {
            throw new InvalidTypeException(String.format("%s is not a Type 1 (time-based) UUID", v));
        }
        return type == DataType.Name.UUID ? this.setValue(i, TypeCodec.UUIDCodec.instance.serialize(v)) : this.setValue(i, TypeCodec.TimeUUIDCodec.instance.serialize(v));
    }

    public BoundStatement setUUID(String name, UUID v) {
        int[] indexes = this.metadata().getAllIdx(name);
        ByteBuffer value = v == null ? null : TypeCodec.UUIDCodec.instance.serialize(v);
        for (int i = 0; i < indexes.length; ++i) {
            DataType.Name type = this.metadata().checkType(indexes[i], DataType.Name.UUID, DataType.Name.TIMEUUID);
            if (v != null && type == DataType.Name.TIMEUUID && v.version() != 1) {
                throw new InvalidTypeException(String.format("%s is not a Type 1 (time-based) UUID", v));
            }
            this.setValue(indexes[i], value);
        }
        return this;
    }

    public BoundStatement setInet(int i, InetAddress v) {
        this.metadata().checkType(i, DataType.Name.INET);
        return this.setValue(i, v == null ? null : TypeCodec.InetCodec.instance.serialize(v));
    }

    public BoundStatement setInet(String name, InetAddress v) {
        int[] indexes = this.metadata().getAllIdx(name);
        ByteBuffer value = v == null ? null : TypeCodec.InetCodec.instance.serialize(v);
        for (int i = 0; i < indexes.length; ++i) {
            this.metadata().checkType(indexes[i], DataType.Name.INET);
            this.setValue(indexes[i], value);
        }
        return this;
    }

    public <T> BoundStatement setList(int i, List<T> v) {
        DataType type = this.metadata().getType(i);
        if (type.getName() != DataType.Name.LIST) {
            throw new InvalidTypeException(String.format("Column %s is of type %s, cannot set to a list", this.metadata().getName(i), type));
        }
        if (v == null) {
            return this.setValue(i, null);
        }
        if (!v.isEmpty()) {
            Class<?> providedClass = v.get(0).getClass();
            Class<?> expectedClass = type.getTypeArguments().get(0).asJavaClass();
            if (!expectedClass.isAssignableFrom(providedClass)) {
                throw new InvalidTypeException(String.format("Invalid value for column %s of CQL type %s, expecting list of %s but provided list of %s", this.metadata().getName(i), type, expectedClass, providedClass));
            }
        }
        return this.setValue(i, type.codec().serialize(v));
    }

    public <T> BoundStatement setList(String name, List<T> v) {
        int[] indexes = this.metadata().getAllIdx(name);
        for (int i = 0; i < indexes.length; ++i) {
            this.setList(indexes[i], v);
        }
        return this;
    }

    public <K, V> BoundStatement setMap(int i, Map<K, V> v) {
        DataType type = this.metadata().getType(i);
        if (type.getName() != DataType.Name.MAP) {
            throw new InvalidTypeException(String.format("Column %s is of type %s, cannot set to a map", this.metadata().getName(i), type));
        }
        if (v == null) {
            return this.setValue(i, null);
        }
        if (!v.isEmpty()) {
            Map.Entry<K, V> entry = v.entrySet().iterator().next();
            Class<?> providedKeysClass = entry.getKey().getClass();
            Class<?> providedValuesClass = entry.getValue().getClass();
            Class<?> expectedKeysClass = type.getTypeArguments().get((int)0).getName().javaType;
            Class<?> expectedValuesClass = type.getTypeArguments().get((int)1).getName().javaType;
            if (!expectedKeysClass.isAssignableFrom(providedKeysClass) || !expectedValuesClass.isAssignableFrom(providedValuesClass)) {
                throw new InvalidTypeException(String.format("Invalid value for column %s of CQL type %s, expecting map of %s->%s but provided map of %s->%s", this.metadata().getName(i), type, expectedKeysClass, expectedValuesClass, providedKeysClass, providedValuesClass));
            }
        }
        return this.setValue(i, type.codec().serialize(v));
    }

    public <K, V> BoundStatement setMap(String name, Map<K, V> v) {
        int[] indexes = this.metadata().getAllIdx(name);
        for (int i = 0; i < indexes.length; ++i) {
            this.setMap(indexes[i], v);
        }
        return this;
    }

    public <T> BoundStatement setSet(int i, Set<T> v) {
        Class<?> providedClass;
        Class<?> expectedClass;
        DataType type = this.metadata().getType(i);
        if (type.getName() != DataType.Name.SET) {
            throw new InvalidTypeException(String.format("Column %s is of type %s, cannot set to a set", this.metadata().getName(i), type));
        }
        if (v == null) {
            return this.setValue(i, null);
        }
        if (!v.isEmpty() && !(expectedClass = type.getTypeArguments().get((int)0).getName().javaType).isAssignableFrom(providedClass = v.iterator().next().getClass())) {
            throw new InvalidTypeException(String.format("Invalid value for column %s of CQL type %s, expecting set of %s but provided set of %s", this.metadata().getName(i), type, expectedClass, providedClass));
        }
        return this.setValue(i, type.codec().serialize(v));
    }

    public <T> BoundStatement setSet(String name, Set<T> v) {
        int[] indexes = this.metadata().getAllIdx(name);
        for (int i = 0; i < indexes.length; ++i) {
            this.setSet(indexes[i], v);
        }
        return this;
    }

    private ColumnDefinitions metadata() {
        return this.statement.metadata;
    }

    private BoundStatement setValue(int i, ByteBuffer value) {
        this.values[i] = value;
        return this;
    }
}

