/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core;

import com.datastax.driver.core.DataType;
import com.datastax.driver.core.TypeCodec;
import com.datastax.driver.core.exceptions.DriverInternalError;
import com.datastax.driver.core.utils.Bytes;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

class CassandraTypeParser {
    private static final String REVERSED_TYPE = "org.apache.cassandra.db.marshal.ReversedType";
    private static final String COMPOSITE_TYPE = "org.apache.cassandra.db.marshal.CompositeType";
    private static final String COLLECTION_TYPE = "org.apache.cassandra.db.marshal.ColumnToCollectionType";
    private static final String LIST_TYPE = "org.apache.cassandra.db.marshal.ListType";
    private static final String SET_TYPE = "org.apache.cassandra.db.marshal.SetType";
    private static final String MAP_TYPE = "org.apache.cassandra.db.marshal.MapType";
    private static ImmutableMap<String, DataType> cassTypeToDataType = new ImmutableMap.Builder<String, DataType>().put("org.apache.cassandra.db.marshal.AsciiType", DataType.ascii()).put("org.apache.cassandra.db.marshal.LongType", DataType.bigint()).put("org.apache.cassandra.db.marshal.BlobType", DataType.blob()).put("org.apache.cassandra.db.marshal.BooleanType", DataType.cboolean()).put("org.apache.cassandra.db.marshal.CounterColumnType", DataType.counter()).put("org.apache.cassandra.db.marshal.DecimalType", DataType.decimal()).put("org.apache.cassandra.db.marshal.DoubleType", DataType.cdouble()).put("org.apache.cassandra.db.marshal.FloatType", DataType.cfloat()).put("org.apache.cassandra.db.marshal.InetAddressType", DataType.inet()).put("org.apache.cassandra.db.marshal.Int32Type", DataType.cint()).put("org.apache.cassandra.db.marshal.UTF8Type", DataType.text()).put("org.apache.cassandra.db.marshal.TimestampType", DataType.timestamp()).put("org.apache.cassandra.db.marshal.DateType", DataType.timestamp()).put("org.apache.cassandra.db.marshal.UUIDType", DataType.uuid()).put("org.apache.cassandra.db.marshal.IntegerType", DataType.varint()).put("org.apache.cassandra.db.marshal.TimeUUIDType", DataType.timeuuid()).build();

    CassandraTypeParser() {
    }

    static DataType parseOne(String className) {
        List<String> params;
        Parser parser = new Parser(className, 0);
        String next = parser.parseNextName();
        if (CassandraTypeParser.isReversed(next)) {
            List<String> l = parser.getTypeParameters();
            if (l.size() != 1) {
                throw new IllegalStateException();
            }
            className = l.get(0);
        }
        if (className.startsWith(LIST_TYPE)) {
            parser.parseNextName();
            params = parser.getTypeParameters();
            return DataType.list(CassandraTypeParser.parseOne(params.get(0)));
        }
        if (className.startsWith(SET_TYPE)) {
            parser.parseNextName();
            params = parser.getTypeParameters();
            return DataType.set(CassandraTypeParser.parseOne(params.get(0)));
        }
        if (className.startsWith(MAP_TYPE)) {
            parser.parseNextName();
            params = parser.getTypeParameters();
            return DataType.map(CassandraTypeParser.parseOne(params.get(0)), CassandraTypeParser.parseOne(params.get(1)));
        }
        DataType type = cassTypeToDataType.get(className);
        return type == null ? DataType.custom(className) : type;
    }

    public static boolean isReversed(String className) {
        return className.startsWith(REVERSED_TYPE);
    }

    private static boolean isComposite(String className) {
        return className.startsWith(COMPOSITE_TYPE);
    }

    private static boolean isCollection(String className) {
        return className.startsWith(COLLECTION_TYPE);
    }

    static ParseResult parseWithComposite(String className) {
        Parser parser = new Parser(className, 0);
        String next = parser.parseNextName();
        if (!CassandraTypeParser.isComposite(next)) {
            return new ParseResult(CassandraTypeParser.parseOne(className));
        }
        List<String> subClassNames = parser.getTypeParameters();
        int count = subClassNames.size();
        String last = subClassNames.get(count - 1);
        HashMap<String, DataType> collections = new HashMap<String, DataType>();
        if (CassandraTypeParser.isCollection(last)) {
            --count;
            Parser collectionParser = new Parser(last, 0);
            collectionParser.parseNextName();
            Map<String, String> params = collectionParser.getCollectionsParameters();
            for (Map.Entry<String, String> entry : params.entrySet()) {
                collections.put(entry.getKey(), CassandraTypeParser.parseOne(entry.getValue()));
            }
        }
        ArrayList<DataType> types = new ArrayList<DataType>(count);
        for (int i = 0; i < count; ++i) {
            types.add(CassandraTypeParser.parseOne(subClassNames.get(i)));
        }
        return new ParseResult(true, types, collections);
    }

    private static class Parser {
        private final String str;
        private int idx;

        private Parser(String str, int idx) {
            this.str = str;
            this.idx = idx;
        }

        public String parseNextName() {
            this.skipBlank();
            return this.readNextIdentifier();
        }

        public String readOne() {
            String name = this.parseNextName();
            String args = this.readRawArguments();
            return name + args;
        }

        private String readRawArguments() {
            this.skipBlank();
            if (this.isEOS() || this.str.charAt(this.idx) == ')' || this.str.charAt(this.idx) == ',') {
                return "";
            }
            if (this.str.charAt(this.idx) != '(') {
                throw new IllegalStateException(String.format("Expecting char %d of %s to be '(' but '%c' found", this.idx, this.str, Character.valueOf(this.str.charAt(this.idx))));
            }
            int i = this.idx;
            int open = 1;
            while (open > 0) {
                ++this.idx;
                if (this.isEOS()) {
                    throw new IllegalStateException("Non closed parenthesis");
                }
                if (this.str.charAt(this.idx) == '(') {
                    ++open;
                    continue;
                }
                if (this.str.charAt(this.idx) != ')') continue;
                --open;
            }
            ++this.idx;
            return this.str.substring(i, this.idx);
        }

        public List<String> getTypeParameters() {
            ArrayList<String> list = new ArrayList<String>();
            if (this.isEOS()) {
                return list;
            }
            if (this.str.charAt(this.idx) != '(') {
                throw new IllegalStateException();
            }
            ++this.idx;
            while (this.skipBlankAndComma()) {
                if (this.str.charAt(this.idx) == ')') {
                    ++this.idx;
                    return list;
                }
                try {
                    list.add(this.readOne());
                }
                catch (DriverInternalError e) {
                    DriverInternalError ex = new DriverInternalError(String.format("Exception while parsing '%s' around char %d", this.str, this.idx));
                    ex.initCause(e);
                    throw ex;
                }
            }
            throw new DriverInternalError(String.format("Syntax error parsing '%s' at char %d: unexpected end of string", this.str, this.idx));
        }

        public Map<String, String> getCollectionsParameters() {
            HashMap<String, String> map = new HashMap<String, String>();
            if (this.isEOS()) {
                return map;
            }
            if (this.str.charAt(this.idx) != '(') {
                throw new IllegalStateException();
            }
            ++this.idx;
            while (this.skipBlankAndComma()) {
                if (this.str.charAt(this.idx) == ')') {
                    ++this.idx;
                    return map;
                }
                String bbHex = this.readNextIdentifier();
                String name = null;
                try {
                    name = TypeCodec.StringCodec.utf8Instance.deserialize(Bytes.fromHexString("0x" + bbHex));
                }
                catch (NumberFormatException e) {
                    this.throwSyntaxError(e.getMessage());
                }
                this.skipBlank();
                if (this.str.charAt(this.idx) != ':') {
                    this.throwSyntaxError("expecting ':' token");
                }
                ++this.idx;
                this.skipBlank();
                try {
                    map.put(name, this.readOne());
                }
                catch (DriverInternalError e) {
                    DriverInternalError ex = new DriverInternalError(String.format("Exception while parsing '%s' around char %d", this.str, this.idx));
                    ex.initCause(e);
                    throw ex;
                }
            }
            throw new DriverInternalError(String.format("Syntax error parsing '%s' at char %d: unexpected end of string", this.str, this.idx));
        }

        private void throwSyntaxError(String msg) {
            throw new DriverInternalError(String.format("Syntax error parsing '%s' at char %d: %s", this.str, this.idx, msg));
        }

        private boolean isEOS() {
            return Parser.isEOS(this.str, this.idx);
        }

        private static boolean isEOS(String str, int i) {
            return i >= str.length();
        }

        private static boolean isBlank(int c) {
            return c == 32 || c == 9 || c == 10;
        }

        private void skipBlank() {
            this.idx = Parser.skipBlank(this.str, this.idx);
        }

        private static int skipBlank(String str, int i) {
            while (!Parser.isEOS(str, i) && Parser.isBlank(str.charAt(i))) {
                ++i;
            }
            return i;
        }

        private boolean skipBlankAndComma() {
            boolean commaFound = false;
            while (!this.isEOS()) {
                char c = this.str.charAt(this.idx);
                if (c == ',') {
                    if (commaFound) {
                        return true;
                    }
                    commaFound = true;
                } else if (!Parser.isBlank(c)) {
                    return true;
                }
                ++this.idx;
            }
            return false;
        }

        private static boolean isIdentifierChar(int c) {
            return c >= 48 && c <= 57 || c >= 97 && c <= 122 || c >= 65 && c <= 90 || c == 45 || c == 43 || c == 46 || c == 95 || c == 38;
        }

        public String readNextIdentifier() {
            int i = this.idx;
            while (!this.isEOS() && Parser.isIdentifierChar(this.str.charAt(this.idx))) {
                ++this.idx;
            }
            return this.str.substring(i, this.idx);
        }

        public char readNextChar() {
            this.skipBlank();
            return this.str.charAt(this.idx++);
        }
    }

    static class ParseResult {
        public final boolean isComposite;
        public final List<DataType> types;
        public final Map<String, DataType> collections;

        private ParseResult(DataType type) {
            this(false, Collections.singletonList(type), Collections.emptyMap());
        }

        private ParseResult(boolean isComposite, List<DataType> types, Map<String, DataType> collections) {
            this.isComposite = isComposite;
            this.types = types;
            this.collections = collections;
        }
    }
}

