/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core;

import com.datastax.driver.core.BoundStatement;
import com.datastax.driver.core.ColumnDefinitions;
import com.datastax.driver.core.ColumnMetadata;
import com.datastax.driver.core.ConsistencyLevel;
import com.datastax.driver.core.KeyspaceMetadata;
import com.datastax.driver.core.MD5Digest;
import com.datastax.driver.core.Metadata;
import com.datastax.driver.core.Responses;
import com.datastax.driver.core.SimpleStatement;
import com.datastax.driver.core.TableMetadata;
import com.datastax.driver.core.policies.RetryPolicy;
import java.nio.ByteBuffer;
import java.util.List;

public class PreparedStatement {
    final ColumnDefinitions metadata;
    final ColumnDefinitions resultSetMetadata;
    final MD5Digest id;
    final String query;
    final String queryKeyspace;
    volatile ByteBuffer routingKey;
    final int[] routingKeyIndexes;
    volatile ConsistencyLevel consistency;
    volatile boolean traceQuery;
    volatile RetryPolicy retryPolicy;

    private PreparedStatement(ColumnDefinitions metadata, ColumnDefinitions resultSetMetadata, MD5Digest id, int[] routingKeyIndexes, String query, String queryKeyspace) {
        this.metadata = metadata;
        this.resultSetMetadata = resultSetMetadata;
        this.id = id;
        this.routingKeyIndexes = routingKeyIndexes;
        this.query = query;
        this.queryKeyspace = queryKeyspace;
    }

    static PreparedStatement fromMessage(Responses.Result.Prepared msg, Metadata clusterMetadata, String query, String queryKeyspace) {
        TableMetadata tm;
        assert (msg.metadata.columns != null);
        ColumnDefinitions defs = msg.metadata.columns;
        if (defs.size() == 0) {
            return new PreparedStatement(defs, msg.resultMetadata.columns, msg.statementId, null, query, queryKeyspace);
        }
        List<ColumnMetadata> partitionKeyColumns = null;
        int[] pkIndexes = null;
        KeyspaceMetadata km = clusterMetadata.getKeyspace(defs.getKeyspace(0));
        if (km != null && (tm = km.getTable(defs.getTable(0))) != null) {
            partitionKeyColumns = tm.getPartitionKey();
            pkIndexes = new int[partitionKeyColumns.size()];
            for (int i = 0; i < pkIndexes.length; ++i) {
                pkIndexes[i] = -1;
            }
        }
        for (int i = 0; i < defs.size(); ++i) {
            PreparedStatement.maybeGetIndex(defs.getName(i), i, partitionKeyColumns, pkIndexes);
        }
        return new PreparedStatement(defs, msg.resultMetadata.columns, msg.statementId, (int[])(PreparedStatement.allSet(pkIndexes) ? pkIndexes : null), query, queryKeyspace);
    }

    private static void maybeGetIndex(String name, int j, List<ColumnMetadata> pkColumns, int[] pkIndexes) {
        if (pkColumns == null) {
            return;
        }
        for (int i = 0; i < pkColumns.size(); ++i) {
            if (!name.equals(pkColumns.get(i).getName())) continue;
            pkIndexes[i] = j;
            return;
        }
    }

    private static boolean allSet(int[] pkColumns) {
        if (pkColumns == null) {
            return false;
        }
        for (int i = 0; i < pkColumns.length; ++i) {
            if (pkColumns[i] >= 0) continue;
            return false;
        }
        return true;
    }

    public ColumnDefinitions getVariables() {
        return this.metadata;
    }

    public BoundStatement bind(Object ... values) {
        BoundStatement bs = new BoundStatement(this);
        return bs.bind(values);
    }

    public PreparedStatement setRoutingKey(ByteBuffer routingKey) {
        this.routingKey = routingKey;
        return this;
    }

    public PreparedStatement setRoutingKey(ByteBuffer ... routingKeyComponents) {
        this.routingKey = SimpleStatement.compose(routingKeyComponents);
        return this;
    }

    public PreparedStatement setConsistencyLevel(ConsistencyLevel consistency) {
        this.consistency = consistency;
        return this;
    }

    public ConsistencyLevel getConsistencyLevel() {
        return this.consistency;
    }

    public String getQueryString() {
        return this.query;
    }

    public String getQueryKeyspace() {
        return this.queryKeyspace;
    }

    public PreparedStatement enableTracing() {
        this.traceQuery = true;
        return this;
    }

    public PreparedStatement disableTracing() {
        this.traceQuery = false;
        return this;
    }

    public boolean isTracing() {
        return this.traceQuery;
    }

    public PreparedStatement setRetryPolicy(RetryPolicy policy) {
        this.retryPolicy = policy;
        return this;
    }

    public RetryPolicy getRetryPolicy() {
        return this.retryPolicy;
    }
}

