/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core;

import com.datastax.driver.core.Connection;
import com.datastax.driver.core.ConnectionException;
import com.datastax.driver.core.ExecutionInfo;
import com.datastax.driver.core.Message;
import com.datastax.driver.core.RequestHandler;
import com.datastax.driver.core.Responses;
import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.Statement;
import com.datastax.driver.core.exceptions.DriverException;
import com.datastax.driver.core.exceptions.DriverInternalError;
import com.google.common.util.concurrent.AbstractFuture;
import com.google.common.util.concurrent.Uninterruptibles;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResultSetFuture
extends AbstractFuture<ResultSet> {
    private static final Logger logger = LoggerFactory.getLogger(ResultSetFuture.class);
    private final Session.Manager session;
    final ResponseCallback callback;

    ResultSetFuture(Session.Manager session, Message.Request request) {
        this.session = session;
        this.callback = new ResponseCallback(request);
    }

    void setResult(ResultSet rs) {
        this.set(rs);
    }

    public ResultSet getUninterruptibly() {
        try {
            return Uninterruptibles.getUninterruptibly(this);
        }
        catch (ExecutionException e) {
            throw ResultSetFuture.extractCauseFromExecutionException(e);
        }
    }

    public ResultSet getUninterruptibly(long timeout, TimeUnit unit) throws TimeoutException {
        try {
            return Uninterruptibles.getUninterruptibly(this, timeout, unit);
        }
        catch (ExecutionException e) {
            throw ResultSetFuture.extractCauseFromExecutionException(e);
        }
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        if (!super.cancel(mayInterruptIfRunning)) {
            return false;
        }
        this.callback.handler.cancel();
        return true;
    }

    static RuntimeException extractCauseFromExecutionException(ExecutionException e) {
        if (e.getCause() instanceof DriverException) {
            throw ((DriverException)e.getCause()).copy();
        }
        throw new DriverInternalError("Unexpected exception thrown", e.getCause());
    }

    class ResponseCallback
    implements RequestHandler.Callback {
        private final Message.Request request;
        private volatile RequestHandler handler;

        ResponseCallback(Message.Request request) {
            this.request = request;
        }

        @Override
        public void register(RequestHandler handler) {
            this.handler = handler;
        }

        @Override
        public Message.Request request() {
            return this.request;
        }

        @Override
        public void onSet(Connection connection, Message.Response response, ExecutionInfo info, Statement statement, long latency) {
            try {
                block1 : switch (response.type) {
                    case RESULT: {
                        Responses.Result rm = (Responses.Result)response;
                        switch (rm.kind) {
                            case SET_KEYSPACE: {
                                ((ResultSetFuture)ResultSetFuture.this).session.poolsState.setKeyspace(((Responses.Result.SetKeyspace)rm).keyspace);
                                ResultSetFuture.this.set(ResultSet.fromMessage(rm, ResultSetFuture.this.session, info, statement));
                                break block1;
                            }
                            case SCHEMA_CHANGE: {
                                Responses.Result.SchemaChange scc = (Responses.Result.SchemaChange)rm;
                                ResultSet rs = ResultSet.fromMessage(rm, ResultSetFuture.this.session, info, statement);
                                switch (scc.change) {
                                    case CREATED: {
                                        if (scc.columnFamily.isEmpty()) {
                                            ((ResultSetFuture)ResultSetFuture.this).session.cluster.manager.refreshSchema(connection, ResultSetFuture.this, rs, null, null);
                                            break block1;
                                        }
                                        ((ResultSetFuture)ResultSetFuture.this).session.cluster.manager.refreshSchema(connection, ResultSetFuture.this, rs, scc.keyspace, null);
                                        break block1;
                                    }
                                    case DROPPED: {
                                        if (scc.columnFamily.isEmpty()) {
                                            ((ResultSetFuture)ResultSetFuture.this).session.cluster.manager.refreshSchema(connection, ResultSetFuture.this, rs, null, null);
                                            break block1;
                                        }
                                        ((ResultSetFuture)ResultSetFuture.this).session.cluster.manager.refreshSchema(connection, ResultSetFuture.this, rs, scc.keyspace, null);
                                        break block1;
                                    }
                                    case UPDATED: {
                                        if (scc.columnFamily.isEmpty()) {
                                            ((ResultSetFuture)ResultSetFuture.this).session.cluster.manager.refreshSchema(connection, ResultSetFuture.this, rs, scc.keyspace, null);
                                            break block1;
                                        }
                                        ((ResultSetFuture)ResultSetFuture.this).session.cluster.manager.refreshSchema(connection, ResultSetFuture.this, rs, scc.keyspace, scc.columnFamily);
                                        break block1;
                                    }
                                }
                                logger.info("Ignoring unknown schema change result");
                                break block1;
                            }
                        }
                        ResultSetFuture.this.set(ResultSet.fromMessage(rm, ResultSetFuture.this.session, info, statement));
                        break;
                    }
                    case ERROR: {
                        ResultSetFuture.this.setException(((Responses.Error)response).asException(connection.address));
                        break;
                    }
                    default: {
                        connection.defunct(new ConnectionException(connection.address, String.format("Got unexpected %s response", new Object[]{response.type})));
                        ResultSetFuture.this.setException(new DriverInternalError(String.format("Got unexpected %s response from %s", new Object[]{response.type, connection.address})));
                    }
                }
            }
            catch (RuntimeException e) {
                ResultSetFuture.this.setException(new DriverInternalError("Unexpected error while processing response from " + connection.address, e));
            }
        }

        @Override
        public void onSet(Connection connection, Message.Response response, long latency) {
            this.onSet(connection, response, null, null, latency);
        }

        @Override
        public void onException(Connection connection, Exception exception, long latency) {
            ResultSetFuture.this.setException(exception);
        }

        @Override
        public void onTimeout(Connection connection, long latency) {
            ResultSetFuture.this.setException(new ConnectionException(connection.address, "Operation Timeouted"));
        }
    }
}

