/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server;

import java.io.IOException;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicLong;
import org.eclipse.jetty.io.Connection;
import org.eclipse.jetty.util.annotation.ManagedObject;
import org.eclipse.jetty.util.annotation.ManagedOperation;
import org.eclipse.jetty.util.component.AbstractLifeCycle;
import org.eclipse.jetty.util.component.ContainerLifeCycle;
import org.eclipse.jetty.util.component.Dumpable;
import org.eclipse.jetty.util.statistic.CounterStatistic;
import org.eclipse.jetty.util.statistic.SampleStatistic;

@ManagedObject(value="Connector Statistics")
public class ConnectorStatistics
extends AbstractLifeCycle
implements Dumpable,
Connection.Listener {
    private final AtomicLong _startMillis = new AtomicLong(-1L);
    private final CounterStatistic _connectionStats = new CounterStatistic();
    private final SampleStatistic _messagesIn = new SampleStatistic();
    private final SampleStatistic _messagesOut = new SampleStatistic();
    private final SampleStatistic _connectionDurationStats = new SampleStatistic();

    @Override
    public void onOpened(Connection connection) {
        this.connectionOpened();
    }

    @Override
    public void onClosed(Connection connection) {
        this.connectionClosed(System.currentTimeMillis() - connection.getCreatedTimeStamp(), connection.getMessagesIn(), connection.getMessagesOut());
    }

    public int getBytesIn() {
        return -1;
    }

    public int getBytesOut() {
        return -1;
    }

    public int getConnections() {
        return (int)this._connectionStats.getTotal();
    }

    public long getConnectionsDurationMax() {
        return this._connectionDurationStats.getMax();
    }

    public double getConnectionsDurationMean() {
        return this._connectionDurationStats.getMean();
    }

    public double getConnectionsDurationStdDev() {
        return this._connectionDurationStats.getStdDev();
    }

    public long getConnectionsDurationTotal() {
        return this._connectionDurationStats.getTotal();
    }

    public int getConnectionsMessagesInMax() {
        return (int)this._messagesIn.getMax();
    }

    public double getConnectionsMessagesInMean() {
        return this._messagesIn.getMean();
    }

    public double getConnectionsMessagesInStdDev() {
        return this._messagesIn.getStdDev();
    }

    public int getConnectionsOpen() {
        return (int)this._connectionStats.getCurrent();
    }

    public int getConnectionsOpenMax() {
        return (int)this._connectionStats.getMax();
    }

    public int getMessagesIn() {
        return (int)this._messagesIn.getTotal();
    }

    public int getMessagesOut() {
        return (int)this._messagesIn.getTotal();
    }

    public long getStartedMillis() {
        long start = this._startMillis.get();
        return start < 0L ? 0L : System.currentTimeMillis() - start;
    }

    @Override
    public void doStart() {
        this.reset();
    }

    @Override
    public void doStop() {
    }

    public void reset() {
        this._startMillis.set(System.currentTimeMillis());
        this._messagesIn.reset();
        this._messagesOut.reset();
        this._connectionStats.reset();
        this._connectionDurationStats.reset();
    }

    public void connectionOpened() {
        if (this.isStarted()) {
            this._connectionStats.increment();
        }
    }

    public void connectionUpgraded(int messagesIn, int messagesOut) {
        if (this.isStarted()) {
            this._messagesIn.set(messagesIn);
            this._messagesOut.set(messagesOut);
        }
    }

    public void connectionClosed(long duration, int messagesIn, int messagesOut) {
        if (this.isStarted()) {
            this._messagesIn.set(messagesIn);
            this._messagesOut.set(messagesOut);
            this._connectionStats.decrement();
            this._connectionDurationStats.set(duration);
        }
    }

    @Override
    @ManagedOperation(value="dump thread state")
    public String dump() {
        return ContainerLifeCycle.dump(this);
    }

    @Override
    public void dump(Appendable out, String indent) throws IOException {
        ContainerLifeCycle.dumpObject(out, this);
        ContainerLifeCycle.dump(out, indent, Arrays.asList("connections=" + this._connectionStats, "duration=" + this._connectionDurationStats, "in=" + this._messagesIn, "out=" + this._messagesOut));
    }
}

