/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.newts.aggregate;

import com.google.common.base.Preconditions;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import org.opennms.newts.aggregate.IntervalGenerator;
import org.opennms.newts.api.Duration;
import org.opennms.newts.api.Measurement;
import org.opennms.newts.api.Resource;
import org.opennms.newts.api.Results;
import org.opennms.newts.api.Timestamp;
import org.opennms.newts.api.query.Datasource;
import org.opennms.newts.api.query.ResultDescriptor;

class Aggregation
implements Iterable<Results.Row<Measurement>>,
Iterator<Results.Row<Measurement>> {
    private final ResultDescriptor m_resultDescriptor;
    private final Resource m_resource;
    private final Iterator<Timestamp> m_timestamps;
    private final Duration m_resolution;
    private final Iterator<Results.Row<Measurement>> m_input;
    private final double m_intervalsPer;
    private Results.Row<Measurement> m_working;
    private Results.Row<Measurement> m_nextOut;

    Aggregation(Resource resource, Timestamp start, Timestamp end, ResultDescriptor resultDescriptor, Duration resolution, Iterator<Results.Row<Measurement>> input) {
        this.m_resultDescriptor = Preconditions.checkNotNull(resultDescriptor, "result descriptor argument");
        this.m_resource = Preconditions.checkNotNull(resource, "resource argument");
        Preconditions.checkNotNull(start, "start argument");
        Preconditions.checkNotNull(end, "end argument");
        this.m_resolution = Preconditions.checkNotNull(resolution, "resolution argument");
        this.m_input = Preconditions.checkNotNull(input, "input argument");
        Duration interval = resultDescriptor.getInterval();
        Preconditions.checkArgument(resolution.isMultiple(interval), "resolution must be a multiple of interval");
        this.m_timestamps = new IntervalGenerator(start.stepFloor(this.m_resolution), end.stepCeiling(this.m_resolution), this.m_resolution);
        this.m_intervalsPer = resolution.divideBy(interval);
        this.m_working = this.m_input.hasNext() ? this.m_input.next() : null;
        Results.Row row = this.m_nextOut = this.m_timestamps.hasNext() ? new Results.Row(this.m_timestamps.next(), this.m_resource) : null;
        if (this.m_nextOut != null) {
            while (this.m_working != null && this.m_working.getTimestamp().lte(this.m_nextOut.getTimestamp().minus(this.m_resolution))) {
                this.m_working = this.nextWorking();
            }
        }
    }

    @Override
    public boolean hasNext() {
        return this.m_nextOut != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Results.Row<Measurement> next() {
        Results.Row<Measurement> row;
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        ArrayListMultimap<String, Double> values = ArrayListMultimap.create();
        HashMap aggregatedAttrs = Maps.newHashMap();
        while (this.inRange()) {
            for (Datasource ds : this.getDatasources()) {
                Measurement metric = this.m_working.getElement(ds.getSource());
                values.put(ds.getLabel(), metric != null ? metric.getValue() : Double.NaN);
                HashMap<String, String> metricAttrs = (HashMap<String, String>)aggregatedAttrs.get(ds.getLabel());
                if (metricAttrs == null) {
                    metricAttrs = Maps.newHashMap();
                    aggregatedAttrs.put(ds.getLabel(), metricAttrs);
                }
                if (metric.getAttributes() == null) continue;
                metricAttrs.putAll(metric.getAttributes());
            }
            this.m_working = this.nextWorking();
        }
        for (Datasource ds : this.getDatasources()) {
            Double v = this.aggregate(ds, values.get(ds.getLabel()));
            Map attrs = (Map)aggregatedAttrs.get(ds.getLabel());
            this.m_nextOut.addElement(new Measurement(this.m_nextOut.getTimestamp(), this.m_resource, ds.getLabel(), v, attrs));
        }
        try {
            row = this.m_nextOut;
            this.m_nextOut = this.m_timestamps.hasNext() ? new Results.Row(this.m_timestamps.next(), this.m_resource) : null;
        }
        catch (Throwable throwable) {
            this.m_nextOut = this.m_timestamps.hasNext() ? new Results.Row(this.m_timestamps.next(), this.m_resource) : null;
            throw throwable;
        }
        return row;
    }

    private Double aggregate(Datasource ds, Collection<Double> values) {
        return (double)values.size() / this.m_intervalsPer > ds.getXff() ? ds.getAggregationFuction().apply(values) : Double.NaN;
    }

    private boolean inRange() {
        if (this.m_working == null || this.m_nextOut == null) {
            return false;
        }
        Timestamp rangeUpper = this.m_nextOut.getTimestamp();
        Timestamp rangeLower = this.m_nextOut.getTimestamp().minus(this.m_resolution);
        return this.m_working.getTimestamp().lte(rangeUpper) && this.m_working.getTimestamp().gt(rangeLower);
    }

    private Results.Row<Measurement> nextWorking() {
        return this.m_input.hasNext() ? this.m_input.next() : null;
    }

    private Collection<Datasource> getDatasources() {
        return this.m_resultDescriptor.getDatasources().values();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Iterator<Results.Row<Measurement>> iterator() {
        return this;
    }
}

