/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.newts.aggregate;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.opennms.newts.api.Measurement;
import org.opennms.newts.api.Results;
import org.opennms.newts.api.query.Calculation;
import org.opennms.newts.api.query.ResultDescriptor;

class Compute
implements Iterator<Results.Row<Measurement>>,
Iterable<Results.Row<Measurement>> {
    private final ResultDescriptor m_resultDescriptor;
    private final Iterator<Results.Row<Measurement>> m_input;

    Compute(ResultDescriptor resultDescriptor, Iterator<Results.Row<Measurement>> input) {
        this.m_resultDescriptor = Preconditions.checkNotNull(resultDescriptor, "result descriptor argument");
        this.m_input = Preconditions.checkNotNull(input, "input argument");
    }

    @Override
    public boolean hasNext() {
        return this.m_input.hasNext();
    }

    @Override
    public Results.Row<Measurement> next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        Results.Row<Measurement> row = this.m_input.next();
        for (Calculation calc : this.m_resultDescriptor.getCalculations().values()) {
            double v = calc.getCalculationFunction().apply(this.getValues(row, calc.getArgs()));
            row.addElement(new Measurement(row.getTimestamp(), row.getResource(), calc.getLabel(), v));
        }
        return row;
    }

    private double[] getValues(Results.Row<Measurement> row, String[] names) {
        double[] values = new double[names.length];
        for (int i = 0; i < names.length; ++i) {
            String name = names[i];
            Optional<Double> d = this.parseDouble(name);
            values[i] = d.isPresent() ? d.get() : Preconditions.checkNotNull(row.getElement(name), "Missing measurement; Upstream iterator is bugged").getValue();
        }
        return values;
    }

    Optional<Double> parseDouble(String maybeNum) {
        try {
            return Optional.of(Double.parseDouble(maybeNum));
        }
        catch (NumberFormatException e) {
            return Optional.absent();
        }
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Iterator<Results.Row<Measurement>> iterator() {
        return this;
    }
}

