/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.newts.aggregate;

import com.google.common.base.Preconditions;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.opennms.newts.api.Duration;
import org.opennms.newts.api.Timestamp;

public class IntervalGenerator
implements Iterator<Timestamp>,
Iterable<Timestamp> {
    private final Duration m_interval;
    private final Timestamp m_final;
    private final boolean m_reversed;
    private Timestamp m_current;

    public IntervalGenerator(Timestamp start, Timestamp finish, Duration interval) {
        this(start, finish, interval, false);
    }

    public IntervalGenerator(Timestamp start, Timestamp finish, Duration interval, boolean reversed) {
        this.m_interval = Preconditions.checkNotNull(interval, "interval argument");
        Preconditions.checkNotNull(start, "start argument");
        Preconditions.checkNotNull(finish, "finish argument");
        this.m_current = reversed ? finish : start;
        this.m_final = reversed ? start : finish;
        this.m_reversed = reversed;
    }

    @Override
    public boolean hasNext() {
        return this.m_reversed ? this.m_current.gte(this.m_final) : this.m_current.lte(this.m_final);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Timestamp next() {
        Timestamp timestamp;
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        try {
            timestamp = this.m_current;
            this.m_current = this.m_reversed ? this.m_current.minus(this.m_interval) : this.m_current.plus(this.m_interval);
        }
        catch (Throwable throwable) {
            this.m_current = this.m_reversed ? this.m_current.minus(this.m_interval) : this.m_current.plus(this.m_interval);
            throw throwable;
        }
        return timestamp;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Iterator<Timestamp> iterator() {
        return this;
    }
}

