/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.newts.aggregate;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import org.opennms.newts.aggregate.IntervalGenerator;
import org.opennms.newts.api.Duration;
import org.opennms.newts.api.Measurement;
import org.opennms.newts.api.MetricType;
import org.opennms.newts.api.Resource;
import org.opennms.newts.api.Results;
import org.opennms.newts.api.Sample;
import org.opennms.newts.api.Timestamp;
import org.opennms.newts.api.ValueType;
import org.opennms.newts.api.query.Datasource;
import org.opennms.newts.api.query.ResultDescriptor;

class PrimaryData
implements Iterator<Results.Row<Measurement>>,
Iterable<Results.Row<Measurement>> {
    private final ResultDescriptor m_resultDescriptor;
    private final Resource m_resource;
    private final Iterator<Timestamp> m_timestamps;
    private final Duration m_interval;
    private final Iterator<Results.Row<Sample>> m_input;
    private final Map<String, Sample> m_lastUpdates = Maps.newHashMap();
    private final Map<String, Accumulation> m_accumulation = Maps.newHashMap();
    private Results.Row<Sample> m_current = null;

    PrimaryData(Resource resource, Timestamp start, Timestamp end, ResultDescriptor resultDescriptor, Iterator<Results.Row<Sample>> input) {
        this.m_resultDescriptor = Preconditions.checkNotNull(resultDescriptor, "result descriptor argument");
        this.m_resource = Preconditions.checkNotNull(resource, "resource argument");
        Preconditions.checkNotNull(start, "start argument");
        Preconditions.checkNotNull(end, "end argument");
        this.m_input = Preconditions.checkNotNull(input, "input argument");
        this.m_interval = resultDescriptor.getInterval();
        this.m_timestamps = new IntervalGenerator(start.stepFloor(this.m_interval), end.stepCeiling(this.m_interval), this.m_interval);
        if (this.m_input.hasNext()) {
            this.m_current = this.m_input.next();
        }
    }

    @Override
    public boolean hasNext() {
        return this.m_timestamps.hasNext();
    }

    @Override
    public Results.Row<Measurement> next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        Results.Row<Measurement> output = new Results.Row<Measurement>(this.m_timestamps.next(), this.m_resource);
        while (this.m_current != null) {
            this.accumulate(this.m_current, output.getTimestamp());
            if (this.m_current.getTimestamp().gte(output.getTimestamp())) break;
            if (this.m_input.hasNext()) {
                this.m_current = this.m_input.next();
                continue;
            }
            this.m_current = null;
        }
        for (Datasource ds : this.m_resultDescriptor.getDatasources().values()) {
            Accumulation accumulation = this.getOrCreateAccumulation(ds.getSource());
            output.addElement(new Measurement(output.getTimestamp(), output.getResource(), ds.getSource(), accumulation.getAverage(), accumulation.getAttributes()));
            if (this.m_current != null) {
                accumulation.reset();
                Sample sample = this.m_current.getElement(ds.getSource());
                if (sample == null || !this.m_current.getTimestamp().gt(output.getTimestamp())) continue;
                Duration elapsed = this.m_current.getTimestamp().minus(output.getTimestamp());
                accumulation.accumulateValue(elapsed, ds.getHeartbeat(), (ValueType)sample.getValue());
                accumulation.accumlateAttrs(sample.getAttributes());
                continue;
            }
            accumulation.reset();
        }
        return output;
    }

    private void accumulate(Results.Row<Sample> row, Timestamp intervalCeiling) {
        for (Datasource ds : this.m_resultDescriptor.getDatasources().values()) {
            Sample current = row.getElement(ds.getSource());
            if (current == null) continue;
            Sample last = this.m_lastUpdates.get(current.getName());
            if (last == null) {
                this.m_lastUpdates.put(current.getName(), current);
                continue;
            }
            if (intervalCeiling.lt(last.getTimestamp())) continue;
            Duration elapsed = current.getTimestamp().gt(intervalCeiling) ? intervalCeiling.minus(last.getTimestamp()) : current.getTimestamp().minus(last.getTimestamp());
            this.getOrCreateAccumulation(current.getName()).accumulateValue(elapsed, ds.getHeartbeat(), (ValueType)current.getValue()).accumlateAttrs(current.getAttributes());
            if (current.getTimestamp().gt(intervalCeiling.plus(this.m_interval))) continue;
            this.m_lastUpdates.put(current.getName(), current);
        }
    }

    private Accumulation getOrCreateAccumulation(String name) {
        Accumulation result = this.m_accumulation.get(name);
        if (result == null) {
            result = new Accumulation();
            this.m_accumulation.put(name, result);
        }
        return result;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Iterator<Results.Row<Measurement>> iterator() {
        return this;
    }

    private class Accumulation {
        private long m_known;
        private long m_unknown;
        private ValueType<?> m_value;
        private Map<String, String> m_attributes = Maps.newHashMap();

        private Accumulation() {
            this.reset();
        }

        private Accumulation accumulateValue(Duration elapsed, Duration heartbeat, ValueType<?> value) {
            if (elapsed.lt(heartbeat)) {
                this.m_known += elapsed.asMillis();
                this.m_value = this.m_value.plus(value.times(elapsed.asMillis()));
            } else {
                this.m_unknown += elapsed.asMillis();
            }
            return this;
        }

        private Accumulation accumlateAttrs(Map<String, String> attributes) {
            if (attributes != null) {
                this.m_attributes.putAll(attributes);
            }
            return this;
        }

        private Double getAverage() {
            return this.isValid() ? this.m_value.divideBy(this.m_known).doubleValue() : Double.NaN;
        }

        private long getKnown() {
            return this.m_known;
        }

        private long getUnknown() {
            return this.m_unknown;
        }

        private double getElapsed() {
            return this.getKnown() + this.getUnknown();
        }

        private boolean isValid() {
            return (double)this.getUnknown() < this.getElapsed() / 2.0;
        }

        private void reset() {
            this.m_unknown = 0L;
            this.m_known = 0L;
            this.m_value = ValueType.compose(0, MetricType.GAUGE);
            this.m_attributes = Maps.newHashMap();
        }

        private Map<String, String> getAttributes() {
            return this.m_attributes;
        }
    }
}

