/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.newts.aggregate;

import com.google.common.base.Preconditions;
import java.util.Iterator;
import org.opennms.newts.aggregate.Aggregation;
import org.opennms.newts.aggregate.Compute;
import org.opennms.newts.aggregate.Export;
import org.opennms.newts.aggregate.PrimaryData;
import org.opennms.newts.aggregate.Rate;
import org.opennms.newts.api.Duration;
import org.opennms.newts.api.Measurement;
import org.opennms.newts.api.Resource;
import org.opennms.newts.api.Results;
import org.opennms.newts.api.Sample;
import org.opennms.newts.api.Timestamp;
import org.opennms.newts.api.query.ResultDescriptor;

public class ResultProcessor {
    private final Resource m_resource;
    private final Timestamp m_start;
    private final Timestamp m_end;
    private final ResultDescriptor m_resultDescriptor;
    private final Duration m_resolution;

    public ResultProcessor(Resource resource, Timestamp start, Timestamp end, ResultDescriptor descriptor, Duration resolution) {
        this.m_resource = Preconditions.checkNotNull(resource, "resource argument");
        this.m_start = Preconditions.checkNotNull(start, "start argument");
        this.m_end = Preconditions.checkNotNull(end, "end argument");
        this.m_resultDescriptor = Preconditions.checkNotNull(descriptor, "result descriptor argument");
        this.m_resolution = Preconditions.checkNotNull(resolution, "resolution argument");
    }

    public Results<Measurement> process(Iterator<Results.Row<Sample>> samples) {
        Preconditions.checkNotNull(samples, "samples argument");
        Rate rate = new Rate(samples, this.m_resultDescriptor.getSourceNames());
        PrimaryData primaryData = new PrimaryData(this.m_resource, this.m_start.minus(this.m_resolution), this.m_end, this.m_resultDescriptor, rate);
        Aggregation aggregation = new Aggregation(this.m_resource, this.m_start, this.m_end, this.m_resultDescriptor, this.m_resolution, primaryData);
        Compute compute = new Compute(this.m_resultDescriptor, aggregation);
        Export exports = new Export(this.m_resultDescriptor.getExports(), compute);
        Results<Measurement> measurements = new Results<Measurement>();
        for (Results.Row<Measurement> row : exports) {
            measurements.addRow(row);
        }
        return measurements;
    }
}

