/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.newts.api;

import com.google.common.base.Preconditions;
import java.util.Map;
import org.opennms.newts.api.Context;
import org.opennms.newts.api.Element;
import org.opennms.newts.api.MetricType;
import org.opennms.newts.api.Resource;
import org.opennms.newts.api.Timestamp;
import org.opennms.newts.api.ValueType;

public class Sample
implements Element<ValueType<?>> {
    private final Timestamp m_timestamp;
    private final Context m_context;
    private final Resource m_resource;
    private final String m_name;
    private final MetricType m_type;
    private final ValueType<?> m_value;
    private final Map<String, String> m_attributes;

    public Sample(Timestamp timestamp, Resource resource, String name, MetricType type, ValueType<?> value) {
        this(timestamp, Context.DEFAULT_CONTEXT, resource, name, type, value, null);
    }

    public Sample(Timestamp timestamp, Resource resource, String name, MetricType type, ValueType<?> value, Map<String, String> attributes) {
        this(timestamp, Context.DEFAULT_CONTEXT, resource, name, type, value, attributes);
    }

    public Sample(Timestamp timestamp, Context context, Resource resource, String name, MetricType type, ValueType<?> value) {
        this(timestamp, context, resource, name, type, value, null);
    }

    public Sample(Timestamp timestamp, Context context, Resource resource, String name, MetricType type, ValueType<?> value, Map<String, String> attributes) {
        this.m_timestamp = Preconditions.checkNotNull(timestamp, "timestamp");
        this.m_context = Preconditions.checkNotNull(context, "context argument");
        this.m_resource = Preconditions.checkNotNull(resource, "resource");
        this.m_name = Preconditions.checkNotNull(name, "name");
        this.m_type = Preconditions.checkNotNull(type, "type");
        this.m_value = value;
        this.m_attributes = attributes;
    }

    @Override
    public Timestamp getTimestamp() {
        return this.m_timestamp;
    }

    public Context getContext() {
        return this.m_context;
    }

    @Override
    public Resource getResource() {
        return this.m_resource;
    }

    @Override
    public String getName() {
        return this.m_name;
    }

    public MetricType getType() {
        return this.m_type;
    }

    @Override
    public ValueType<?> getValue() {
        return this.m_value;
    }

    public Map<String, String> getAttributes() {
        return this.m_attributes;
    }

    public String toString() {
        return String.format("%s[timestamp=%s, context=%s, resource=%s, name=%s, type=%s, value=%s]", new Object[]{this.getClass().getSimpleName(), this.getTimestamp(), this.getContext(), this.getResource(), this.getName(), this.getType(), this.getValue()});
    }
}

