/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.newts.api;

import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import javax.inject.Named;
import org.opennms.newts.api.BlockingThreadPoolExecutor;
import org.opennms.newts.api.Sample;
import org.opennms.newts.api.SampleProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SampleProcessorService {
    private static final Logger LOG = LoggerFactory.getLogger(SampleProcessorService.class);
    private final ThreadPoolExecutor m_executor;
    private final Set<SampleProcessor> m_processors;

    public SampleProcessorService(int maxThreads) {
        this(maxThreads, Collections.emptySet());
    }

    @Inject
    public SampleProcessorService(@Named(value="sampleProcessor.maxThreads") int maxThreads, Set<SampleProcessor> processors) {
        Preconditions.checkArgument(maxThreads > 0, "maxThreads must be non-zero");
        LOG.info("Starting sample processor service with pool of {} threads", (Object)maxThreads);
        this.m_executor = new BlockingThreadPoolExecutor(1, maxThreads, 61L, TimeUnit.SECONDS);
        this.m_processors = Preconditions.checkNotNull(processors, "processors argument");
    }

    public void submit(final Collection<Sample> samples) {
        for (final SampleProcessor processor : this.m_processors) {
            this.m_executor.execute(new Runnable(){

                @Override
                public void run() {
                    processor.submit(samples);
                }
            });
        }
    }

    public void shutdown() throws InterruptedException {
        LOG.info("Shutting down thread pool executor");
        this.m_executor.shutdown();
    }

    public boolean awaitShutdown(long timeout, TimeUnit unit) throws InterruptedException {
        return this.m_executor.awaitTermination(timeout, unit);
    }
}

