/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.newts.api;

import com.google.common.primitives.UnsignedLong;
import java.nio.ByteBuffer;
import org.opennms.newts.api.Absolute;
import org.opennms.newts.api.Counter;
import org.opennms.newts.api.Derive;
import org.opennms.newts.api.Gauge;
import org.opennms.newts.api.MetricType;

public abstract class ValueType<T extends Number>
extends Number {
    private static final long serialVersionUID = 1L;

    public abstract ValueType<T> plus(Number var1);

    public abstract ValueType<T> minus(Number var1);

    public abstract ValueType<T> delta(Number var1);

    public abstract ValueType<T> times(Number var1);

    public abstract ValueType<T> divideBy(Number var1);

    public boolean isNan() {
        return Double.isNaN(this.doubleValue());
    }

    abstract T getValue();

    public abstract MetricType getType();

    @Override
    public abstract int intValue();

    @Override
    public abstract long longValue();

    @Override
    public abstract float floatValue();

    @Override
    public abstract double doubleValue();

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (!(o instanceof ValueType)) {
            return false;
        }
        return this.getValue().equals(((ValueType)o).getValue());
    }

    public String toString() {
        return this.getValue().toString();
    }

    public static ValueType<?> compose(Number number, MetricType type) {
        switch (type) {
            case ABSOLUTE: {
                return new Absolute(UnsignedLong.fromLongBits(number.longValue()));
            }
            case COUNTER: {
                return new Counter(UnsignedLong.fromLongBits(number.longValue()));
            }
            case DERIVE: {
                return new Derive(UnsignedLong.fromLongBits(number.longValue()));
            }
            case GAUGE: {
                return new Gauge(number.doubleValue());
            }
        }
        throw new IllegalArgumentException(String.format("Unknown metric type: %s", new Object[]{type}));
    }

    public static ValueType<?> compose(ByteBuffer data) {
        ByteBuffer buffer = data.duplicate();
        MetricType type = MetricType.fromCode(buffer.get());
        switch (type) {
            case ABSOLUTE: {
                return new Absolute(UnsignedLong.fromLongBits(buffer.getLong()));
            }
            case COUNTER: {
                return new Counter(UnsignedLong.fromLongBits(buffer.getLong()));
            }
            case DERIVE: {
                return new Derive(UnsignedLong.fromLongBits(buffer.getLong()));
            }
            case GAUGE: {
                return new Gauge(buffer.getDouble());
            }
        }
        throw new IllegalArgumentException(String.format("Unknown metric type: %s", new Object[]{type}));
    }

    public static ByteBuffer decompose(ValueType<?> value) {
        switch (value.getType()) {
            case ABSOLUTE: 
            case COUNTER: 
            case DERIVE: {
                ByteBuffer buffer = ByteBuffer.allocate(9);
                buffer.put(0, value.getType().getCode());
                buffer.putLong(1, value.longValue());
                buffer.rewind();
                return buffer;
            }
            case GAUGE: {
                ByteBuffer buffer = ByteBuffer.allocate(9);
                buffer.put(0, value.getType().getCode());
                buffer.putDouble(1, value.doubleValue());
                buffer.rewind();
                return buffer;
            }
        }
        throw new IllegalArgumentException(String.format("Unknown metric type: %s", new Object[]{value.getType()}));
    }
}

