/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.newts.api.query;

import com.google.common.base.Preconditions;
import java.util.Arrays;
import org.opennms.newts.api.query.CalculationFunction;

public class Calculation {
    private final String m_label;
    private final CalculationFunction m_calculationFunction;
    private final String[] m_args;

    public Calculation(String label, CalculationFunction calculationFunction, String ... args) {
        this.m_label = Preconditions.checkNotNull(label, "label argument");
        this.m_calculationFunction = Preconditions.checkNotNull(calculationFunction, "calculation function argument");
        Preconditions.checkArgument(args.length > 0, "one or more function arguments are required");
        this.m_args = args;
    }

    public String getLabel() {
        return this.m_label;
    }

    public CalculationFunction getCalculationFunction() {
        return this.m_calculationFunction;
    }

    public String[] getArgs() {
        return this.m_args;
    }

    public String toString() {
        return String.format("%s[%s, function=%s, args=%s]", this.getClass().getSimpleName(), this.getLabel(), this.getCalculationFunction(), Arrays.asList(this.getArgs()));
    }
}

