/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.newts.api.query;

import com.google.common.base.Preconditions;
import org.opennms.newts.api.Duration;
import org.opennms.newts.api.query.AggregationFunction;

public class Datasource {
    private final String m_label;
    private final String m_source;
    private final Duration m_heartbeat;
    private final double m_xff;
    private final AggregationFunction m_aggregationFunction;

    public Datasource(String label, String sourceName, Duration heartbeat, double xff, AggregationFunction aggregationFunction) {
        Preconditions.checkNotNull(label, "label argument");
        Preconditions.checkNotNull(sourceName, "source name argument");
        Preconditions.checkNotNull(heartbeat, "heartbeat argument");
        this.m_label = label;
        this.m_source = sourceName;
        this.m_heartbeat = heartbeat;
        this.m_xff = xff;
        this.m_aggregationFunction = aggregationFunction;
    }

    public String getLabel() {
        return this.m_label;
    }

    public String getSource() {
        return this.m_source;
    }

    public Duration getHeartbeat() {
        return this.m_heartbeat;
    }

    public double getXff() {
        return this.m_xff;
    }

    public AggregationFunction getAggregationFuction() {
        return this.m_aggregationFunction;
    }

    public String toString() {
        return String.format("%s[%s, source=%s, heatbeat=%s, xff=%s, function=%s]", this.getClass().getSimpleName(), this.getLabel(), this.getSource(), this.getHeartbeat(), this.getXff(), this.getAggregationFuction());
    }
}

