/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.newts.cassandra;

import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.RegularStatement;
import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.ResultSetFuture;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.ShutdownFuture;
import com.datastax.driver.core.Statement;
import com.datastax.driver.core.exceptions.DriverException;
import com.google.common.base.Preconditions;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.inject.Inject;
import javax.inject.Named;
import org.opennms.newts.cassandra.CassandraException;

public class CassandraSession {
    private final Session m_session;

    @Inject
    public CassandraSession(@Named(value="cassandra.keyspace") String keyspace, @Named(value="cassandra.hostname") String hostname, @Named(value="cassandra.port") int port) {
        Preconditions.checkNotNull(keyspace, "keyspace argument");
        Preconditions.checkNotNull(hostname, "hostname argument");
        Preconditions.checkArgument(port > 0 && port < 65535, "not a valid port number: %d", port);
        Cluster cluster = Cluster.builder().withPort(port).addContactPoint(hostname).build();
        this.m_session = cluster.connect(keyspace);
    }

    public PreparedStatement prepare(RegularStatement statement) {
        try {
            return this.m_session.prepare(statement);
        }
        catch (DriverException excep) {
            throw new CassandraException(excep);
        }
    }

    public ResultSetFuture executeAsync(Statement statement) {
        try {
            return this.m_session.executeAsync(statement);
        }
        catch (DriverException excep) {
            throw new CassandraException(excep);
        }
    }

    public ResultSet execute(Statement statement) {
        try {
            return this.m_session.execute(statement);
        }
        catch (DriverException excep) {
            throw new CassandraException(excep);
        }
    }

    public ResultSet execute(String statement) {
        try {
            return this.m_session.execute(statement);
        }
        catch (DriverException excep) {
            throw new CassandraException(excep);
        }
    }

    public Future<Void> shutdown() {
        final ShutdownFuture future = this.m_session.shutdown();
        return new Future<Void>(){

            @Override
            public boolean cancel(boolean mayInterruptIfRunning) {
                return future.cancel(mayInterruptIfRunning);
            }

            @Override
            public boolean isCancelled() {
                return future.isCancelled();
            }

            @Override
            public boolean isDone() {
                return future.isDone();
            }

            @Override
            public Void get() throws InterruptedException, ExecutionException {
                return (Void)future.get();
            }

            @Override
            public Void get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
                return (Void)future.get(timeout, unit);
            }
        };
    }
}

