/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.newts.gsod;

import com.codahale.metrics.MetricRegistry;
import com.google.inject.AbstractModule;
import com.google.inject.Provides;
import com.google.inject.name.Names;
import java.util.Collections;
import java.util.Properties;
import org.opennms.newts.api.SampleProcessorService;
import org.opennms.newts.api.SampleRepository;
import org.opennms.newts.persistence.cassandra.CassandraSampleRepository;

public class Config
extends AbstractModule {
    @Override
    protected void configure() {
        this.bind(SampleRepository.class).to(CassandraSampleRepository.class);
        Properties properties = new Properties();
        properties.put("cassandra.keyspace", System.getProperty("cassandra.keyspace", "newts"));
        properties.put("cassandra.hostname", System.getProperty("cassandra.host", "localhost"));
        properties.put("cassandra.port", System.getProperty("cassandra.port", "9042"));
        properties.put("samples.cassandra.time-to-live", System.getProperty("cassandra.time-to-live", "0"));
        Names.bindProperties(this.binder(), properties);
        this.bind(MetricRegistry.class).toInstance(new MetricRegistry());
    }

    @Provides
    SampleProcessorService getSampleProcessorService() {
        return new SampleProcessorService(1, Collections.emptySet());
    }
}

