/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.newts.gsod;

import com.google.common.base.Optional;
import com.google.inject.Guice;
import com.google.inject.Injector;
import java.io.PrintStream;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import org.kohsuke.args4j.CmdLineException;
import org.kohsuke.args4j.CmdLineParser;
import org.kohsuke.args4j.Option;
import org.opennms.newts.api.Resource;
import org.opennms.newts.api.Results;
import org.opennms.newts.api.Sample;
import org.opennms.newts.api.SampleRepository;
import org.opennms.newts.api.Timestamp;
import org.opennms.newts.api.ValueType;
import org.opennms.newts.gsod.Config;
import org.opennms.newts.gsod.ResourceOptionHandler;

public class ExportRunner {
    private final SampleRepository m_repository;
    private final CmdLineParser m_parser = new CmdLineParser(this);
    @Option(name="-r", usage="resource name to query (required)")
    private Resource m_resource;
    @Option(name="-m", usage="metric to query (required)")
    private String m_metric;
    @Option(name="-s", usage="query start time in milliseconds")
    private Long m_start;
    @Option(name="-e", usage="query end time milliseconds")
    private Long m_end;
    @Option(name="-h", usage="print this usage information")
    private boolean m_needsHelp;

    @Inject
    public ExportRunner(SampleRepository repository) {
        this.m_repository = repository;
    }

    private void printUsage(PrintStream writer) {
        writer.println("Usage: java ExportRunner [options...] ");
        this.m_parser.printUsage(writer);
    }

    private int go(String[] args) {
        this.m_parser.setUsageWidth(80);
        try {
            this.m_parser.parseArgument(args);
        }
        catch (CmdLineException e) {
            System.err.println(e.getMessage());
            this.printUsage(System.err);
            return 1;
        }
        if (this.m_needsHelp) {
            this.printUsage(System.out);
            return 0;
        }
        if (this.m_resource == null || this.m_metric == null) {
            System.err.println("Missing required argument(s)");
            this.printUsage(System.err);
            return 1;
        }
        System.out.printf("timestamp,%s%n", this.m_metric);
        for (Results.Row<Sample> row : this.m_repository.select(this.m_resource, ExportRunner.timestamp(this.m_start), ExportRunner.timestamp(this.m_end))) {
            System.out.printf("%s,%.2f%n", row.getTimestamp().asDate(), ((ValueType)row.getElement(this.m_metric).getValue()).doubleValue());
        }
        return 0;
    }

    private static Optional<Timestamp> timestamp(Long arg) {
        if (arg == null) {
            return Optional.absent();
        }
        return Optional.of(new Timestamp(arg, TimeUnit.MILLISECONDS));
    }

    public static void main(String ... args) {
        Injector injector = Guice.createInjector(new Config());
        ExportRunner runner = injector.getInstance(ExportRunner.class);
        System.exit(runner.go(args));
    }

    static {
        CmdLineParser.registerHandler(Resource.class, ResourceOptionHandler.class);
    }
}

