/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.newts.gsod;

import com.codahale.metrics.Counter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.file.Path;
import java.text.ParseException;
import java.util.List;
import java.util.zip.GZIPInputStream;
import org.opennms.newts.api.Sample;
import org.opennms.newts.api.SampleRepository;
import org.opennms.newts.gsod.LineParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileImport
implements Runnable {
    private static final Logger LOG = LoggerFactory.getLogger(FileImport.class);
    private final SampleRepository m_repository;
    private final BufferedReader m_reader;
    private final Counter m_numRows;
    private final Counter m_numSamples;
    private final Timer m_writeTimer;
    private LineParser m_lineParser;

    public FileImport(SampleRepository repository, MetricRegistry metrics, Path path) throws FileNotFoundException, IOException {
        this.m_repository = repository;
        this.m_numRows = metrics.counter("num-rows");
        this.m_numSamples = metrics.counter("num-samples");
        this.m_writeTimer = metrics.timer("writes");
        GZIPInputStream gzipStream = new GZIPInputStream(new FileInputStream(path.toString()));
        this.m_reader = new BufferedReader(new InputStreamReader((InputStream)gzipStream, "US-ASCII"));
        this.m_lineParser = new LineParser();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            String line;
            this.m_reader.readLine();
            while ((line = this.m_reader.readLine()) != null) {
                try {
                    List<Sample> samples = this.m_lineParser.parseLine(line);
                    Timer.Context timerCtx = this.m_writeTimer.time();
                    try {
                        this.m_repository.insert(samples);
                    }
                    finally {
                        timerCtx.stop();
                    }
                    this.m_numRows.inc();
                    this.m_numSamples.inc(10L);
                }
                catch (ParseException e) {
                    LOG.error("Unable to parse date from line '{}'", (Object)line);
                }
            }
        }
        catch (IOException e) {
            LOG.error("Error reading GSOD data file: {]", e);
        }
    }
}

