/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.newts.gsod;

import com.google.common.base.Function;
import com.google.common.base.Throwables;
import com.google.common.collect.AbstractIterator;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.Iterables;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.Stack;
import java.util.zip.GZIPInputStream;

public class FileIterable {
    public static FluentIterable<Path> fileTreeWalker(Path root) {
        return FluentIterable.from(Iterables.concat(FileIterable.groupFilesByDir(root)));
    }

    private static KeyedIterable<Path, Path> children(File dir, FileFilter filter) {
        return new KeyedIterable<Path, Path>(dir.toPath(), FileIterable.toPaths(dir.listFiles(filter)));
    }

    private static KeyedIterable<Path, Path> files(File dir) {
        return FileIterable.children(dir, FileIterable.fileMatcher());
    }

    private static KeyedIterable<Path, Path> subdirs(File dir) {
        return FileIterable.children(dir, FileIterable.directoryMatcher());
    }

    private static FileFilter fileMatcher() {
        return new FileFilter(){

            @Override
            public boolean accept(File f) {
                return f.isFile();
            }
        };
    }

    private static FileFilter directoryMatcher() {
        return new FileFilter(){

            @Override
            public boolean accept(File f) {
                return f.isDirectory();
            }
        };
    }

    public static Iterable<Path> toPaths(File[] files) {
        return files == null ? Collections.emptyList() : FileIterable.toPaths(Arrays.asList(files));
    }

    public static Iterable<Path> toPaths(Iterable<File> files) {
        return Iterables.transform(files, new Function<File, Path>(){

            @Override
            public Path apply(File input) {
                return input.toPath();
            }
        });
    }

    public static Iterable<File> toFiles(Iterable<Path> files) {
        return Iterables.transform(files, new Function<Path, File>(){

            @Override
            public File apply(Path input) {
                return input.toFile();
            }
        });
    }

    public static FluentIterable<KeyedIterable<Path, Path>> groupFilesByDir(final Path root) {
        return new FluentIterable<KeyedIterable<Path, Path>>(){

            @Override
            public Iterator<KeyedIterable<Path, Path>> iterator() {
                return new GroupedPathIterator(root.toFile());
            }
        };
    }

    public static FluentIterable<String> lines(final Path path) {
        return new FluentIterable<String>(){

            @Override
            public Iterator<String> iterator() {
                try {
                    return new LineIterator(new FileReader(path.toFile()));
                }
                catch (FileNotFoundException e) {
                    throw Throwables.propagate(e);
                }
            }
        };
    }

    public static FluentIterable<String> unzipLines(final Path path, final Charset cs) {
        return new FluentIterable<String>(){

            @Override
            public Iterator<String> iterator() {
                try {
                    return new LineIterator(FileIterable.zippedFileReader(path, cs));
                }
                catch (IOException e) {
                    throw Throwables.propagate(e);
                }
            }
        };
    }

    private static Reader zippedFileReader(Path path, Charset cs) throws IOException {
        GZIPInputStream gzipStream = new GZIPInputStream(new FileInputStream(path.toFile()));
        return new InputStreamReader((InputStream)gzipStream, cs);
    }

    public static <F, T> Function<? super Iterable<F>, Iterable<T>> bind(final Function<? super F, Iterable<T>> f) {
        return new Function<Iterable<F>, Iterable<T>>(){

            @Override
            public Iterable<T> apply(Iterable<F> input) {
                return Iterables.concat(Iterables.transform(input, f));
            }
        };
    }

    public static <F, T> Function<? super Iterable<F>, Iterable<T>> lift(final Function<F, T> f) {
        return new Function<Iterable<F>, Iterable<T>>(){

            @Override
            public Iterable<T> apply(Iterable<F> input) {
                return Iterables.transform(input, f);
            }
        };
    }

    private static class LineIterator
    implements Iterator<String> {
        private BufferedReader m_in;
        private String m_nextLine;

        public LineIterator(Reader r) {
            this.m_in = new BufferedReader(r);
            this.fetchLine();
        }

        private void fetchLine() {
            if (this.m_in == null) {
                return;
            }
            try {
                this.m_nextLine = this.m_in.readLine();
            }
            catch (IOException e) {
                throw Throwables.propagate(e);
            }
            finally {
                if (this.m_nextLine == null) {
                    this.close();
                }
            }
        }

        private void close() {
            try {
                if (this.m_in != null) {
                    this.m_in.close();
                }
            }
            catch (IOException e) {
                throw Throwables.propagate(e);
            }
            finally {
                this.m_in = null;
            }
        }

        @Override
        public boolean hasNext() {
            return this.m_nextLine != null;
        }

        @Override
        public String next() {
            String line = this.m_nextLine;
            this.fetchLine();
            return line;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Iterator<String>.remove is not yet implemented.");
        }
    }

    public static class GroupedPathIterator
    extends AbstractIterator<KeyedIterable<Path, Path>> {
        Stack<Iterator<Path>> m_dirStack;
        File m_root;

        GroupedPathIterator(File root) {
            this.m_root = root;
        }

        @Override
        protected KeyedIterable<Path, Path> computeNext() {
            if (this.m_dirStack == null) {
                this.m_dirStack = new Stack();
                this.m_dirStack.push(FileIterable.subdirs(this.m_root).iterator());
                return FileIterable.files(this.m_root);
            }
            while (!this.m_dirStack.isEmpty()) {
                Iterator<Path> subdirs = this.m_dirStack.peek();
                if (!subdirs.hasNext()) {
                    this.m_dirStack.pop();
                    continue;
                }
                File dir = subdirs.next().toFile();
                this.m_dirStack.push(FileIterable.subdirs(dir).iterator());
                return FileIterable.files(dir);
            }
            this.endOfData();
            return null;
        }
    }

    public static class KeyedIterable<K, T>
    extends FluentIterable<T> {
        private K m_key;
        private Iterable<T> m_items;

        public KeyedIterable(K key, Iterable<T> items) {
            this.m_key = key;
            this.m_items = items;
        }

        @Override
        public Iterator<T> iterator() {
            return this.m_items.iterator();
        }

        public K getKey() {
            return this.m_key;
        }
    }
}

