/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.newts.gsod;

import com.codahale.metrics.Counter;
import com.codahale.metrics.Gauge;
import com.codahale.metrics.MetricRegistry;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.concurrent.ThreadPoolExecutor;
import javax.inject.Inject;
import org.opennms.newts.api.SampleRepository;
import org.opennms.newts.gsod.FileImport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class FileVisitor
extends SimpleFileVisitor<Path> {
    private static final Logger LOG = LoggerFactory.getLogger(FileVisitor.class);
    private final SampleRepository m_repository;
    private final ThreadPoolExecutor m_executor;
    private final MetricRegistry m_metrics;
    private final Counter m_numFiles;

    @Inject
    FileVisitor(SampleRepository repository, ThreadPoolExecutor executor, MetricRegistry metrics) {
        this.m_repository = repository;
        this.m_executor = executor;
        this.m_metrics = metrics;
        this.m_numFiles = this.m_metrics.counter("num-files");
        this.m_metrics.register("num-threads", new Gauge<Integer>(){

            @Override
            public Integer getValue() {
                return FileVisitor.this.m_executor.getActiveCount();
            }
        });
    }

    void execute(Path path) throws FileNotFoundException, IOException {
        this.m_executor.execute(new FileImport(this.m_repository, this.m_metrics, path));
    }

    @Override
    public FileVisitResult visitFile(Path path, BasicFileAttributes attrs) {
        LOG.debug("Found {}", (Object)path);
        if (attrs.isRegularFile()) {
            try {
                this.m_numFiles.inc();
                this.execute(path);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return FileVisitResult.CONTINUE;
    }
}

