/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.newts.gsod;

import com.codahale.metrics.ConsoleReporter;
import com.codahale.metrics.Gauge;
import com.codahale.metrics.Meter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.inject.Guice;
import com.google.inject.Injector;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.nio.file.Path;
import java.text.ParseException;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.http.entity.ContentType;
import org.apache.http.impl.nio.client.CloseableHttpAsyncClient;
import org.apache.http.impl.nio.client.HttpAsyncClients;
import org.apache.http.nio.client.methods.HttpAsyncMethods;
import org.kohsuke.args4j.Argument;
import org.kohsuke.args4j.CmdLineException;
import org.kohsuke.args4j.CmdLineParser;
import org.kohsuke.args4j.Option;
import org.opennms.newts.api.MetricType;
import org.opennms.newts.api.Sample;
import org.opennms.newts.api.SampleRepository;
import org.opennms.newts.api.Timestamp;
import org.opennms.newts.api.ValueType;
import org.opennms.newts.gsod.Config;
import org.opennms.newts.gsod.FileObservable;
import org.opennms.newts.gsod.JSONBuilder;
import org.opennms.newts.gsod.LineParser;
import org.opennms.newts.reporter.metrics.NewtsReporter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rx.Observable;
import rx.Observer;
import rx.Subscriber;
import rx.Subscription;
import rx.apache.http.ObservableHttp;
import rx.apache.http.ObservableHttpResponse;
import rx.exceptions.Exceptions;
import rx.functions.Action0;
import rx.functions.Func1;
import rx.functions.Functions;
import rx.schedulers.Schedulers;

public class ImportRunner {
    private int m_samplesPerBatch = 1000;
    private File m_source;
    private String m_restUrl = null;
    private SampleRepository m_repository;
    private int m_threadCount = 1;
    private int m_maxThreadQueueSize = 0;
    private double m_timescaleFactor = 1.0;
    private long m_timeoffset = 0L;
    private static final Logger LOG = LoggerFactory.getLogger(ImportRunner.class);

    private void checkArgument(boolean check, String failureMessage) {
        if (!check) {
            throw new IllegalArgumentException(failureMessage);
        }
    }

    @Option(name="-n", aliases={"--samples-per-batch"}, metaVar="sample-count", usage="the maxinum number of samples to include in each post to the repository (default: 1000)")
    public void setSamplesPerBatch(int samplesPerBatch) {
        this.checkArgument(samplesPerBatch > 0, "samples per batch must be greater than zero!");
        this.m_samplesPerBatch = samplesPerBatch;
    }

    @Option(name="-u", aliases={"--url"}, metaVar="url", usage="publish data via a Newts REST server at the given url (default: use direct access via Newts API)")
    public void setURL(String url) {
        this.checkArgument(url != null && !url.isEmpty(), "the url must not be empty");
        this.m_restUrl = url;
    }

    @Option(name="-p", aliases={"--parallelism"}, metaVar="thread-count", usage="when using direct the size of the thread pool that posts the results.  (defaults to 1 ie no parallelism)")
    public void setParallelism(int threadCount) {
        this.checkArgument(threadCount > 0, "thread count must be at least 1.");
        this.m_threadCount = threadCount;
    }

    @Option(name="-q", aliases={"--max-work-queue-size"}, metaVar="batch-count", usage="when using direct the max size of the work-queue (defaults to thread-count * 3)")
    public void setMaxThreadQueueSize(int maxThreadQueueSize) {
        this.checkArgument(maxThreadQueueSize > 0, "max thread queue size must be at least 1.");
        this.m_maxThreadQueueSize = maxThreadQueueSize;
    }

    @Option(name="-f", aliases={"--time-scale-factor"}, metaVar="long", usage="to scale down the date we compress time dividing time by this factor")
    public void setTimescaleFactor(double factor) {
        this.m_timescaleFactor = factor;
    }

    @Option(name="-o", aliases={"--time-offset"}, metaVar="timestamp", usage="adjust epoch time in seconds to be <time-offset>. defaults to no offset.  'now' is allowed.")
    public void setTimeoffset(String offset) {
        this.m_timeoffset = offset.equals("now") ? System.currentTimeMillis() : Long.valueOf(offset) * 1000L;
    }

    @Argument(metaVar="sourceDir", required=true, usage="the source directory that contains gsod data to import. These must be gzip'd files")
    public void setSource(File source) {
        this.checkArgument(source.exists(), "the source directory " + source + " does not exist");
        this.checkArgument(source.isDirectory(), "the source directory must be a directory");
        this.m_source = source;
    }

    public static void main(String ... args) throws Exception {
        new ImportRunner().execute(args);
    }

    public void execute(String ... args) throws Exception {
        CmdLineParser parser = new CmdLineParser(this);
        try {
            parser.parseArgument(args);
        }
        catch (CmdLineException e) {
            System.err.println(e.getMessage());
            parser.printUsage(System.err);
            return;
        }
        MetricRegistry metrics = new MetricRegistry();
        final long start = System.currentTimeMillis();
        metrics.register("elapsed-seconds", new Gauge<Double>(){

            @Override
            public Double getValue() {
                return (double)(System.currentTimeMillis() - start) / 1000.0;
            }
        });
        final ConsoleReporter reporter = ConsoleReporter.forRegistry(metrics).outputTo(System.err).convertRatesTo(TimeUnit.SECONDS).convertDurationsTo(TimeUnit.MILLISECONDS).build();
        reporter.start(10L, TimeUnit.SECONDS);
        if (this.m_restUrl == null) {
            NewtsReporter newtsReporter = NewtsReporter.forRegistry(metrics).name("importer").convertRatesTo(TimeUnit.SECONDS).convertDurationsTo(TimeUnit.MILLISECONDS).build(this.repository());
            newtsReporter.start(1L, TimeUnit.SECONDS);
        }
        LOG.debug("Scanning {} for GSOD data files...", (Object)this.m_source);
        Observable<Sample> samples = FileObservable.fileTreeWalker(this.m_source.toPath()).subscribeOn(Schedulers.io()).map(ImportRunner.meter(metrics.meter("files"), Path.class)).map(ImportRunner.reportFile()).mergeMap(FileObservable.lines()).filter(ImportRunner.exclude("YEARMODA")).mergeMap(ImportRunner.samples()).map(this.adjustTime()).map(ImportRunner.meter(metrics.meter("samples"), Sample.class));
        Observable<List<Sample>> batches = samples.buffer(this.m_samplesPerBatch);
        Observable<Boolean> doImport = this.m_restUrl != null ? this.restPoster(batches, metrics) : this.directPoster(batches, metrics);
        System.err.println("doImport = " + doImport);
        final AtomicReference<Subscription> subscription = new AtomicReference<Subscription>();
        final AtomicBoolean failed = new AtomicBoolean(false);
        final CountDownLatch latch = new CountDownLatch(1);
        Subscription s = doImport.subscribe(new Observer<Boolean>(){

            @Override
            public void onCompleted() {
                System.err.println("Finished Importing Everything!");
                reporter.report();
                latch.countDown();
                System.exit(0);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onError(Throwable e) {
                failed.set(true);
                System.err.println("Error importing!");
                e.printStackTrace();
                try {
                    Subscription s = (Subscription)subscription.get();
                    if (s != null) {
                        s.unsubscribe();
                    }
                }
                catch (Exception ex) {
                    System.err.println("Failed to close httpClient!");
                    ex.printStackTrace();
                }
            }

            @Override
            public void onNext(Boolean t) {
                System.err.println("Received a boolen: " + t);
            }
        });
        subscription.set(s);
        if (failed.get()) {
            s.unsubscribe();
        }
        System.err.println("Return from Subscribe!");
        latch.await();
    }

    private Func1<? super Sample, ? extends Sample> adjustTime() {
        return new Func1<Sample, Sample>(){

            @Override
            public Sample call(Sample s) {
                Timestamp oldTs = s.getTimestamp();
                Timestamp newTs = Timestamp.fromEpochMillis(ImportRunner.this.m_timeoffset + Math.round((double)oldTs.asMillis() / ImportRunner.this.m_timescaleFactor));
                return new Sample(newTs, s.getResource(), s.getName(), s.getType(), (ValueType<?>)s.getValue());
            }
        };
    }

    private SampleRepository repository() {
        if (this.m_repository == null) {
            Injector injector = Guice.createInjector(new Config());
            this.m_repository = injector.getInstance(SampleRepository.class);
        }
        return this.m_repository;
    }

    private Observable<Boolean> directPoster(Observable<List<Sample>> samples, MetricRegistry metrics) {
        final SampleRepository repository = this.repository();
        final Timer timer = metrics.timer("writes");
        final Meter completions = metrics.meter("samples-completed");
        Func1<List<Sample>, Boolean> insert = new Func1<List<Sample>, Boolean>(){

            /*
             * Loose catch block
             */
            @Override
            public Boolean call(List<Sample> s) {
                int sz = s.size();
                try {
                    try (Timer.Context timerCtx = timer.time();){
                        repository.insert(s);
                        Boolean bl = true;
                        return bl;
                    }
                    {
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                    }
                }
                finally {
                    completions.mark(sz);
                }
            }
        };
        return (this.m_threadCount == 1 ? samples.map(insert) : this.parMap(samples, metrics, insert)).all(Functions.identity());
    }

    private Observable<Boolean> parMap(Observable<List<Sample>> samples, MetricRegistry metrics, Func1<List<Sample>, Boolean> insert) {
        final Timer waitTime = metrics.timer("wait-time");
        final LinkedBlockingQueue<Runnable> workQueue = new LinkedBlockingQueue<Runnable>(this.m_maxThreadQueueSize == 0 ? this.m_threadCount * 3 : this.m_maxThreadQueueSize){

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public boolean offer(Runnable r) {
                try (Timer.Context time = waitTime.time();){
                    this.put(r);
                    boolean bl = true;
                    return bl;
                }
                catch (InterruptedException e) {
                    throw Exceptions.propagate(e);
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public boolean add(Runnable r) {
                try (Timer.Context time = waitTime.time();){
                    this.put(r);
                    boolean bl = true;
                    return bl;
                }
                catch (InterruptedException e) {
                    throw Exceptions.propagate(e);
                }
            }
        };
        final ThreadPoolExecutor executor = new ThreadPoolExecutor(this.m_threadCount, this.m_threadCount, 0L, TimeUnit.MILLISECONDS, (BlockingQueue<Runnable>)workQueue);
        metrics.register("active-threads", new Gauge<Integer>(){

            @Override
            public Integer getValue() {
                return executor.getActiveCount();
            }
        });
        metrics.register("pool-size", new Gauge<Integer>(){

            @Override
            public Integer getValue() {
                return executor.getPoolSize();
            }
        });
        metrics.register("largest-pool-size", new Gauge<Integer>(){

            @Override
            public Integer getValue() {
                return executor.getLargestPoolSize();
            }
        });
        metrics.register("work-queue-size", new Gauge<Integer>(){

            @Override
            public Integer getValue() {
                return workQueue.size();
            }
        });
        return this.parMap(samples, executor, metrics, insert);
    }

    private Observable<Boolean> parMap(Observable<List<Sample>> samples, ExecutorService executorSvc, MetricRegistry metrics, final Func1<List<Sample>, Boolean> insert) {
        final ListeningExecutorService executor = MoreExecutors.listeningDecorator(executorSvc);
        Observable<Boolean> o = samples.lift(new Observable.Operator<ListenableFuture<Boolean>, List<Sample>>(){

            @Override
            public Subscriber<? super List<Sample>> call(final Subscriber<? super ListenableFuture<Boolean>> s) {
                return new Subscriber<List<Sample>>(){

                    @Override
                    public void onCompleted() {
                        if (!s.isUnsubscribed()) {
                            s.onCompleted();
                        }
                        executor.shutdown();
                    }

                    @Override
                    public void onError(Throwable e) {
                        if (!s.isUnsubscribed()) {
                            s.onError(e);
                        }
                    }

                    @Override
                    public void onNext(final List<Sample> t) {
                        if (!s.isUnsubscribed()) {
                            try {
                                ListenableFuture<Boolean> f = executor.submit(new Callable<Boolean>(){

                                    @Override
                                    public Boolean call() throws Exception {
                                        return (Boolean)insert.call(t);
                                    }
                                });
                                s.onNext(f);
                            }
                            catch (Throwable ex) {
                                this.onError(ex);
                            }
                        }
                    }
                };
            }
        }).observeOn(Schedulers.io()).map(new Func1<ListenableFuture<Boolean>, Boolean>(){

            @Override
            public Boolean call(ListenableFuture<Boolean> f) {
                try {
                    return (Boolean)f.get();
                }
                catch (Throwable e) {
                    throw Exceptions.propagate(e);
                }
            }
        });
        return o;
    }

    private Observable<Boolean> restPoster(Observable<List<Sample>> samples, MetricRegistry metrics) {
        final CloseableHttpAsyncClient httpClient = HttpAsyncClients.createDefault();
        httpClient.start();
        return samples.map(ImportRunner.toJSON()).map(ImportRunner.meter(metrics.meter("posts"), String.class)).mergeMap(ImportRunner.postJSON(this.m_restUrl, httpClient)).map(ImportRunner.meter(metrics.meter("responses"), ObservableHttpResponse.class)).map(ImportRunner.meter(metrics.meter("samples-completed"), this.m_samplesPerBatch, ObservableHttpResponse.class)).all(ImportRunner.successful()).doOnCompleted(new Action0(){

            @Override
            public void call() {
                try {
                    httpClient.close();
                }
                catch (IOException e) {
                    System.err.println("Failed to close httpClient!");
                    e.printStackTrace();
                }
            }
        });
    }

    private static Func1<? super Path, ? extends Path> reportFile() {
        return new Func1<Path, Path>(){

            @Override
            public Path call(Path file) {
                System.err.println("Begin Processing: " + file);
                return file;
            }
        };
    }

    public static Func1<String, Observable<Sample>> samples() {
        final LineParser parser = new LineParser();
        return new Func1<String, Observable<Sample>>(){

            @Override
            public Observable<Sample> call(String line) {
                try {
                    return Observable.from(parser.parseLine(line));
                }
                catch (ParseException e) {
                    throw Exceptions.propagate(e);
                }
            }
        };
    }

    private static boolean isNaN(Sample sample) {
        return sample.getType() == MetricType.GAUGE && Double.isNaN(((ValueType)sample.getValue()).doubleValue());
    }

    public static Func1<List<Sample>, String> toJSON() {
        return new Func1<List<Sample>, String>(){

            @Override
            public String call(List<Sample> samples) {
                JSONBuilder bldr = new JSONBuilder();
                for (Sample sample : samples) {
                    if (ImportRunner.isNaN(sample)) continue;
                    bldr.newObject();
                    bldr.attr("timestamp", sample.getTimestamp().asMillis());
                    bldr.attr("resource", sample.getResource().getId());
                    bldr.attr("name", sample.getName());
                    bldr.attr("type", sample.getType().name());
                    if (sample.getType() == MetricType.GAUGE) {
                        bldr.attr("value", ((ValueType)sample.getValue()).doubleValue());
                        continue;
                    }
                    bldr.attr("value", ((ValueType)sample.getValue()).longValue());
                }
                return bldr.toString();
            }
        };
    }

    private static Func1<ObservableHttpResponse, Boolean> successful() {
        return new Func1<ObservableHttpResponse, Boolean>(){

            @Override
            public Boolean call(ObservableHttpResponse response) {
                if (response.getResponse().getStatusLine().getStatusCode() >= 400) {
                    throw new RuntimeException("Failed to post samples: " + response.getResponse().getStatusLine());
                }
                return true;
            }
        };
    }

    public static Func1<String, Observable<ObservableHttpResponse>> postJSON(String baseURL, final CloseableHttpAsyncClient httpClient) {
        final URI baseURI = URI.create(baseURL);
        return new Func1<String, Observable<ObservableHttpResponse>>(){

            @Override
            public Observable<ObservableHttpResponse> call(String json) {
                try {
                    return ObservableHttp.createRequest(HttpAsyncMethods.createPost(baseURI, json, ContentType.APPLICATION_JSON), httpClient).toObservable();
                }
                catch (UnsupportedEncodingException e) {
                    throw Exceptions.propagate(e);
                }
            }
        };
    }

    public static Func1<String, Boolean> exclude(final String pattern) {
        return new Func1<String, Boolean>(){

            @Override
            public Boolean call(String s) {
                return !s.contains(pattern);
            }
        };
    }

    public static <T> Func1<T, T> meter(Meter meter, Class<T> clazz) {
        return ImportRunner.meter(meter, 1, clazz);
    }

    public static <T> Func1<T, T> meter(final Meter meter, final int count, Class<T> clazz) {
        return new Func1<T, T>(){

            @Override
            public T call(T t) {
                meter.mark(count);
                return t;
            }
        };
    }
}

