/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.newts.gsod;

import com.google.common.collect.Lists;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.TimeUnit;
import org.opennms.newts.api.Gauge;
import org.opennms.newts.api.MetricType;
import org.opennms.newts.api.Resource;
import org.opennms.newts.api.Sample;
import org.opennms.newts.api.Timestamp;
import org.opennms.newts.gsod.FileImport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LineParser {
    private static final Logger LOG = LoggerFactory.getLogger(FileImport.class);
    private static final ThreadLocal<DateFormat> m_dateFormat = new ThreadLocal<DateFormat>(){

        @Override
        protected DateFormat initialValue() {
            return new SimpleDateFormat("yyyyMMdd", Locale.ENGLISH);
        }
    };

    public static DateFormat getDateFormat() {
        return m_dateFormat.get();
    }

    List<Sample> parseLine(String line) throws ParseException {
        LOG.trace("Parsing {}", (Object)line);
        ArrayList<Sample> samples = Lists.newArrayList();
        Resource station = new Resource(this.stringAt(line, 0));
        String wban = this.stringAt(line, 7);
        String dateYMD = this.stringAt(line, 14);
        Date date = LineParser.getDateFormat().parse(dateYMD);
        Timestamp ts = new Timestamp(date.getTime(), TimeUnit.MILLISECONDS);
        double meanTemp = this.doubleAt(line, 24);
        samples.add(new Sample(ts, station, "meanTemperature", MetricType.GAUGE, LineParser.valueFor(meanTemp, 9999.9)));
        double dewpoint = this.doubleAt(line, 35);
        samples.add(new Sample(ts, station, "dewPoint", MetricType.GAUGE, LineParser.valueFor(dewpoint, 9999.9)));
        double slp = this.doubleAt(line, 46);
        Gauge seaLevelPressure = LineParser.valueFor(slp, 9999.9);
        samples.add(new Sample(ts, station, "seaLevelPressure", MetricType.GAUGE, seaLevelPressure));
        double stp = this.doubleAt(line, 57);
        Gauge stationPressure = LineParser.valueFor(stp, 9999.9);
        samples.add(new Sample(ts, station, "stationPressure", MetricType.GAUGE, stationPressure));
        double vis = this.doubleAt(line, 68);
        Gauge visibility = LineParser.valueFor(vis, 999.9);
        samples.add(new Sample(ts, station, "visibility", MetricType.GAUGE, visibility));
        double speed = this.doubleAt(line, 78);
        Gauge meanWindSpeed = new Gauge(speed);
        samples.add(new Sample(ts, station, "meanWindSpeed", MetricType.GAUGE, meanWindSpeed));
        double maxSpeed = this.doubleAt(line, 88);
        Gauge maxWindSpeed = LineParser.valueFor(maxSpeed, 999.9);
        samples.add(new Sample(ts, station, "maxWindSpeed", MetricType.GAUGE, maxWindSpeed));
        double maxGust = this.doubleAt(line, 95);
        Gauge maxWindGust = LineParser.valueFor(maxGust, 999.9);
        samples.add(new Sample(ts, station, "maxWindGust", MetricType.GAUGE, maxWindGust));
        double maxTemp = this.doubleAt(line, 102);
        Gauge maxTemperature = LineParser.valueFor(maxTemp, 9999.9);
        samples.add(new Sample(ts, station, "maxTemperature", MetricType.GAUGE, maxTemperature));
        double minTemp = this.doubleAt(line, 110);
        Gauge minTemperature = LineParser.valueFor(minTemp, 9999.9);
        samples.add(new Sample(ts, station, "minTemperature", MetricType.GAUGE, minTemperature));
        LOG.trace("Station number {}, WBAN {}, date {}, Max Temp {}...", station, wban, dateYMD, maxTemperature);
        return samples;
    }

    public boolean isDigit(char ch) {
        return '0' <= ch && ch <= '9';
    }

    public String stringAt(String line, int index) {
        char ch;
        StringBuilder buf = new StringBuilder();
        while (index < line.length() && (ch = line.charAt(index)) != ' ') {
            buf.append(ch);
            ++index;
        }
        return buf.toString();
    }

    public long longAt(String line, int index) {
        char ch;
        index = this.skipLeadingSpaces(line, index);
        boolean negative = false;
        if (line.charAt(index) == '-') {
            negative = true;
            ++index;
        }
        long n = 0L;
        while (index < line.length() && this.isDigit(ch = line.charAt(index))) {
            n = n * 10L + (long)(ch - 48);
            ++index;
        }
        return negative ? -n : n;
    }

    public int skipLeadingSpaces(String line, int index) {
        while (index < line.length() && line.charAt(index) == ' ') {
            ++index;
        }
        return index;
    }

    public int intAt(String line, int index) {
        char ch;
        index = this.skipLeadingSpaces(line, index);
        boolean negative = false;
        if (line.charAt(index) == '-') {
            negative = true;
            ++index;
        }
        int n = 0;
        while (index < line.length() && this.isDigit(ch = line.charAt(index))) {
            n = n * 10 + (ch - 48);
            ++index;
        }
        return negative ? -n : n;
    }

    public double doubleAt(String line, int index) {
        char ch;
        index = this.skipLeadingSpaces(line, index);
        boolean negative = false;
        if (line.charAt(index) == '-') {
            negative = true;
            ++index;
        }
        double d = 0.0;
        while (index < line.length() && this.isDigit(ch = line.charAt(index))) {
            d = d * 10.0 + (double)(ch - 48);
            ++index;
        }
        ch = line.charAt(index);
        if (ch != '.') {
            return negative ? -d : d;
        }
        ++index;
        double scale = 0.1;
        while (index < line.length() && this.isDigit(ch = line.charAt(index))) {
            d += scale * (double)(ch - 48);
            scale /= 10.0;
            ++index;
        }
        return negative ? -d : d;
    }

    public static Gauge valueFor(double value, double nan) {
        return new Gauge(value == nan ? Double.NaN : value);
    }
}

