/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.newts.gsod;

import com.codahale.metrics.ConsoleReporter;
import com.codahale.metrics.Meter;
import com.codahale.metrics.MetricRegistry;
import com.google.common.base.Charsets;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.Iterables;
import com.google.common.io.Files;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.lang.reflect.AnnotatedElement;
import java.nio.file.Path;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.zip.GZIPOutputStream;
import org.kohsuke.args4j.Argument;
import org.kohsuke.args4j.CmdLineException;
import org.kohsuke.args4j.CmdLineParser;
import org.kohsuke.args4j.Option;
import org.kohsuke.args4j.spi.FieldSetter;
import org.kohsuke.args4j.spi.MethodSetter;
import org.kohsuke.args4j.spi.Setter;
import org.opennms.newts.gsod.FileIterable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MergeSort {
    private static final Logger LOG = LoggerFactory.getLogger(MergeSort.class);
    private static final String HDR = "STN--- WBAN   YEARMODA    TEMP       DEWP      SLP        STP       VISIB      WDSP     MXSPD   GUST    MAX     MIN   PRCP   SNDP   FRSHTT";
    private File m_source;
    private File m_targetDir;
    private int m_mergeCount = 1000;

    public static void main(String ... args) throws IOException {
        new MergeSort().execute(args);
    }

    private void checkArgument(boolean check, String failureMessage) {
        if (!check) {
            throw new IllegalArgumentException(failureMessage);
        }
    }

    @Option(name="-c", aliases={"--merge-count"}, usage="the number of files to include in a single merge")
    public void setMergeCount(int mergeCount) {
        this.checkArgument(mergeCount > 1, "the merge count must be a number greater than 1.");
        this.m_mergeCount = mergeCount;
    }

    @Argument(index=0, metaVar="sourceDir", required=true, usage="the source directory that contains gsod")
    public void setSource(File source) {
        this.checkArgument(source.exists(), "the source directory does not exist");
        this.checkArgument(source.isDirectory(), "the source directory must be a directory");
        this.m_source = source;
    }

    @Argument(index=1, metaVar="targetDir", required=true, usage="the target directory for the sourted output")
    public void setTarget(File target) {
        this.m_targetDir = target;
        target.mkdirs();
    }

    public void execute(String ... args) throws IOException {
        CmdLineParser parser = this.createCmdLineParser();
        try {
            parser.parseArgument(args);
        }
        catch (CmdLineException e) {
            System.err.println(e.getMessage());
            parser.printUsage(System.err);
            return;
        }
        MetricRegistry metrics = new MetricRegistry();
        ConsoleReporter reporter = ConsoleReporter.forRegistry(metrics).outputTo(System.err).convertRatesTo(TimeUnit.SECONDS).convertDurationsTo(TimeUnit.MILLISECONDS).build();
        reporter.start(10L, TimeUnit.SECONDS);
        Meter linesMeter = metrics.meter("lines");
        Meter filesMeter = metrics.meter("files");
        Meter dirsMeter = metrics.meter("dirs");
        Meter batchMeter = metrics.meter("batches");
        Path root = this.m_source.toPath();
        if (this.m_targetDir == null) {
            this.m_targetDir = Files.createTempDir();
            System.err.println("Working Directory: " + this.m_targetDir);
        }
        LOG.debug("Scanning {} for GSOD data files...", (Object)root);
        FluentIterable<FileIterable.KeyedIterable<Path, Path>> dirs = FileIterable.groupFilesByDir(root);
        for (FileIterable.KeyedIterable keyedIterable : dirs) {
            Path subdir = root.relativize((Path)keyedIterable.getKey());
            String dirName = subdir.getFileName().toString();
            System.err.println("Sorted dir: " + subdir);
            FluentIterable<Iterable<String>> contentIterables = keyedIterable.transform(this.meter(filesMeter)).transform(this.lines("YEARMODA"));
            FluentIterable<List<Iterable<String>>> batches = FluentIterable.from(Iterables.partition(contentIterables, this.m_mergeCount));
            FluentIterable<Iterable<GSODLine>> sortedBatches = batches.transform(this.lift2GsodLines()).transform(this.mergeSorter());
            Path sortedDir = this.m_targetDir.toPath().resolve(subdir);
            sortedDir.toFile().mkdirs();
            int count = 1;
            for (Iterable iterable : sortedBatches) {
                Path sortedFile = sortedDir.resolve(dirName + "-batch-" + count++ + ".gz");
                System.err.println("Creating " + sortedFile);
                try (PrintStream out = this.open(sortedFile);){
                    out.println(HDR);
                    for (GSODLine line : iterable) {
                        out.println(line);
                        linesMeter.mark();
                    }
                }
                batchMeter.mark();
            }
            dirsMeter.mark();
        }
    }

    private PrintStream open(Path sortedFile) throws IOException, FileNotFoundException {
        return new PrintStream(new BufferedOutputStream(new GZIPOutputStream(new FileOutputStream(sortedFile.toFile())), 65536));
    }

    private CmdLineParser createCmdLineParser() {
        CmdLineParser parser = new CmdLineParser(this){

            @Override
            public void addArgument(final Setter setter, Argument a) {
                Setter newSetter = setter;
                if (setter instanceof MethodSetter) {
                    newSetter = new Setter(){

                        public void addValue(Object value) throws CmdLineException {
                            setter.addValue(value);
                        }

                        public Class getType() {
                            return setter.getType();
                        }

                        @Override
                        public boolean isMultiValued() {
                            return false;
                        }

                        @Override
                        public FieldSetter asFieldSetter() {
                            return setter.asFieldSetter();
                        }

                        @Override
                        public AnnotatedElement asAnnotatedElement() {
                            return setter.asAnnotatedElement();
                        }
                    };
                }
                super.addArgument(newSetter, a);
            }
        };
        return parser;
    }

    private Function<? super Iterable<Iterable<GSODLine>>, Iterable<GSODLine>> mergeSorter() {
        return new Function<Iterable<Iterable<GSODLine>>, Iterable<GSODLine>>(){

            @Override
            public Iterable<GSODLine> apply(Iterable<Iterable<GSODLine>> input) {
                return Iterables.mergeSorted(input, new Comparator<GSODLine>(){

                    @Override
                    public int compare(GSODLine o1, GSODLine o2) {
                        return o1.compareTo(o2);
                    }
                });
            }
        };
    }

    private Function<? super Path, Iterable<String>> lines(final String excludePattern) {
        return new Function<Path, Iterable<String>>(){

            @Override
            public Iterable<String> apply(Path input) {
                return FileIterable.unzipLines(input, Charsets.US_ASCII).filter(MergeSort.this.excludes(excludePattern));
            }
        };
    }

    private Predicate<? super String> excludes(final String excludePattern) {
        return new Predicate<String>(){

            @Override
            public boolean apply(String input) {
                return !input.contains(excludePattern);
            }
        };
    }

    private <T> Function<T, T> meter(final Meter meter) {
        return new Function<T, T>(){

            @Override
            public T apply(T input) {
                meter.mark();
                return input;
            }
        };
    }

    private Function<String, GSODLine> gsodLines() {
        return new Function<String, GSODLine>(){

            @Override
            public GSODLine apply(String input) {
                return new GSODLine(input);
            }
        };
    }

    private Function<Iterable<String>, Iterable<GSODLine>> liftGsodLines() {
        return new Function<Iterable<String>, Iterable<GSODLine>>(){

            @Override
            public Iterable<GSODLine> apply(Iterable<String> input) {
                return Iterables.transform(input, MergeSort.this.gsodLines());
            }
        };
    }

    private Function<List<Iterable<String>>, Iterable<Iterable<GSODLine>>> lift2GsodLines() {
        return new Function<List<Iterable<String>>, Iterable<Iterable<GSODLine>>>(){

            @Override
            public Iterable<Iterable<GSODLine>> apply(List<Iterable<String>> input) {
                return Iterables.transform(input, MergeSort.this.liftGsodLines());
            }
        };
    }

    public static class GSODLine
    implements Comparable<GSODLine> {
        private long m_date;
        private long m_stn;
        private long m_wban;
        private String m_line;

        public GSODLine(String line) {
            this.m_line = line;
            this.m_stn = this.longAt(0);
            this.m_wban = this.longAt(7);
            this.m_date = this.longAt(14);
        }

        public long longAt(int index) {
            char ch;
            long n = 0L;
            while ((ch = this.m_line.charAt(index)) != ' ') {
                n = n * 10L + (long)(ch - 48);
                ++index;
            }
            return n;
        }

        @Override
        public int compareTo(GSODLine o) {
            if (this.m_date < o.m_date) {
                return -1;
            }
            if (this.m_date > o.m_date) {
                return 1;
            }
            if (this.m_stn < o.m_stn) {
                return -1;
            }
            if (this.m_stn > o.m_stn) {
                return 1;
            }
            if (this.m_wban < o.m_wban) {
                return -1;
            }
            if (this.m_wban > o.m_wban) {
                return 1;
            }
            return 0;
        }

        public String getLine() {
            return this.m_line;
        }

        public String toString() {
            return this.m_line;
        }

        public long getStation() {
            return this.m_stn;
        }

        public long getWBAN() {
            return this.m_wban;
        }

        public long getDate() {
            return this.m_date;
        }
    }
}

