/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.newts.gsod;

import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import spark.Request;
import spark.Response;
import spark.Spark;
import spark.template.velocity.VelocityRoute;

public class Web {
    private static final Map<String, String> STATION_IDS = Maps.newHashMap();
    private static final Map<String, String> STATION_NAMES = Maps.newTreeMap();

    public static void main(String ... args) {
        Spark.staticFileLocation("/static");
        Spark.get(new VelocityRoute("/stations"){

            @Override
            public Object handle(Request request, Response response) {
                HashMap<String, Map> model = Maps.newHashMap();
                model.put("stationsMap", STATION_NAMES);
                return this.modelAndView(model, "index.wm");
            }
        });
        Spark.get(new VelocityRoute("/summer88"){

            @Override
            public Object handle(Request arg0, Response arg1) {
                HashMap<String, Map> model = Maps.newHashMap();
                model.put("stationIds", STATION_IDS);
                return this.modelAndView(model, "summer.wm");
            }
        });
        Spark.get(new VelocityRoute("/stations/:stationName"){

            @Override
            public Object handle(Request request, Response response) {
                String stationName = request.params(":stationName");
                String id = (String)STATION_IDS.get(stationName);
                if (id == null) {
                    3.halt(404, "No such station");
                }
                HashMap model = Maps.newHashMap();
                model.put("location", STATION_NAMES.get(stationName));
                model.put("id", id);
                model.put("start", request.queryParams("start"));
                model.put("end", request.queryParams("end"));
                model.put("resolution", request.queryParams("resolution"));
                return this.modelAndView(model, "station.wm");
            }
        });
    }

    static {
        STATION_IDS.put("ksat", "722530");
        STATION_IDS.put("kdal", "722585");
        STATION_IDS.put("kelp", "722700");
        STATION_IDS.put("kiah", "722430");
        STATION_IDS.put("kaus", "722545");
        STATION_IDS.put("klbb", "722670");
        STATION_NAMES.put("ksat", "San Antonio");
        STATION_NAMES.put("kdal", "Dallas");
        STATION_NAMES.put("kelp", "El Paso");
        STATION_NAMES.put("kiah", "Houston");
        STATION_NAMES.put("kaus", "Austin");
        STATION_NAMES.put("klbb", "Lubbock");
    }
}

