/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.newts.persistence.cassandra;

import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.Row;
import com.google.common.base.Function;
import com.google.common.base.Throwables;
import com.google.common.collect.Iterators;
import java.util.Collection;
import java.util.Iterator;
import java.util.concurrent.Future;

public class ConcurrentResultWrapper
implements Iterator<Row> {
    private Iterator<Row> m_rowIter;

    public ConcurrentResultWrapper(Collection<Future<ResultSet>> futures) {
        this.m_rowIter = Iterators.concat(this.getIterators(futures));
    }

    private Iterator<Iterator<Row>> getIterators(Collection<Future<ResultSet>> futures) {
        return Iterators.transform(futures.iterator(), new Function<Future<ResultSet>, Iterator<Row>>(){

            @Override
            public Iterator<Row> apply(Future<ResultSet> input) {
                try {
                    return input.get().iterator();
                }
                catch (Exception e) {
                    throw Throwables.propagate(e);
                }
            }
        });
    }

    @Override
    public boolean hasNext() {
        return this.m_rowIter.hasNext();
    }

    @Override
    public Row next() {
        return this.m_rowIter.next();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

