/*
 * Decompiled with CFR 0.152.
 */
package rx;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import rx.Notification;
import rx.Observer;
import rx.Scheduler;
import rx.Subscriber;
import rx.Subscription;
import rx.exceptions.Exceptions;
import rx.exceptions.OnErrorNotImplementedException;
import rx.exceptions.OnErrorThrowable;
import rx.functions.Action0;
import rx.functions.Action1;
import rx.functions.Action2;
import rx.functions.Func0;
import rx.functions.Func1;
import rx.functions.Func2;
import rx.functions.Func3;
import rx.functions.Func4;
import rx.functions.Func5;
import rx.functions.Func6;
import rx.functions.Func7;
import rx.functions.Func8;
import rx.functions.Func9;
import rx.functions.FuncN;
import rx.functions.Function;
import rx.functions.Functions;
import rx.joins.Pattern2;
import rx.joins.Plan0;
import rx.observables.BlockingObservable;
import rx.observables.ConnectableObservable;
import rx.observables.GroupedObservable;
import rx.observers.SafeSubscriber;
import rx.operators.OnSubscribeFromIterable;
import rx.operators.OnSubscribeRange;
import rx.operators.OperationAll;
import rx.operators.OperationAny;
import rx.operators.OperationAsObservable;
import rx.operators.OperationAverage;
import rx.operators.OperationBuffer;
import rx.operators.OperationCombineLatest;
import rx.operators.OperationConcat;
import rx.operators.OperationDebounce;
import rx.operators.OperationDefaultIfEmpty;
import rx.operators.OperationDefer;
import rx.operators.OperationDelay;
import rx.operators.OperationDematerialize;
import rx.operators.OperationDistinct;
import rx.operators.OperationDistinctUntilChanged;
import rx.operators.OperationFinally;
import rx.operators.OperationFlatMap;
import rx.operators.OperationGroupByUntil;
import rx.operators.OperationGroupJoin;
import rx.operators.OperationInterval;
import rx.operators.OperationJoin;
import rx.operators.OperationJoinPatterns;
import rx.operators.OperationMergeDelayError;
import rx.operators.OperationMergeMaxConcurrent;
import rx.operators.OperationMinMax;
import rx.operators.OperationMulticast;
import rx.operators.OperationOnErrorResumeNextViaObservable;
import rx.operators.OperationOnErrorReturn;
import rx.operators.OperationOnExceptionResumeNextViaObservable;
import rx.operators.OperationParallelMerge;
import rx.operators.OperationReplay;
import rx.operators.OperationSample;
import rx.operators.OperationSequenceEqual;
import rx.operators.OperationSingle;
import rx.operators.OperationSkip;
import rx.operators.OperationSkipLast;
import rx.operators.OperationSkipUntil;
import rx.operators.OperationSum;
import rx.operators.OperationSwitch;
import rx.operators.OperationTakeLast;
import rx.operators.OperationTakeTimed;
import rx.operators.OperationTakeUntil;
import rx.operators.OperationTakeWhile;
import rx.operators.OperationThrottleFirst;
import rx.operators.OperationTimeInterval;
import rx.operators.OperationTimer;
import rx.operators.OperationToMap;
import rx.operators.OperationToMultimap;
import rx.operators.OperationToObservableFuture;
import rx.operators.OperationUsing;
import rx.operators.OperationWindow;
import rx.operators.OperatorAmb;
import rx.operators.OperatorCache;
import rx.operators.OperatorCast;
import rx.operators.OperatorDoOnEach;
import rx.operators.OperatorElementAt;
import rx.operators.OperatorFilter;
import rx.operators.OperatorGroupBy;
import rx.operators.OperatorMap;
import rx.operators.OperatorMaterialize;
import rx.operators.OperatorMerge;
import rx.operators.OperatorObserveOn;
import rx.operators.OperatorOnErrorFlatMap;
import rx.operators.OperatorOnErrorResumeNextViaFunction;
import rx.operators.OperatorParallel;
import rx.operators.OperatorPivot;
import rx.operators.OperatorRepeat;
import rx.operators.OperatorRetry;
import rx.operators.OperatorScan;
import rx.operators.OperatorSerialize;
import rx.operators.OperatorSkip;
import rx.operators.OperatorSkipWhile;
import rx.operators.OperatorSubscribeOn;
import rx.operators.OperatorSynchronize;
import rx.operators.OperatorTake;
import rx.operators.OperatorTimeout;
import rx.operators.OperatorTimeoutWithSelector;
import rx.operators.OperatorTimestamp;
import rx.operators.OperatorToObservableList;
import rx.operators.OperatorToObservableSortedList;
import rx.operators.OperatorUnsubscribeOn;
import rx.operators.OperatorZip;
import rx.operators.OperatorZipIterable;
import rx.plugins.RxJavaObservableExecutionHook;
import rx.plugins.RxJavaPlugins;
import rx.schedulers.Schedulers;
import rx.schedulers.TimeInterval;
import rx.schedulers.Timestamped;
import rx.subjects.AsyncSubject;
import rx.subjects.BehaviorSubject;
import rx.subjects.PublishSubject;
import rx.subjects.ReplaySubject;
import rx.subjects.Subject;
import rx.subscriptions.Subscriptions;

public class Observable<T> {
    final OnSubscribe<T> onSubscribe;
    private final RxJavaObservableExecutionHook hook = RxJavaPlugins.getInstance().getObservableExecutionHook();

    protected Observable(OnSubscribe<T> f) {
        this.onSubscribe = f;
    }

    public static final <T> Observable<T> create(OnSubscribe<T> f) {
        return new Observable<T>(f);
    }

    @Deprecated
    public static final <T> Observable<T> create(final OnSubscribeFunc<T> f) {
        return new Observable<T>(new OnSubscribe<T>(){

            @Override
            public void call(Subscriber<? super T> observer) {
                Subscription s = f.onSubscribe(observer);
                if (s != null && s != observer) {
                    observer.add(s);
                }
            }
        });
    }

    public <R> Observable<R> lift(final Operator<? extends R, ? super T> lift) {
        return new Observable<T>(new OnSubscribe<R>(){

            @Override
            public void call(Subscriber<? super R> o) {
                try {
                    Observable.this.onSubscribe.call(Observable.this.hook.onLift(lift).call(o));
                }
                catch (Throwable e) {
                    if (e instanceof OnErrorNotImplementedException) {
                        throw (OnErrorNotImplementedException)e;
                    }
                    o.onError(e);
                }
            }
        });
    }

    public static final <T> Observable<T> amb(Iterable<? extends Observable<? extends T>> sources) {
        return Observable.create(OperatorAmb.amb(sources));
    }

    public static final <T> Observable<T> amb(Observable<? extends T> o1, Observable<? extends T> o2) {
        return Observable.create(OperatorAmb.amb(o1, o2));
    }

    public static final <T> Observable<T> amb(Observable<? extends T> o1, Observable<? extends T> o2, Observable<? extends T> o3) {
        return Observable.create(OperatorAmb.amb(o1, o2, o3));
    }

    public static final <T> Observable<T> amb(Observable<? extends T> o1, Observable<? extends T> o2, Observable<? extends T> o3, Observable<? extends T> o4) {
        return Observable.create(OperatorAmb.amb(o1, o2, o3, o4));
    }

    public static final <T> Observable<T> amb(Observable<? extends T> o1, Observable<? extends T> o2, Observable<? extends T> o3, Observable<? extends T> o4, Observable<? extends T> o5) {
        return Observable.create(OperatorAmb.amb(o1, o2, o3, o4, o5));
    }

    public static final <T> Observable<T> amb(Observable<? extends T> o1, Observable<? extends T> o2, Observable<? extends T> o3, Observable<? extends T> o4, Observable<? extends T> o5, Observable<? extends T> o6) {
        return Observable.create(OperatorAmb.amb(o1, o2, o3, o4, o5, o6));
    }

    public static final <T> Observable<T> amb(Observable<? extends T> o1, Observable<? extends T> o2, Observable<? extends T> o3, Observable<? extends T> o4, Observable<? extends T> o5, Observable<? extends T> o6, Observable<? extends T> o7) {
        return Observable.create(OperatorAmb.amb(o1, o2, o3, o4, o5, o6, o7));
    }

    public static final <T> Observable<T> amb(Observable<? extends T> o1, Observable<? extends T> o2, Observable<? extends T> o3, Observable<? extends T> o4, Observable<? extends T> o5, Observable<? extends T> o6, Observable<? extends T> o7, Observable<? extends T> o8) {
        return Observable.create(OperatorAmb.amb(o1, o2, o3, o4, o5, o6, o7, o8));
    }

    public static final <T> Observable<T> amb(Observable<? extends T> o1, Observable<? extends T> o2, Observable<? extends T> o3, Observable<? extends T> o4, Observable<? extends T> o5, Observable<? extends T> o6, Observable<? extends T> o7, Observable<? extends T> o8, Observable<? extends T> o9) {
        return Observable.create(OperatorAmb.amb(o1, o2, o3, o4, o5, o6, o7, o8, o9));
    }

    @Deprecated
    public static final Observable<Integer> average(Observable<Integer> source) {
        return OperationAverage.average(source);
    }

    public static final Observable<Double> averageDouble(Observable<Double> source) {
        return OperationAverage.averageDoubles(source);
    }

    public static final Observable<Float> averageFloat(Observable<Float> source) {
        return OperationAverage.averageFloats(source);
    }

    public static final Observable<Integer> averageInteger(Observable<Integer> source) {
        return OperationAverage.average(source);
    }

    public static final Observable<Long> averageLong(Observable<Long> source) {
        return OperationAverage.averageLongs(source);
    }

    public static final <T1, T2, R> Observable<R> combineLatest(Observable<? extends T1> o1, Observable<? extends T2> o2, Func2<? super T1, ? super T2, ? extends R> combineFunction) {
        return Observable.create(OperationCombineLatest.combineLatest(o1, o2, combineFunction));
    }

    public static final <T1, T2, T3, R> Observable<R> combineLatest(Observable<? extends T1> o1, Observable<? extends T2> o2, Observable<? extends T3> o3, Func3<? super T1, ? super T2, ? super T3, ? extends R> combineFunction) {
        return Observable.create(OperationCombineLatest.combineLatest(o1, o2, o3, combineFunction));
    }

    public static final <T1, T2, T3, T4, R> Observable<R> combineLatest(Observable<? extends T1> o1, Observable<? extends T2> o2, Observable<? extends T3> o3, Observable<? extends T4> o4, Func4<? super T1, ? super T2, ? super T3, ? super T4, ? extends R> combineFunction) {
        return Observable.create(OperationCombineLatest.combineLatest(o1, o2, o3, o4, combineFunction));
    }

    public static final <T1, T2, T3, T4, T5, R> Observable<R> combineLatest(Observable<? extends T1> o1, Observable<? extends T2> o2, Observable<? extends T3> o3, Observable<? extends T4> o4, Observable<? extends T5> o5, Func5<? super T1, ? super T2, ? super T3, ? super T4, ? super T5, ? extends R> combineFunction) {
        return Observable.create(OperationCombineLatest.combineLatest(o1, o2, o3, o4, o5, combineFunction));
    }

    public static final <T1, T2, T3, T4, T5, T6, R> Observable<R> combineLatest(Observable<? extends T1> o1, Observable<? extends T2> o2, Observable<? extends T3> o3, Observable<? extends T4> o4, Observable<? extends T5> o5, Observable<? extends T6> o6, Func6<? super T1, ? super T2, ? super T3, ? super T4, ? super T5, ? super T6, ? extends R> combineFunction) {
        return Observable.create(OperationCombineLatest.combineLatest(o1, o2, o3, o4, o5, o6, combineFunction));
    }

    public static final <T1, T2, T3, T4, T5, T6, T7, R> Observable<R> combineLatest(Observable<? extends T1> o1, Observable<? extends T2> o2, Observable<? extends T3> o3, Observable<? extends T4> o4, Observable<? extends T5> o5, Observable<? extends T6> o6, Observable<? extends T7> o7, Func7<? super T1, ? super T2, ? super T3, ? super T4, ? super T5, ? super T6, ? super T7, ? extends R> combineFunction) {
        return Observable.create(OperationCombineLatest.combineLatest(o1, o2, o3, o4, o5, o6, o7, combineFunction));
    }

    public static final <T1, T2, T3, T4, T5, T6, T7, T8, R> Observable<R> combineLatest(Observable<? extends T1> o1, Observable<? extends T2> o2, Observable<? extends T3> o3, Observable<? extends T4> o4, Observable<? extends T5> o5, Observable<? extends T6> o6, Observable<? extends T7> o7, Observable<? extends T8> o8, Func8<? super T1, ? super T2, ? super T3, ? super T4, ? super T5, ? super T6, ? super T7, ? super T8, ? extends R> combineFunction) {
        return Observable.create(OperationCombineLatest.combineLatest(o1, o2, o3, o4, o5, o6, o7, o8, combineFunction));
    }

    public static final <T1, T2, T3, T4, T5, T6, T7, T8, T9, R> Observable<R> combineLatest(Observable<? extends T1> o1, Observable<? extends T2> o2, Observable<? extends T3> o3, Observable<? extends T4> o4, Observable<? extends T5> o5, Observable<? extends T6> o6, Observable<? extends T7> o7, Observable<? extends T8> o8, Observable<? extends T9> o9, Func9<? super T1, ? super T2, ? super T3, ? super T4, ? super T5, ? super T6, ? super T7, ? super T8, ? super T9, ? extends R> combineFunction) {
        return Observable.create(OperationCombineLatest.combineLatest(o1, o2, o3, o4, o5, o6, o7, o8, o9, combineFunction));
    }

    public static final <T> Observable<T> concat(Observable<? extends Observable<? extends T>> observables) {
        return Observable.create(OperationConcat.concat(observables));
    }

    public static final <T> Observable<T> concat(Observable<? extends T> t1, Observable<? extends T> t2) {
        return Observable.create(OperationConcat.concat(t1, t2));
    }

    public static final <T> Observable<T> concat(Observable<? extends T> t1, Observable<? extends T> t2, Observable<? extends T> t3) {
        return Observable.create(OperationConcat.concat(t1, t2, t3));
    }

    public static final <T> Observable<T> concat(Observable<? extends T> t1, Observable<? extends T> t2, Observable<? extends T> t3, Observable<? extends T> t4) {
        return Observable.create(OperationConcat.concat(t1, t2, t3, t4));
    }

    public static final <T> Observable<T> concat(Observable<? extends T> t1, Observable<? extends T> t2, Observable<? extends T> t3, Observable<? extends T> t4, Observable<? extends T> t5) {
        return Observable.create(OperationConcat.concat(t1, t2, t3, t4, t5));
    }

    public static final <T> Observable<T> concat(Observable<? extends T> t1, Observable<? extends T> t2, Observable<? extends T> t3, Observable<? extends T> t4, Observable<? extends T> t5, Observable<? extends T> t6) {
        return Observable.create(OperationConcat.concat(t1, t2, t3, t4, t5, t6));
    }

    public static final <T> Observable<T> concat(Observable<? extends T> t1, Observable<? extends T> t2, Observable<? extends T> t3, Observable<? extends T> t4, Observable<? extends T> t5, Observable<? extends T> t6, Observable<? extends T> t7) {
        return Observable.create(OperationConcat.concat(t1, t2, t3, t4, t5, t6, t7));
    }

    public static final <T> Observable<T> concat(Observable<? extends T> t1, Observable<? extends T> t2, Observable<? extends T> t3, Observable<? extends T> t4, Observable<? extends T> t5, Observable<? extends T> t6, Observable<? extends T> t7, Observable<? extends T> t8) {
        return Observable.create(OperationConcat.concat(t1, t2, t3, t4, t5, t6, t7, t8));
    }

    public static final <T> Observable<T> concat(Observable<? extends T> t1, Observable<? extends T> t2, Observable<? extends T> t3, Observable<? extends T> t4, Observable<? extends T> t5, Observable<? extends T> t6, Observable<? extends T> t7, Observable<? extends T> t8, Observable<? extends T> t9) {
        return Observable.create(OperationConcat.concat(t1, t2, t3, t4, t5, t6, t7, t8, t9));
    }

    public static final <T> Observable<T> defer(Func0<? extends Observable<? extends T>> observableFactory) {
        return Observable.create(OperationDefer.defer(observableFactory));
    }

    public static final <T> Observable<T> empty() {
        return Observable.from(new ArrayList());
    }

    public static final <T> Observable<T> empty(Scheduler scheduler) {
        return Observable.empty().subscribeOn(scheduler);
    }

    public static final <T> Observable<T> error(Throwable exception) {
        return new ThrowObservable(exception);
    }

    public static final <T> Observable<T> error(Throwable exception, Scheduler scheduler) {
        return Observable.error(exception).subscribeOn(scheduler);
    }

    public static final <T> Observable<T> from(Future<? extends T> future) {
        return Observable.create(OperationToObservableFuture.toObservableFuture(future));
    }

    public static final <T> Observable<T> from(Future<? extends T> future, long timeout, TimeUnit unit) {
        return Observable.create(OperationToObservableFuture.toObservableFuture(future, timeout, unit));
    }

    public static final <T> Observable<T> from(Future<? extends T> future, Scheduler scheduler) {
        return Observable.create(OperationToObservableFuture.toObservableFuture(future)).subscribeOn(scheduler);
    }

    public static final <T> Observable<T> from(Iterable<? extends T> iterable) {
        return Observable.create(new OnSubscribeFromIterable<T>(iterable));
    }

    public static final <T> Observable<T> from(Iterable<? extends T> iterable, Scheduler scheduler) {
        return Observable.create(new OnSubscribeFromIterable<T>(iterable)).subscribeOn(scheduler);
    }

    public static final <T> Observable<T> from(T t1) {
        return Observable.from(Arrays.asList(t1));
    }

    @Deprecated
    public static final <T> Observable<T> from(T t1, T t2) {
        return Observable.from(Arrays.asList(t1, t2));
    }

    @Deprecated
    public static final <T> Observable<T> from(T t1, T t2, T t3) {
        return Observable.from(Arrays.asList(t1, t2, t3));
    }

    @Deprecated
    public static final <T> Observable<T> from(T t1, T t2, T t3, T t4) {
        return Observable.from(Arrays.asList(t1, t2, t3, t4));
    }

    @Deprecated
    public static final <T> Observable<T> from(T t1, T t2, T t3, T t4, T t5) {
        return Observable.from(Arrays.asList(t1, t2, t3, t4, t5));
    }

    @Deprecated
    public static final <T> Observable<T> from(T t1, T t2, T t3, T t4, T t5, T t6) {
        return Observable.from(Arrays.asList(t1, t2, t3, t4, t5, t6));
    }

    @Deprecated
    public static final <T> Observable<T> from(T t1, T t2, T t3, T t4, T t5, T t6, T t7) {
        return Observable.from(Arrays.asList(t1, t2, t3, t4, t5, t6, t7));
    }

    @Deprecated
    public static final <T> Observable<T> from(T t1, T t2, T t3, T t4, T t5, T t6, T t7, T t8) {
        return Observable.from(Arrays.asList(t1, t2, t3, t4, t5, t6, t7, t8));
    }

    @Deprecated
    public static final <T> Observable<T> from(T t1, T t2, T t3, T t4, T t5, T t6, T t7, T t8, T t9) {
        return Observable.from(Arrays.asList(t1, t2, t3, t4, t5, t6, t7, t8, t9));
    }

    @Deprecated
    public static final <T> Observable<T> from(T t1, T t2, T t3, T t4, T t5, T t6, T t7, T t8, T t9, T t10) {
        return Observable.from(Arrays.asList(t1, t2, t3, t4, t5, t6, t7, t8, t9, t10));
    }

    public static final <T> Observable<T> from(T ... t1) {
        return Observable.from(Arrays.asList(t1));
    }

    public static final <T> Observable<T> from(T[] items, Scheduler scheduler) {
        return Observable.from(Arrays.asList(items), scheduler);
    }

    public static final Observable<Long> interval(long interval, TimeUnit unit) {
        return Observable.create(OperationInterval.interval(interval, unit));
    }

    public static final Observable<Long> interval(long interval, TimeUnit unit, Scheduler scheduler) {
        return Observable.create(OperationInterval.interval(interval, unit, scheduler));
    }

    public static final <T> Observable<T> just(final T value) {
        return Observable.create(new OnSubscribe<T>(){

            @Override
            public void call(Subscriber<? super T> s) {
                if (!s.isUnsubscribed()) {
                    s.onNext(value);
                    s.onCompleted();
                }
            }
        });
    }

    @Deprecated
    public static final <T> Observable<T> just(T value, Scheduler scheduler) {
        return Observable.just(value).subscribeOn(scheduler);
    }

    public static final <T extends Comparable<? super T>> Observable<T> max(Observable<T> source) {
        return OperationMinMax.max(source);
    }

    public static final <T> Observable<T> merge(Iterable<? extends Observable<? extends T>> sequences) {
        return Observable.merge(Observable.from(sequences));
    }

    public static final <T> Observable<T> merge(Iterable<? extends Observable<? extends T>> sequences, int maxConcurrent) {
        return Observable.merge(Observable.from(sequences), maxConcurrent);
    }

    public static final <T> Observable<T> merge(Iterable<? extends Observable<? extends T>> sequences, int maxConcurrent, Scheduler scheduler) {
        return Observable.merge(Observable.from(sequences, scheduler), maxConcurrent);
    }

    public static final <T> Observable<T> merge(Iterable<? extends Observable<? extends T>> sequences, Scheduler scheduler) {
        return Observable.merge(Observable.from(sequences, scheduler));
    }

    public static final <T> Observable<T> merge(Observable<? extends Observable<? extends T>> source) {
        return source.lift(new OperatorMerge());
    }

    public static final <T> Observable<T> merge(Observable<? extends Observable<? extends T>> source, int maxConcurrent) {
        return Observable.create(OperationMergeMaxConcurrent.merge(source, maxConcurrent));
    }

    public static final <T> Observable<T> merge(Observable<? extends T> t1, Observable<? extends T> t2) {
        return Observable.merge(Observable.from(Arrays.asList(t1, t2)));
    }

    public static final <T> Observable<T> merge(Observable<? extends T> t1, Observable<? extends T> t2, Observable<? extends T> t3) {
        return Observable.merge(Observable.from(Arrays.asList(t1, t2, t3)));
    }

    public static final <T> Observable<T> merge(Observable<? extends T> t1, Observable<? extends T> t2, Observable<? extends T> t3, Observable<? extends T> t4) {
        return Observable.merge(Observable.from(Arrays.asList(t1, t2, t3, t4)));
    }

    public static final <T> Observable<T> merge(Observable<? extends T> t1, Observable<? extends T> t2, Observable<? extends T> t3, Observable<? extends T> t4, Observable<? extends T> t5) {
        return Observable.merge(Observable.from(Arrays.asList(t1, t2, t3, t4, t5)));
    }

    public static final <T> Observable<T> merge(Observable<? extends T> t1, Observable<? extends T> t2, Observable<? extends T> t3, Observable<? extends T> t4, Observable<? extends T> t5, Observable<? extends T> t6) {
        return Observable.merge(Observable.from(Arrays.asList(t1, t2, t3, t4, t5, t6)));
    }

    public static final <T> Observable<T> merge(Observable<? extends T> t1, Observable<? extends T> t2, Observable<? extends T> t3, Observable<? extends T> t4, Observable<? extends T> t5, Observable<? extends T> t6, Observable<? extends T> t7) {
        return Observable.merge(Observable.from(Arrays.asList(t1, t2, t3, t4, t5, t6, t7)));
    }

    public static final <T> Observable<T> merge(Observable<? extends T> t1, Observable<? extends T> t2, Observable<? extends T> t3, Observable<? extends T> t4, Observable<? extends T> t5, Observable<? extends T> t6, Observable<? extends T> t7, Observable<? extends T> t8) {
        return Observable.merge(Observable.from(Arrays.asList(t1, t2, t3, t4, t5, t6, t7, t8)));
    }

    public static final <T> Observable<T> merge(Observable<? extends T> t1, Observable<? extends T> t2, Observable<? extends T> t3, Observable<? extends T> t4, Observable<? extends T> t5, Observable<? extends T> t6, Observable<? extends T> t7, Observable<? extends T> t8, Observable<? extends T> t9) {
        return Observable.merge(Observable.from(Arrays.asList(t1, t2, t3, t4, t5, t6, t7, t8, t9)));
    }

    public static final <T> Observable<T> merge(Observable<? extends T>[] sequences) {
        return Observable.merge(Observable.from(sequences));
    }

    public static final <T> Observable<T> merge(Observable<? extends T>[] sequences, Scheduler scheduler) {
        return Observable.merge(Observable.from(sequences, scheduler));
    }

    public static final <T> Observable<T> mergeDelayError(Observable<? extends Observable<? extends T>> source) {
        return Observable.create(OperationMergeDelayError.mergeDelayError(source));
    }

    public static final <T> Observable<T> mergeDelayError(Observable<? extends T> t1, Observable<? extends T> t2) {
        return Observable.create(OperationMergeDelayError.mergeDelayError(t1, t2));
    }

    public static final <T> Observable<T> mergeDelayError(Observable<? extends T> t1, Observable<? extends T> t2, Observable<? extends T> t3) {
        return Observable.create(OperationMergeDelayError.mergeDelayError(t1, t2, t3));
    }

    public static final <T> Observable<T> mergeDelayError(Observable<? extends T> t1, Observable<? extends T> t2, Observable<? extends T> t3, Observable<? extends T> t4) {
        return Observable.create(OperationMergeDelayError.mergeDelayError(t1, t2, t3, t4));
    }

    public static final <T> Observable<T> mergeDelayError(Observable<? extends T> t1, Observable<? extends T> t2, Observable<? extends T> t3, Observable<? extends T> t4, Observable<? extends T> t5) {
        return Observable.create(OperationMergeDelayError.mergeDelayError(t1, t2, t3, t4, t5));
    }

    public static final <T> Observable<T> mergeDelayError(Observable<? extends T> t1, Observable<? extends T> t2, Observable<? extends T> t3, Observable<? extends T> t4, Observable<? extends T> t5, Observable<? extends T> t6) {
        return Observable.create(OperationMergeDelayError.mergeDelayError(t1, t2, t3, t4, t5, t6));
    }

    public static final <T> Observable<T> mergeDelayError(Observable<? extends T> t1, Observable<? extends T> t2, Observable<? extends T> t3, Observable<? extends T> t4, Observable<? extends T> t5, Observable<? extends T> t6, Observable<? extends T> t7) {
        return Observable.create(OperationMergeDelayError.mergeDelayError(t1, t2, t3, t4, t5, t6, t7));
    }

    public static final <T> Observable<T> mergeDelayError(Observable<? extends T> t1, Observable<? extends T> t2, Observable<? extends T> t3, Observable<? extends T> t4, Observable<? extends T> t5, Observable<? extends T> t6, Observable<? extends T> t7, Observable<? extends T> t8) {
        return Observable.create(OperationMergeDelayError.mergeDelayError(t1, t2, t3, t4, t5, t6, t7, t8));
    }

    public static final <T> Observable<T> mergeDelayError(Observable<? extends T> t1, Observable<? extends T> t2, Observable<? extends T> t3, Observable<? extends T> t4, Observable<? extends T> t5, Observable<? extends T> t6, Observable<? extends T> t7, Observable<? extends T> t8, Observable<? extends T> t9) {
        return Observable.create(OperationMergeDelayError.mergeDelayError(t1, t2, t3, t4, t5, t6, t7, t8, t9));
    }

    public static final <T extends Comparable<? super T>> Observable<T> min(Observable<T> source) {
        return OperationMinMax.min(source);
    }

    public final Observable<Observable<T>> nest() {
        return Observable.just(this);
    }

    public static final <T> Observable<T> never() {
        return new NeverObservable();
    }

    public static final <T> Observable<Observable<T>> parallelMerge(Observable<Observable<T>> source, int parallelObservables) {
        return OperationParallelMerge.parallelMerge(source, parallelObservables);
    }

    public static final <T> Observable<Observable<T>> parallelMerge(Observable<Observable<T>> source, int parallelObservables, Scheduler scheduler) {
        return OperationParallelMerge.parallelMerge(source, parallelObservables, scheduler);
    }

    public static final <K1, K2, T> Observable<GroupedObservable<K2, GroupedObservable<K1, T>>> pivot(Observable<GroupedObservable<K1, GroupedObservable<K2, T>>> groups) {
        return groups.lift(new OperatorPivot());
    }

    public static final Observable<Integer> range(int start, int count) {
        if (count < 0) {
            throw new IllegalArgumentException("Count can not be negative");
        }
        if (start + count > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("start + count can not exceed Integer.MAX_VALUE");
        }
        return Observable.create(new OnSubscribeRange(start, start + (count - 1)));
    }

    public static final Observable<Integer> range(int start, int count, Scheduler scheduler) {
        return Observable.range(start, count).subscribeOn(scheduler);
    }

    public static final <T> Observable<Boolean> sequenceEqual(Observable<? extends T> first, Observable<? extends T> second) {
        return Observable.sequenceEqual(first, second, new Func2<T, T, Boolean>(){

            @Override
            public final Boolean call(T first, T second) {
                if (first == null) {
                    return second == null;
                }
                return first.equals(second);
            }
        });
    }

    public static final <T> Observable<Boolean> sequenceEqual(Observable<? extends T> first, Observable<? extends T> second, Func2<? super T, ? super T, Boolean> equality) {
        return OperationSequenceEqual.sequenceEqual(first, second, equality);
    }

    public static final Observable<Double> sumDouble(Observable<Double> source) {
        return OperationSum.sumDoubles(source);
    }

    public static final Observable<Float> sumFloat(Observable<Float> source) {
        return OperationSum.sumFloats(source);
    }

    public static final Observable<Integer> sumInteger(Observable<Integer> source) {
        return OperationSum.sumIntegers(source);
    }

    public static final Observable<Long> sumLong(Observable<Long> source) {
        return OperationSum.sumLongs(source);
    }

    @Deprecated
    public static final <T> Observable<T> switchDo(Observable<? extends Observable<? extends T>> sequenceOfSequences) {
        return Observable.create(OperationSwitch.switchDo(sequenceOfSequences));
    }

    public static final <T> Observable<T> switchLatest(Observable<? extends Observable<? extends T>> sequenceOfSequences) {
        return Observable.create(OperationSwitch.switchDo(sequenceOfSequences));
    }

    public static final <T> Observable<T> switchOnNext(Observable<? extends Observable<? extends T>> sequenceOfSequences) {
        return Observable.create(OperationSwitch.switchDo(sequenceOfSequences));
    }

    @Deprecated
    public static final <T> Observable<T> synchronize(Observable<T> source) {
        return source.synchronize();
    }

    public static final Observable<Long> timer(long initialDelay, long period, TimeUnit unit) {
        return Observable.timer(initialDelay, period, unit, Schedulers.computation());
    }

    public static final Observable<Long> timer(long initialDelay, long period, TimeUnit unit, Scheduler scheduler) {
        return Observable.create(new OperationTimer.TimerPeriodically(initialDelay, period, unit, scheduler));
    }

    public static final Observable<Long> timer(long delay, TimeUnit unit) {
        return Observable.timer(delay, unit, Schedulers.computation());
    }

    public static final Observable<Long> timer(long delay, TimeUnit unit, Scheduler scheduler) {
        return Observable.create(new OperationTimer.TimerOnce(delay, unit, scheduler));
    }

    public static final <T, RESOURCE extends Subscription> Observable<T> using(Func0<RESOURCE> resourceFactory, Func1<RESOURCE, Observable<T>> observableFactory) {
        return Observable.create(OperationUsing.using(resourceFactory, observableFactory));
    }

    public static final <R> Observable<R> when(Iterable<? extends Plan0<R>> plans) {
        if (plans == null) {
            throw new NullPointerException("plans");
        }
        return Observable.create(OperationJoinPatterns.when(plans));
    }

    public static final <R> Observable<R> when(Plan0<R> ... plans) {
        return Observable.create(OperationJoinPatterns.when(plans));
    }

    public static final <R> Observable<R> when(Plan0<R> p1) {
        return Observable.create(OperationJoinPatterns.when(p1));
    }

    public static final <R> Observable<R> when(Plan0<R> p1, Plan0<R> p2) {
        return Observable.create(OperationJoinPatterns.when(p1, p2));
    }

    public static final <R> Observable<R> when(Plan0<R> p1, Plan0<R> p2, Plan0<R> p3) {
        return Observable.create(OperationJoinPatterns.when(p1, p2, p3));
    }

    public static final <R> Observable<R> when(Plan0<R> p1, Plan0<R> p2, Plan0<R> p3, Plan0<R> p4) {
        return Observable.create(OperationJoinPatterns.when(p1, p2, p3, p4));
    }

    public static final <R> Observable<R> when(Plan0<R> p1, Plan0<R> p2, Plan0<R> p3, Plan0<R> p4, Plan0<R> p5) {
        return Observable.create(OperationJoinPatterns.when(p1, p2, p3, p4, p5));
    }

    public static final <R> Observable<R> when(Plan0<R> p1, Plan0<R> p2, Plan0<R> p3, Plan0<R> p4, Plan0<R> p5, Plan0<R> p6) {
        return Observable.create(OperationJoinPatterns.when(p1, p2, p3, p4, p5, p6));
    }

    public static final <R> Observable<R> when(Plan0<R> p1, Plan0<R> p2, Plan0<R> p3, Plan0<R> p4, Plan0<R> p5, Plan0<R> p6, Plan0<R> p7) {
        return Observable.create(OperationJoinPatterns.when(p1, p2, p3, p4, p5, p6, p7));
    }

    public static final <R> Observable<R> when(Plan0<R> p1, Plan0<R> p2, Plan0<R> p3, Plan0<R> p4, Plan0<R> p5, Plan0<R> p6, Plan0<R> p7, Plan0<R> p8) {
        return Observable.create(OperationJoinPatterns.when(p1, p2, p3, p4, p5, p6, p7, p8));
    }

    public static final <R> Observable<R> when(Plan0<R> p1, Plan0<R> p2, Plan0<R> p3, Plan0<R> p4, Plan0<R> p5, Plan0<R> p6, Plan0<R> p7, Plan0<R> p8, Plan0<R> p9) {
        return Observable.create(OperationJoinPatterns.when(p1, p2, p3, p4, p5, p6, p7, p8, p9));
    }

    public static final <R> Observable<R> zip(Iterable<? extends Observable<?>> ws, FuncN<? extends R> zipFunction) {
        ArrayList os = new ArrayList();
        for (Observable<?> o : ws) {
            os.add(o);
        }
        return Observable.just(os.toArray(new Observable[os.size()])).lift(new OperatorZip<R>(zipFunction));
    }

    public static final <R> Observable<R> zip(Observable<? extends Observable<?>> ws, FuncN<? extends R> zipFunction) {
        return ws.toList().map(new Func1<List<? extends Observable<?>>, Observable<?>[]>(){

            @Override
            public Observable<?>[] call(List<? extends Observable<?>> o) {
                return o.toArray(new Observable[o.size()]);
            }
        }).lift(new OperatorZip<R>(zipFunction));
    }

    public static final <T1, T2, R> Observable<R> zip(Observable<? extends T1> o1, Observable<? extends T2> o2, Func2<? super T1, ? super T2, ? extends R> zipFunction) {
        return Observable.just(new Observable[]{o1, o2}).lift(new OperatorZip(zipFunction));
    }

    public static final <T1, T2, T3, R> Observable<R> zip(Observable<? extends T1> o1, Observable<? extends T2> o2, Observable<? extends T3> o3, Func3<? super T1, ? super T2, ? super T3, ? extends R> zipFunction) {
        return Observable.just(new Observable[]{o1, o2, o3}).lift(new OperatorZip(zipFunction));
    }

    public static final <T1, T2, T3, T4, R> Observable<R> zip(Observable<? extends T1> o1, Observable<? extends T2> o2, Observable<? extends T3> o3, Observable<? extends T4> o4, Func4<? super T1, ? super T2, ? super T3, ? super T4, ? extends R> zipFunction) {
        return Observable.just(new Observable[]{o1, o2, o3, o4}).lift(new OperatorZip(zipFunction));
    }

    public static final <T1, T2, T3, T4, T5, R> Observable<R> zip(Observable<? extends T1> o1, Observable<? extends T2> o2, Observable<? extends T3> o3, Observable<? extends T4> o4, Observable<? extends T5> o5, Func5<? super T1, ? super T2, ? super T3, ? super T4, ? super T5, ? extends R> zipFunction) {
        return Observable.just(new Observable[]{o1, o2, o3, o4, o5}).lift(new OperatorZip(zipFunction));
    }

    public static final <T1, T2, T3, T4, T5, T6, R> Observable<R> zip(Observable<? extends T1> o1, Observable<? extends T2> o2, Observable<? extends T3> o3, Observable<? extends T4> o4, Observable<? extends T5> o5, Observable<? extends T6> o6, Func6<? super T1, ? super T2, ? super T3, ? super T4, ? super T5, ? super T6, ? extends R> zipFunction) {
        return Observable.just(new Observable[]{o1, o2, o3, o4, o5, o6}).lift(new OperatorZip(zipFunction));
    }

    public static final <T1, T2, T3, T4, T5, T6, T7, R> Observable<R> zip(Observable<? extends T1> o1, Observable<? extends T2> o2, Observable<? extends T3> o3, Observable<? extends T4> o4, Observable<? extends T5> o5, Observable<? extends T6> o6, Observable<? extends T7> o7, Func7<? super T1, ? super T2, ? super T3, ? super T4, ? super T5, ? super T6, ? super T7, ? extends R> zipFunction) {
        return Observable.just(new Observable[]{o1, o2, o3, o4, o5, o6, o7}).lift(new OperatorZip(zipFunction));
    }

    public static final <T1, T2, T3, T4, T5, T6, T7, T8, R> Observable<R> zip(Observable<? extends T1> o1, Observable<? extends T2> o2, Observable<? extends T3> o3, Observable<? extends T4> o4, Observable<? extends T5> o5, Observable<? extends T6> o6, Observable<? extends T7> o7, Observable<? extends T8> o8, Func8<? super T1, ? super T2, ? super T3, ? super T4, ? super T5, ? super T6, ? super T7, ? super T8, ? extends R> zipFunction) {
        return Observable.just(new Observable[]{o1, o2, o3, o4, o5, o6, o7, o8}).lift(new OperatorZip(zipFunction));
    }

    public static final <T1, T2, T3, T4, T5, T6, T7, T8, T9, R> Observable<R> zip(Observable<? extends T1> o1, Observable<? extends T2> o2, Observable<? extends T3> o3, Observable<? extends T4> o4, Observable<? extends T5> o5, Observable<? extends T6> o6, Observable<? extends T7> o7, Observable<? extends T8> o8, Observable<? extends T9> o9, Func9<? super T1, ? super T2, ? super T3, ? super T4, ? super T5, ? super T6, ? super T7, ? super T8, ? super T9, ? extends R> zipFunction) {
        return Observable.just(new Observable[]{o1, o2, o3, o4, o5, o6, o7, o8, o9}).lift(new OperatorZip(zipFunction));
    }

    @Deprecated
    public final Observable<T> aggregate(Func2<T, T, T> accumulator) {
        return this.reduce(accumulator);
    }

    @Deprecated
    public final <R> Observable<R> aggregate(R initialValue, Func2<R, ? super T, R> accumulator) {
        return this.reduce(initialValue, accumulator);
    }

    public final Observable<Boolean> all(Func1<? super T, Boolean> predicate) {
        return Observable.create(OperationAll.all(this, predicate));
    }

    public final <T2> Pattern2<T, T2> and(Observable<T2> right) {
        return OperationJoinPatterns.and(this, right);
    }

    public final Observable<T> asObservable() {
        return Observable.create(new OperationAsObservable(this));
    }

    public final Observable<Double> averageDouble(Func1<? super T, Double> valueExtractor) {
        return Observable.create(new OperationAverage.AverageDoubleExtractor<T>(this, valueExtractor));
    }

    public final Observable<Float> averageFloat(Func1<? super T, Float> valueExtractor) {
        return Observable.create(new OperationAverage.AverageFloatExtractor<T>(this, valueExtractor));
    }

    public final Observable<Integer> averageInteger(Func1<? super T, Integer> valueExtractor) {
        return Observable.create(new OperationAverage.AverageIntegerExtractor<T>(this, valueExtractor));
    }

    public final Observable<Long> averageLong(Func1<? super T, Long> valueExtractor) {
        return Observable.create(new OperationAverage.AverageLongExtractor<T>(this, valueExtractor));
    }

    public final <TClosing> Observable<List<T>> buffer(Func0<? extends Observable<? extends TClosing>> bufferClosingSelector) {
        return Observable.create(OperationBuffer.buffer(this, bufferClosingSelector));
    }

    public final Observable<List<T>> buffer(int count) {
        return Observable.create(OperationBuffer.buffer(this, count));
    }

    public final Observable<List<T>> buffer(int count, int skip) {
        return Observable.create(OperationBuffer.buffer(this, count, skip));
    }

    public final Observable<List<T>> buffer(long timespan, long timeshift, TimeUnit unit) {
        return Observable.create(OperationBuffer.buffer(this, timespan, timeshift, unit));
    }

    public final Observable<List<T>> buffer(long timespan, long timeshift, TimeUnit unit, Scheduler scheduler) {
        return Observable.create(OperationBuffer.buffer(this, timespan, timeshift, unit, scheduler));
    }

    public final Observable<List<T>> buffer(long timespan, TimeUnit unit) {
        return Observable.create(OperationBuffer.buffer(this, timespan, unit));
    }

    public final Observable<List<T>> buffer(long timespan, TimeUnit unit, int count) {
        return Observable.create(OperationBuffer.buffer(this, timespan, unit, count));
    }

    public final Observable<List<T>> buffer(long timespan, TimeUnit unit, int count, Scheduler scheduler) {
        return Observable.create(OperationBuffer.buffer(this, timespan, unit, count, scheduler));
    }

    public final Observable<List<T>> buffer(long timespan, TimeUnit unit, Scheduler scheduler) {
        return Observable.create(OperationBuffer.buffer(this, timespan, unit, scheduler));
    }

    public final <TOpening, TClosing> Observable<List<T>> buffer(Observable<? extends TOpening> bufferOpenings, Func1<? super TOpening, ? extends Observable<? extends TClosing>> bufferClosingSelector) {
        return Observable.create(OperationBuffer.buffer(this, bufferOpenings, bufferClosingSelector));
    }

    public final <B> Observable<List<T>> buffer(Observable<B> boundary) {
        return Observable.create(OperationBuffer.bufferWithBoundaryObservable(this, boundary));
    }

    public final <B> Observable<List<T>> buffer(Observable<B> boundary, int initialCapacity) {
        return Observable.create(OperationBuffer.bufferWithBoundaryObservable(this, boundary, initialCapacity));
    }

    public final Observable<T> cache() {
        return Observable.create(new OperatorCache(this));
    }

    public final <R> Observable<R> cast(Class<R> klass) {
        return this.lift(new OperatorCast(klass));
    }

    public final <R> Observable<R> collect(R state, final Action2<R, ? super T> collector) {
        Func2 accumulator = new Func2<R, T, R>(){

            @Override
            public final R call(R state, T value) {
                collector.call(state, value);
                return state;
            }
        };
        return this.reduce(state, accumulator);
    }

    public final <R> Observable<R> concatMap(Func1<? super T, ? extends Observable<? extends R>> func) {
        return Observable.concat(this.map(func));
    }

    public final Observable<Boolean> contains(final T element) {
        return this.exists(new Func1<T, Boolean>(){

            @Override
            public final Boolean call(T t1) {
                return element == null ? t1 == null : element.equals(t1);
            }
        });
    }

    public final Observable<Integer> count() {
        return this.reduce(0, new Func2<Integer, T, Integer>(){

            @Override
            public final Integer call(Integer t1, T t2) {
                return t1 + 1;
            }
        });
    }

    public final <U> Observable<T> debounce(Func1<? super T, ? extends Observable<U>> debounceSelector) {
        return Observable.create(OperationDebounce.debounceSelector(this, debounceSelector));
    }

    public final Observable<T> debounce(long timeout, TimeUnit unit) {
        return Observable.create(OperationDebounce.debounce(this, timeout, unit));
    }

    public final Observable<T> debounce(long timeout, TimeUnit unit, Scheduler scheduler) {
        return Observable.create(OperationDebounce.debounce(this, timeout, unit, scheduler));
    }

    public final Observable<T> defaultIfEmpty(T defaultValue) {
        return Observable.create(OperationDefaultIfEmpty.defaultIfEmpty(this, defaultValue));
    }

    public final <U, V> Observable<T> delay(Func0<? extends Observable<U>> subscriptionDelay, Func1<? super T, ? extends Observable<V>> itemDelay) {
        return Observable.create(OperationDelay.delay(this, subscriptionDelay, itemDelay));
    }

    public final <U> Observable<T> delay(Func1<? super T, ? extends Observable<U>> itemDelay) {
        return Observable.create(OperationDelay.delay(this, itemDelay));
    }

    public final Observable<T> delay(long delay, TimeUnit unit) {
        return OperationDelay.delay(this, delay, unit, Schedulers.computation());
    }

    public final Observable<T> delay(long delay, TimeUnit unit, Scheduler scheduler) {
        return OperationDelay.delay(this, delay, unit, scheduler);
    }

    public final Observable<T> delaySubscription(long delay, TimeUnit unit) {
        return this.delaySubscription(delay, unit, Schedulers.computation());
    }

    public final Observable<T> delaySubscription(long delay, TimeUnit unit, Scheduler scheduler) {
        return Observable.create(OperationDelay.delaySubscription(this, delay, unit, scheduler));
    }

    public final <T2> Observable<T2> dematerialize() {
        return Observable.create(OperationDematerialize.dematerialize(this));
    }

    public final Observable<T> distinct() {
        return Observable.create(OperationDistinct.distinct(this));
    }

    public final <U> Observable<T> distinct(Func1<? super T, ? extends U> keySelector) {
        return Observable.create(OperationDistinct.distinct(this, keySelector));
    }

    public final Observable<T> distinctUntilChanged() {
        return Observable.create(OperationDistinctUntilChanged.distinctUntilChanged(this));
    }

    public final <U> Observable<T> distinctUntilChanged(Func1<? super T, ? extends U> keySelector) {
        return Observable.create(OperationDistinctUntilChanged.distinctUntilChanged(this, keySelector));
    }

    public final Observable<T> doOnCompleted(final Action0 onCompleted) {
        Observer observer = new Observer<T>(){

            @Override
            public final void onCompleted() {
                onCompleted.call();
            }

            @Override
            public final void onError(Throwable e) {
            }

            @Override
            public final void onNext(T args) {
            }
        };
        return this.lift(new OperatorDoOnEach(observer));
    }

    public final Observable<T> doOnEach(final Action1<Notification<? super T>> onNotification) {
        Observer observer = new Observer<T>(){

            @Override
            public final void onCompleted() {
                onNotification.call(Notification.createOnCompleted());
            }

            @Override
            public final void onError(Throwable e) {
                onNotification.call(Notification.createOnError(e));
            }

            @Override
            public final void onNext(T v) {
                onNotification.call(Notification.createOnNext(v));
            }
        };
        return this.lift(new OperatorDoOnEach(observer));
    }

    public final Observable<T> doOnEach(Observer<? super T> observer) {
        return this.lift(new OperatorDoOnEach<T>(observer));
    }

    public final Observable<T> doOnError(final Action1<Throwable> onError) {
        Observer observer = new Observer<T>(){

            @Override
            public final void onCompleted() {
            }

            @Override
            public final void onError(Throwable e) {
                onError.call(e);
            }

            @Override
            public final void onNext(T args) {
            }
        };
        return this.lift(new OperatorDoOnEach(observer));
    }

    public final Observable<T> doOnNext(final Action1<? super T> onNext) {
        Observer observer = new Observer<T>(){

            @Override
            public final void onCompleted() {
            }

            @Override
            public final void onError(Throwable e) {
            }

            @Override
            public final void onNext(T args) {
                onNext.call(args);
            }
        };
        return this.lift(new OperatorDoOnEach(observer));
    }

    public final Observable<T> doOnTerminate(final Action0 onTerminate) {
        Observer observer = new Observer<T>(){

            @Override
            public final void onCompleted() {
                onTerminate.call();
            }

            @Override
            public final void onError(Throwable e) {
                onTerminate.call();
            }

            @Override
            public final void onNext(T args) {
            }
        };
        return this.lift(new OperatorDoOnEach(observer));
    }

    public final Observable<T> elementAt(int index) {
        return this.lift(new OperatorElementAt(index));
    }

    public final Observable<T> elementAtOrDefault(int index, T defaultValue) {
        return this.lift(new OperatorElementAt<T>(index, defaultValue));
    }

    public final Observable<Boolean> exists(Func1<? super T, Boolean> predicate) {
        return Observable.create(OperationAny.exists(this, predicate));
    }

    public final Observable<T> filter(Func1<? super T, Boolean> predicate) {
        return this.lift(new OperatorFilter<T>(predicate));
    }

    public final Observable<T> finallyDo(Action0 action) {
        return Observable.create(OperationFinally.finallyDo(this, action));
    }

    public final Observable<T> first() {
        return this.take(1).single();
    }

    public final Observable<T> first(Func1<? super T, Boolean> predicate) {
        return this.takeFirst(predicate).single();
    }

    public final Observable<T> firstOrDefault(T defaultValue) {
        return this.take(1).singleOrDefault(defaultValue);
    }

    public final Observable<T> firstOrDefault(T defaultValue, Func1<? super T, Boolean> predicate) {
        return this.takeFirst(predicate).singleOrDefault(defaultValue);
    }

    public final <R> Observable<R> flatMap(Func1<? super T, ? extends Observable<? extends R>> func) {
        return this.mergeMap(func);
    }

    public final <K> Observable<GroupedObservable<K, T>> groupBy(Func1<? super T, ? extends K> keySelector) {
        return this.lift(new OperatorGroupBy<K, T>(keySelector));
    }

    public final <TKey, TDuration> Observable<GroupedObservable<TKey, T>> groupByUntil(Func1<? super T, ? extends TKey> keySelector, Func1<? super GroupedObservable<TKey, T>, ? extends Observable<? extends TDuration>> durationSelector) {
        return this.groupByUntil(keySelector, Functions.identity(), durationSelector);
    }

    public final <TKey, TValue, TDuration> Observable<GroupedObservable<TKey, TValue>> groupByUntil(Func1<? super T, ? extends TKey> keySelector, Func1<? super T, ? extends TValue> valueSelector, Func1<? super GroupedObservable<TKey, TValue>, ? extends Observable<? extends TDuration>> durationSelector) {
        return Observable.create(new OperationGroupByUntil(this, keySelector, valueSelector, durationSelector));
    }

    public final <T2, D1, D2, R> Observable<R> groupJoin(Observable<T2> right, Func1<? super T, ? extends Observable<D1>> leftDuration, Func1<? super T2, ? extends Observable<D2>> rightDuration, Func2<? super T, ? super Observable<T2>, ? extends R> resultSelector) {
        return Observable.create(new OperationGroupJoin(this, right, leftDuration, rightDuration, resultSelector));
    }

    public final Observable<T> ignoreElements() {
        return this.filter(Functions.alwaysFalse());
    }

    public final Observable<Boolean> isEmpty() {
        return Observable.create(OperationAny.isEmpty(this));
    }

    public final <TRight, TLeftDuration, TRightDuration, R> Observable<R> join(Observable<TRight> right, Func1<T, Observable<TLeftDuration>> leftDurationSelector, Func1<TRight, Observable<TRightDuration>> rightDurationSelector, Func2<T, TRight, R> resultSelector) {
        return Observable.create(new OperationJoin<T, TRight, TLeftDuration, TRightDuration, R>(this, right, leftDurationSelector, rightDurationSelector, resultSelector));
    }

    public final Observable<T> last() {
        return this.takeLast(1).single();
    }

    public final Observable<T> last(Func1<? super T, Boolean> predicate) {
        return this.filter(predicate).takeLast(1).single();
    }

    public final Observable<T> lastOrDefault(T defaultValue) {
        return this.takeLast(1).singleOrDefault(defaultValue);
    }

    public final Observable<T> lastOrDefault(T defaultValue, Func1<? super T, Boolean> predicate) {
        return this.filter(predicate).takeLast(1).singleOrDefault(defaultValue);
    }

    public final Observable<Long> longCount() {
        return this.reduce(0L, new Func2<Long, T, Long>(){

            @Override
            public final Long call(Long t1, T t2) {
                return t1 + 1L;
            }
        });
    }

    public final <R> Observable<R> map(Func1<? super T, ? extends R> func) {
        return this.lift(new OperatorMap<T, R>(func));
    }

    @Deprecated
    public final <R> Observable<R> mapMany(Func1<? super T, ? extends Observable<R>> func) {
        return this.mergeMap(func);
    }

    public final Observable<Notification<T>> materialize() {
        return this.lift(new OperatorMaterialize());
    }

    public final Observable<T> max(Comparator<? super T> comparator) {
        return OperationMinMax.max(this, comparator);
    }

    public final <R extends Comparable<? super R>> Observable<List<T>> maxBy(Func1<T, R> selector) {
        return OperationMinMax.maxBy(this, selector);
    }

    public final <R> Observable<List<T>> maxBy(Func1<T, R> selector, Comparator<? super R> comparator) {
        return OperationMinMax.maxBy(this, selector, comparator);
    }

    public final <R> Observable<R> mergeMap(Func1<? super T, ? extends Observable<? extends R>> func) {
        return Observable.merge(this.map(func));
    }

    public final <R> Observable<R> mergeMap(Func1<? super T, ? extends Observable<? extends R>> onNext, Func1<? super Throwable, ? extends Observable<? extends R>> onError, Func0<? extends Observable<? extends R>> onCompleted) {
        return Observable.create(OperationFlatMap.flatMap(this, onNext, onError, onCompleted));
    }

    public final <U, R> Observable<R> mergeMap(Func1<? super T, ? extends Observable<? extends U>> collectionSelector, Func2<? super T, ? super U, ? extends R> resultSelector) {
        return Observable.create(OperationFlatMap.flatMap(this, collectionSelector, resultSelector));
    }

    public final <R> Observable<R> mergeMapIterable(Func1<? super T, ? extends Iterable<? extends R>> collectionSelector) {
        return Observable.merge(this.map(OperationFlatMap.flatMapIterableFunc(collectionSelector)));
    }

    public final <U, R> Observable<R> mergeMapIterable(Func1<? super T, ? extends Iterable<? extends U>> collectionSelector, Func2<? super T, ? super U, ? extends R> resultSelector) {
        return this.mergeMap(OperationFlatMap.flatMapIterableFunc(collectionSelector), resultSelector);
    }

    public final Observable<T> min(Comparator<? super T> comparator) {
        return OperationMinMax.min(this, comparator);
    }

    public final <R extends Comparable<? super R>> Observable<List<T>> minBy(Func1<T, R> selector) {
        return OperationMinMax.minBy(this, selector);
    }

    public final <R> Observable<List<T>> minBy(Func1<T, R> selector, Comparator<? super R> comparator) {
        return OperationMinMax.minBy(this, selector, comparator);
    }

    public final <TIntermediate, TResult> Observable<TResult> multicast(Func0<? extends Subject<? super T, ? extends TIntermediate>> subjectFactory, Func1<? super Observable<TIntermediate>, ? extends Observable<TResult>> selector) {
        return OperationMulticast.multicast(this, subjectFactory, selector);
    }

    public final <R> ConnectableObservable<R> multicast(Subject<? super T, ? extends R> subject) {
        return OperationMulticast.multicast(this, subject);
    }

    public final Observable<T> observeOn(Scheduler scheduler) {
        return this.lift(new OperatorObserveOn(scheduler));
    }

    public final <R> Observable<R> ofType(final Class<R> klass) {
        return this.filter(new Func1<T, Boolean>(){

            @Override
            public final Boolean call(T t) {
                return klass.isInstance(t);
            }
        }).cast(klass);
    }

    public final Observable<T> onErrorResumeNext(Func1<Throwable, ? extends Observable<? extends T>> resumeFunction) {
        return this.lift(new OperatorOnErrorResumeNextViaFunction(resumeFunction));
    }

    public final Observable<T> onErrorResumeNext(Observable<? extends T> resumeSequence) {
        return Observable.create(OperationOnErrorResumeNextViaObservable.onErrorResumeNextViaObservable(this, resumeSequence));
    }

    public final Observable<T> onErrorReturn(Func1<Throwable, ? extends T> resumeFunction) {
        return Observable.create(OperationOnErrorReturn.onErrorReturn(this, resumeFunction));
    }

    public final Observable<T> onErrorFlatMap(Func1<OnErrorThrowable, ? extends Observable<? extends T>> resumeFunction) {
        return this.lift(new OperatorOnErrorFlatMap(resumeFunction));
    }

    public final Observable<T> onExceptionResumeNext(Observable<? extends T> resumeSequence) {
        return Observable.create(OperationOnExceptionResumeNextViaObservable.onExceptionResumeNextViaObservable(this, resumeSequence));
    }

    public final <R> Observable<R> parallel(Func1<Observable<T>, Observable<R>> f) {
        return this.lift(new OperatorParallel<T, R>(f, Schedulers.newThread()));
    }

    public final <R> Observable<R> parallel(Func1<Observable<T>, Observable<R>> f, Scheduler s) {
        return this.lift(new OperatorParallel<T, R>(f, s));
    }

    public final ConnectableObservable<T> publish() {
        return OperationMulticast.multicast(this, PublishSubject.create());
    }

    public final <R> Observable<R> publish(Func1<? super Observable<T>, ? extends Observable<R>> selector) {
        return this.multicast(new Func0<Subject<T, T>>(){

            @Override
            public final Subject<T, T> call() {
                return PublishSubject.create();
            }
        }, selector);
    }

    public final <R> Observable<R> publish(Func1<? super Observable<T>, ? extends Observable<R>> selector, final T initialValue) {
        return this.multicast(new Func0<Subject<T, T>>(){

            @Override
            public final Subject<T, T> call() {
                return BehaviorSubject.create(initialValue);
            }
        }, selector);
    }

    public final ConnectableObservable<T> publish(T initialValue) {
        return OperationMulticast.multicast(this, BehaviorSubject.create(initialValue));
    }

    public final ConnectableObservable<T> publishLast() {
        return OperationMulticast.multicast(this, AsyncSubject.create());
    }

    public final <R> Observable<R> publishLast(Func1<? super Observable<T>, ? extends Observable<R>> selector) {
        return this.multicast(new Func0<Subject<T, T>>(){

            @Override
            public final Subject<T, T> call() {
                return AsyncSubject.create();
            }
        }, selector);
    }

    public final Observable<T> reduce(Func2<T, T, T> accumulator) {
        return this.scan(accumulator).last();
    }

    public final <R> Observable<R> reduce(R initialValue, Func2<R, ? super T, R> accumulator) {
        return this.scan(initialValue, accumulator).takeLast(1);
    }

    public final Observable<T> repeat() {
        return this.nest().lift(new OperatorRepeat());
    }

    public final Observable<T> repeat(Scheduler scheduler) {
        return this.nest().lift(new OperatorRepeat(scheduler));
    }

    public final Observable<T> repeat(long count) {
        if (count < 0L) {
            throw new IllegalArgumentException("count >= 0 expected");
        }
        return this.nest().lift(new OperatorRepeat(count));
    }

    public final Observable<T> repeat(long count, Scheduler scheduler) {
        return this.nest().lift(new OperatorRepeat(count, scheduler));
    }

    public final ConnectableObservable<T> replay() {
        return OperationMulticast.multicast(this, ReplaySubject.create());
    }

    public final <R> Observable<R> replay(Func1<? super Observable<T>, ? extends Observable<R>> selector) {
        return OperationMulticast.multicast(this, new Func0<Subject<T, T>>(){

            @Override
            public final Subject<T, T> call() {
                return ReplaySubject.create();
            }
        }, selector);
    }

    public final <R> Observable<R> replay(Func1<? super Observable<T>, ? extends Observable<R>> selector, final int bufferSize) {
        return OperationMulticast.multicast(this, new Func0<Subject<T, T>>(){

            @Override
            public final Subject<T, T> call() {
                return OperationReplay.replayBuffered(bufferSize);
            }
        }, selector);
    }

    public final <R> Observable<R> replay(Func1<? super Observable<T>, ? extends Observable<R>> selector, int bufferSize, long time, TimeUnit unit) {
        return this.replay(selector, bufferSize, time, unit, Schedulers.computation());
    }

    public final <R> Observable<R> replay(Func1<? super Observable<T>, ? extends Observable<R>> selector, final int bufferSize, final long time, final TimeUnit unit, final Scheduler scheduler) {
        if (bufferSize < 0) {
            throw new IllegalArgumentException("bufferSize < 0");
        }
        return OperationMulticast.multicast(this, new Func0<Subject<T, T>>(){

            @Override
            public final Subject<T, T> call() {
                return OperationReplay.replayWindowed(time, unit, bufferSize, scheduler);
            }
        }, selector);
    }

    public final <R> Observable<R> replay(Func1<? super Observable<T>, ? extends Observable<R>> selector, final int bufferSize, final Scheduler scheduler) {
        return OperationMulticast.multicast(this, new Func0<Subject<T, T>>(){

            @Override
            public final Subject<T, T> call() {
                return OperationReplay.createScheduledSubject(OperationReplay.replayBuffered(bufferSize), scheduler);
            }
        }, selector);
    }

    public final <R> Observable<R> replay(Func1<? super Observable<T>, ? extends Observable<R>> selector, long time, TimeUnit unit) {
        return this.replay(selector, time, unit, Schedulers.computation());
    }

    public final <R> Observable<R> replay(Func1<? super Observable<T>, ? extends Observable<R>> selector, final long time, final TimeUnit unit, final Scheduler scheduler) {
        return OperationMulticast.multicast(this, new Func0<Subject<T, T>>(){

            @Override
            public final Subject<T, T> call() {
                return OperationReplay.replayWindowed(time, unit, -1, scheduler);
            }
        }, selector);
    }

    public final <R> Observable<R> replay(Func1<? super Observable<T>, ? extends Observable<R>> selector, final Scheduler scheduler) {
        return OperationMulticast.multicast(this, new Func0<Subject<T, T>>(){

            @Override
            public final Subject<T, T> call() {
                return OperationReplay.createScheduledSubject(ReplaySubject.create(), scheduler);
            }
        }, selector);
    }

    public final ConnectableObservable<T> replay(int bufferSize) {
        return OperationMulticast.multicast(this, OperationReplay.replayBuffered(bufferSize));
    }

    public final ConnectableObservable<T> replay(int bufferSize, long time, TimeUnit unit) {
        return this.replay(bufferSize, time, unit, Schedulers.computation());
    }

    public final ConnectableObservable<T> replay(int bufferSize, long time, TimeUnit unit, Scheduler scheduler) {
        if (bufferSize < 0) {
            throw new IllegalArgumentException("bufferSize < 0");
        }
        return OperationMulticast.multicast(this, OperationReplay.replayWindowed(time, unit, bufferSize, scheduler));
    }

    public final ConnectableObservable<T> replay(int bufferSize, Scheduler scheduler) {
        return OperationMulticast.multicast(this, OperationReplay.createScheduledSubject(OperationReplay.replayBuffered(bufferSize), scheduler));
    }

    public final ConnectableObservable<T> replay(long time, TimeUnit unit) {
        return this.replay(time, unit, Schedulers.computation());
    }

    public final ConnectableObservable<T> replay(long time, TimeUnit unit, Scheduler scheduler) {
        return OperationMulticast.multicast(this, OperationReplay.replayWindowed(time, unit, -1, scheduler));
    }

    public final ConnectableObservable<T> replay(Scheduler scheduler) {
        return OperationMulticast.multicast(this, OperationReplay.createScheduledSubject(ReplaySubject.create(), scheduler));
    }

    public final Observable<T> retry() {
        return this.nest().lift(new OperatorRetry());
    }

    public final Observable<T> retry(int retryCount) {
        return this.nest().lift(new OperatorRetry(retryCount));
    }

    public final Observable<T> sample(long period, TimeUnit unit) {
        return Observable.create(OperationSample.sample(this, period, unit));
    }

    public final Observable<T> sample(long period, TimeUnit unit, Scheduler scheduler) {
        return Observable.create(OperationSample.sample(this, period, unit, scheduler));
    }

    public final <U> Observable<T> sample(Observable<U> sampler) {
        return Observable.create(new OperationSample.SampleWithObservable(this, sampler));
    }

    public final Observable<T> scan(Func2<T, T, T> accumulator) {
        return this.lift(new OperatorScan<T, T>(accumulator));
    }

    public final <R> Observable<R> scan(R initialValue, Func2<R, ? super T, R> accumulator) {
        return this.lift(new OperatorScan<R, T>(initialValue, accumulator));
    }

    public final Observable<T> serialize() {
        return this.lift(new OperatorSerialize());
    }

    public final Observable<T> single() {
        return Observable.create(OperationSingle.single(this));
    }

    public final Observable<T> single(Func1<? super T, Boolean> predicate) {
        return this.filter(predicate).single();
    }

    public final Observable<T> singleOrDefault(T defaultValue) {
        return Observable.create(OperationSingle.singleOrDefault(this, defaultValue));
    }

    public final Observable<T> singleOrDefault(T defaultValue, Func1<? super T, Boolean> predicate) {
        return this.filter(predicate).singleOrDefault(defaultValue);
    }

    public final Observable<T> skip(int num) {
        return this.lift(new OperatorSkip(num));
    }

    public final Observable<T> skip(long time, TimeUnit unit) {
        return this.skip(time, unit, Schedulers.computation());
    }

    public final Observable<T> skip(long time, TimeUnit unit, Scheduler scheduler) {
        return Observable.create(new OperationSkip.SkipTimed(this, time, unit, scheduler));
    }

    public final Observable<T> skipLast(int count) {
        return Observable.create(OperationSkipLast.skipLast(this, count));
    }

    public final Observable<T> skipLast(long time, TimeUnit unit) {
        return this.skipLast(time, unit, Schedulers.computation());
    }

    public final Observable<T> skipLast(long time, TimeUnit unit, Scheduler scheduler) {
        return Observable.create(new OperationSkipLast.SkipLastTimed(this, time, unit, scheduler));
    }

    public final <U> Observable<T> skipUntil(Observable<U> other) {
        return Observable.create(new OperationSkipUntil(this, other));
    }

    public final Observable<T> skipWhile(Func1<? super T, Boolean> predicate) {
        return this.lift(new OperatorSkipWhile<T>(OperatorSkipWhile.toPredicate2(predicate)));
    }

    public final Observable<T> skipWhileWithIndex(Func2<? super T, Integer, Boolean> predicate) {
        return this.lift(new OperatorSkipWhile<T>(predicate));
    }

    public final Observable<T> startWith(Observable<T> values) {
        return Observable.concat(values, this);
    }

    public final Observable<T> startWith(Iterable<T> values) {
        return Observable.concat(Observable.from(values), this);
    }

    public final Observable<T> startWith(Iterable<T> values, Scheduler scheduler) {
        return Observable.concat(Observable.from(values, scheduler), this);
    }

    public final Observable<T> startWith(T t1) {
        return Observable.concat(Observable.from(t1), this);
    }

    public final Observable<T> startWith(T t1, T t2) {
        return Observable.concat(Observable.from(t1, t2), this);
    }

    public final Observable<T> startWith(T t1, T t2, T t3) {
        return Observable.concat(Observable.from(t1, t2, t3), this);
    }

    public final Observable<T> startWith(T t1, T t2, T t3, T t4) {
        return Observable.concat(Observable.from(t1, t2, t3, t4), this);
    }

    public final Observable<T> startWith(T t1, T t2, T t3, T t4, T t5) {
        return Observable.concat(Observable.from(t1, t2, t3, t4, t5), this);
    }

    public final Observable<T> startWith(T t1, T t2, T t3, T t4, T t5, T t6) {
        return Observable.concat(Observable.from(t1, t2, t3, t4, t5, t6), this);
    }

    public final Observable<T> startWith(T t1, T t2, T t3, T t4, T t5, T t6, T t7) {
        return Observable.concat(Observable.from(t1, t2, t3, t4, t5, t6, t7), this);
    }

    public final Observable<T> startWith(T t1, T t2, T t3, T t4, T t5, T t6, T t7, T t8) {
        return Observable.concat(Observable.from(t1, t2, t3, t4, t5, t6, t7, t8), this);
    }

    public final Observable<T> startWith(T t1, T t2, T t3, T t4, T t5, T t6, T t7, T t8, T t9) {
        return Observable.concat(Observable.from(t1, t2, t3, t4, t5, t6, t7, t8, t9), this);
    }

    public final Observable<T> startWith(T[] values, Scheduler scheduler) {
        return this.startWith((T)Arrays.asList(values), (T)scheduler);
    }

    public final Subscription subscribe() {
        return this.subscribe(new Subscriber<T>(){

            @Override
            public final void onCompleted() {
            }

            @Override
            public final void onError(Throwable e) {
                throw new OnErrorNotImplementedException(e);
            }

            @Override
            public final void onNext(T args) {
            }
        });
    }

    public final Subscription subscribe(final Action1<? super T> onNext) {
        if (onNext == null) {
            throw new IllegalArgumentException("onNext can not be null");
        }
        return this.subscribe(new Subscriber<T>(){

            @Override
            public final void onCompleted() {
            }

            @Override
            public final void onError(Throwable e) {
                throw new OnErrorNotImplementedException(e);
            }

            @Override
            public final void onNext(T args) {
                onNext.call(args);
            }
        });
    }

    public final Subscription subscribe(final Action1<? super T> onNext, final Action1<Throwable> onError) {
        if (onNext == null) {
            throw new IllegalArgumentException("onNext can not be null");
        }
        if (onError == null) {
            throw new IllegalArgumentException("onError can not be null");
        }
        return this.subscribe(new Subscriber<T>(){

            @Override
            public final void onCompleted() {
            }

            @Override
            public final void onError(Throwable e) {
                onError.call(e);
            }

            @Override
            public final void onNext(T args) {
                onNext.call(args);
            }
        });
    }

    public final Subscription subscribe(final Action1<? super T> onNext, final Action1<Throwable> onError, final Action0 onComplete) {
        if (onNext == null) {
            throw new IllegalArgumentException("onNext can not be null");
        }
        if (onError == null) {
            throw new IllegalArgumentException("onError can not be null");
        }
        if (onComplete == null) {
            throw new IllegalArgumentException("onComplete can not be null");
        }
        return this.subscribe(new Subscriber<T>(){

            @Override
            public final void onCompleted() {
                onComplete.call();
            }

            @Override
            public final void onError(Throwable e) {
                onError.call(e);
            }

            @Override
            public final void onNext(T args) {
                onNext.call(args);
            }
        });
    }

    public final Subscription subscribe(Action1<? super T> onNext, Action1<Throwable> onError, Action0 onComplete, Scheduler scheduler) {
        return this.subscribeOn(scheduler).subscribe(onNext, onError, onComplete);
    }

    public final Subscription subscribe(Action1<? super T> onNext, Action1<Throwable> onError, Scheduler scheduler) {
        return this.subscribeOn(scheduler).subscribe(onNext, onError);
    }

    public final Subscription subscribe(Action1<? super T> onNext, Scheduler scheduler) {
        return this.subscribeOn(scheduler).subscribe(onNext);
    }

    public final Subscription subscribe(Observer<? super T> observer, Scheduler scheduler) {
        return this.subscribeOn(scheduler).subscribe(observer);
    }

    public final Subscription subscribe(final Observer<? super T> observer) {
        return this.subscribe(new Subscriber<T>(){

            @Override
            public void onCompleted() {
                observer.onCompleted();
            }

            @Override
            public void onError(Throwable e) {
                observer.onError(e);
            }

            @Override
            public void onNext(T t) {
                observer.onNext(t);
            }
        });
    }

    public final Subscription unsafeSubscribe(Subscriber<? super T> subscriber) {
        this.onSubscribe.call(subscriber);
        return subscriber;
    }

    public final Subscription subscribe(Subscriber<? super T> subscriber) {
        OnSubscribe<T> onSubscribeFunction = this.hook.onSubscribeStart(this, this.onSubscribe);
        if (subscriber == null) {
            throw new IllegalArgumentException("observer can not be null");
        }
        if (onSubscribeFunction == null) {
            throw new IllegalStateException("onSubscribe function can not be null.");
        }
        try {
            if (!(subscriber instanceof SafeSubscriber)) {
                subscriber = new SafeSubscriber<T>(subscriber);
            }
            onSubscribeFunction.call(subscriber);
            final Subscription returnSubscription = this.hook.onSubscribeReturn(subscriber);
            return Subscriptions.create(new Action0(){

                @Override
                public void call() {
                    returnSubscription.unsubscribe();
                }
            });
        }
        catch (Throwable e) {
            Exceptions.throwIfFatal(e);
            try {
                subscriber.onError(this.hook.onSubscribeError(e));
            }
            catch (OnErrorNotImplementedException e2) {
                throw e2;
            }
            catch (Throwable e2) {
                RuntimeException r = new RuntimeException("Error occurred attempting to subscribe [" + e.getMessage() + "] and then again while trying to pass to onError.", e2);
                this.hook.onSubscribeError(r);
                throw r;
            }
            return Subscriptions.empty();
        }
    }

    public final Subscription subscribe(Subscriber<? super T> observer, Scheduler scheduler) {
        return this.subscribeOn(scheduler).subscribe(observer);
    }

    public final Observable<T> subscribeOn(Scheduler scheduler) {
        return this.nest().lift(new OperatorSubscribeOn(scheduler));
    }

    public final Observable<Double> sumDouble(Func1<? super T, Double> valueExtractor) {
        return OperationSum.sumAtLeastOneDoubles(this.map(valueExtractor));
    }

    public final Observable<Float> sumFloat(Func1<? super T, Float> valueExtractor) {
        return OperationSum.sumAtLeastOneFloats(this.map(valueExtractor));
    }

    public final Observable<Integer> sumInteger(Func1<? super T, Integer> valueExtractor) {
        return OperationSum.sumAtLeastOneIntegers(this.map(valueExtractor));
    }

    public final Observable<Long> sumLong(Func1<? super T, Long> valueExtractor) {
        return OperationSum.sumAtLeastOneLongs(this.map(valueExtractor));
    }

    public final <R> Observable<R> switchMap(Func1<? super T, ? extends Observable<? extends R>> func) {
        return Observable.switchOnNext(this.map(func));
    }

    public final Observable<T> synchronize() {
        return this.lift(new OperatorSynchronize());
    }

    public final Observable<T> synchronize(Object lock) {
        return this.lift(new OperatorSynchronize(lock));
    }

    public final Observable<T> take(int num) {
        return this.lift(new OperatorTake(num));
    }

    public final Observable<T> take(long time, TimeUnit unit) {
        return this.take(time, unit, Schedulers.computation());
    }

    public final Observable<T> take(long time, TimeUnit unit, Scheduler scheduler) {
        return Observable.create(new OperationTakeTimed.TakeTimed(this, time, unit, scheduler));
    }

    @Deprecated
    public final Observable<T> takeFirst() {
        return this.take(1);
    }

    public final Observable<T> takeFirst(Func1<? super T, Boolean> predicate) {
        return this.filter(predicate).take(1);
    }

    public final Observable<T> takeLast(int count) {
        return Observable.create(OperationTakeLast.takeLast(this, count));
    }

    public final Observable<T> takeLast(int count, long time, TimeUnit unit) {
        return this.takeLast(count, time, unit, Schedulers.computation());
    }

    public final Observable<T> takeLast(int count, long time, TimeUnit unit, Scheduler scheduler) {
        if (count < 0) {
            throw new IllegalArgumentException("count >= 0 required");
        }
        return Observable.create(OperationTakeLast.takeLast(this, count, time, unit, scheduler));
    }

    public final Observable<T> takeLast(long time, TimeUnit unit) {
        return this.takeLast(time, unit, Schedulers.computation());
    }

    public final Observable<T> takeLast(long time, TimeUnit unit, Scheduler scheduler) {
        return Observable.create(OperationTakeLast.takeLast(this, time, unit, scheduler));
    }

    public final Observable<List<T>> takeLastBuffer(int count) {
        return this.takeLast(count).toList();
    }

    public final Observable<List<T>> takeLastBuffer(int count, long time, TimeUnit unit) {
        return this.takeLast(count, time, unit).toList();
    }

    public final Observable<List<T>> takeLastBuffer(int count, long time, TimeUnit unit, Scheduler scheduler) {
        return this.takeLast(count, time, unit, scheduler).toList();
    }

    public final Observable<List<T>> takeLastBuffer(long time, TimeUnit unit) {
        return this.takeLast(time, unit).toList();
    }

    public final Observable<List<T>> takeLastBuffer(long time, TimeUnit unit, Scheduler scheduler) {
        return this.takeLast(time, unit, scheduler).toList();
    }

    public final <E> Observable<T> takeUntil(Observable<? extends E> other) {
        return OperationTakeUntil.takeUntil(this, other);
    }

    public final Observable<T> takeWhile(Func1<? super T, Boolean> predicate) {
        return Observable.create(OperationTakeWhile.takeWhile(this, predicate));
    }

    public final Observable<T> takeWhileWithIndex(Func2<? super T, ? super Integer, Boolean> predicate) {
        return Observable.create(OperationTakeWhile.takeWhileWithIndex(this, predicate));
    }

    public final <R> Plan0<R> then(Func1<T, R> selector) {
        return OperationJoinPatterns.then(this, selector);
    }

    public final Observable<T> throttleFirst(long windowDuration, TimeUnit unit) {
        return Observable.create(OperationThrottleFirst.throttleFirst(this, windowDuration, unit));
    }

    public final Observable<T> throttleFirst(long skipDuration, TimeUnit unit, Scheduler scheduler) {
        return Observable.create(OperationThrottleFirst.throttleFirst(this, skipDuration, unit, scheduler));
    }

    public final Observable<T> throttleLast(long intervalDuration, TimeUnit unit) {
        return this.sample(intervalDuration, unit);
    }

    public final Observable<T> throttleLast(long intervalDuration, TimeUnit unit, Scheduler scheduler) {
        return this.sample(intervalDuration, unit, scheduler);
    }

    public final Observable<T> throttleWithTimeout(long timeout, TimeUnit unit) {
        return Observable.create(OperationDebounce.debounce(this, timeout, unit));
    }

    public final Observable<T> throttleWithTimeout(long timeout, TimeUnit unit, Scheduler scheduler) {
        return Observable.create(OperationDebounce.debounce(this, timeout, unit, scheduler));
    }

    public final Observable<TimeInterval<T>> timeInterval() {
        return Observable.create(OperationTimeInterval.timeInterval(this));
    }

    public final Observable<TimeInterval<T>> timeInterval(Scheduler scheduler) {
        return Observable.create(OperationTimeInterval.timeInterval(this, scheduler));
    }

    public final <U, V> Observable<T> timeout(Func0<? extends Observable<U>> firstTimeoutSelector, Func1<? super T, ? extends Observable<V>> timeoutSelector) {
        return this.timeout(firstTimeoutSelector, timeoutSelector, null);
    }

    public final <U, V> Observable<T> timeout(Func0<? extends Observable<U>> firstTimeoutSelector, Func1<? super T, ? extends Observable<V>> timeoutSelector, Observable<? extends T> other) {
        if (timeoutSelector == null) {
            throw new NullPointerException("timeoutSelector is null");
        }
        return this.lift(new OperatorTimeoutWithSelector(firstTimeoutSelector, timeoutSelector, other));
    }

    public final <V> Observable<T> timeout(Func1<? super T, ? extends Observable<V>> timeoutSelector) {
        return this.timeout(null, timeoutSelector, null);
    }

    public final <V> Observable<T> timeout(Func1<? super T, ? extends Observable<V>> timeoutSelector, Observable<? extends T> other) {
        return this.timeout(null, timeoutSelector, other);
    }

    public final Observable<T> timeout(long timeout, TimeUnit timeUnit) {
        return this.timeout(timeout, timeUnit, null, Schedulers.computation());
    }

    public final Observable<T> timeout(long timeout, TimeUnit timeUnit, Observable<? extends T> other) {
        return this.timeout(timeout, timeUnit, other, Schedulers.computation());
    }

    public final Observable<T> timeout(long timeout, TimeUnit timeUnit, Observable<? extends T> other, Scheduler scheduler) {
        return this.lift(new OperatorTimeout<T>(timeout, timeUnit, other, scheduler));
    }

    public final Observable<T> timeout(long timeout, TimeUnit timeUnit, Scheduler scheduler) {
        return this.timeout(timeout, timeUnit, null, scheduler);
    }

    public final Observable<Timestamped<T>> timestamp() {
        return this.timestamp(Schedulers.immediate());
    }

    public final Observable<Timestamped<T>> timestamp(Scheduler scheduler) {
        return this.lift(new OperatorTimestamp(scheduler));
    }

    public final BlockingObservable<T> toBlockingObservable() {
        return BlockingObservable.from(this);
    }

    public final Observable<List<T>> toList() {
        return this.lift(new OperatorToObservableList());
    }

    public final <K> Observable<Map<K, T>> toMap(Func1<? super T, ? extends K> keySelector) {
        return Observable.create(OperationToMap.toMap(this, keySelector));
    }

    public final <K, V> Observable<Map<K, V>> toMap(Func1<? super T, ? extends K> keySelector, Func1<? super T, ? extends V> valueSelector) {
        return Observable.create(OperationToMap.toMap(this, keySelector, valueSelector));
    }

    public final <K, V> Observable<Map<K, V>> toMap(Func1<? super T, ? extends K> keySelector, Func1<? super T, ? extends V> valueSelector, Func0<? extends Map<K, V>> mapFactory) {
        return Observable.create(OperationToMap.toMap(this, keySelector, valueSelector, mapFactory));
    }

    public final <K> Observable<Map<K, Collection<T>>> toMultimap(Func1<? super T, ? extends K> keySelector) {
        return Observable.create(OperationToMultimap.toMultimap(this, keySelector));
    }

    public final <K, V> Observable<Map<K, Collection<V>>> toMultimap(Func1<? super T, ? extends K> keySelector, Func1<? super T, ? extends V> valueSelector) {
        return Observable.create(OperationToMultimap.toMultimap(this, keySelector, valueSelector));
    }

    public final <K, V> Observable<Map<K, Collection<V>>> toMultimap(Func1<? super T, ? extends K> keySelector, Func1<? super T, ? extends V> valueSelector, Func0<? extends Map<K, Collection<V>>> mapFactory) {
        return Observable.create(OperationToMultimap.toMultimap(this, keySelector, valueSelector, mapFactory));
    }

    public final <K, V> Observable<Map<K, Collection<V>>> toMultimap(Func1<? super T, ? extends K> keySelector, Func1<? super T, ? extends V> valueSelector, Func0<? extends Map<K, Collection<V>>> mapFactory, Func1<? super K, ? extends Collection<V>> collectionFactory) {
        return Observable.create(OperationToMultimap.toMultimap(this, keySelector, valueSelector, mapFactory, collectionFactory));
    }

    public final Observable<List<T>> toSortedList() {
        return this.lift(new OperatorToObservableSortedList());
    }

    public final Observable<List<T>> toSortedList(Func2<? super T, ? super T, Integer> sortFunction) {
        return this.lift(new OperatorToObservableSortedList<T>(sortFunction));
    }

    public final Observable<T> unsubscribeOn(Scheduler scheduler) {
        return this.lift(new OperatorUnsubscribeOn(scheduler));
    }

    @Deprecated
    public final Observable<T> where(Func1<? super T, Boolean> predicate) {
        return this.filter(predicate);
    }

    public final <TClosing> Observable<Observable<T>> window(Func0<? extends Observable<? extends TClosing>> closingSelector) {
        return Observable.create(OperationWindow.window(this, closingSelector));
    }

    public final Observable<Observable<T>> window(int count) {
        return Observable.create(OperationWindow.window(this, count));
    }

    public final Observable<Observable<T>> window(int count, int skip) {
        return Observable.create(OperationWindow.window(this, count, skip));
    }

    public final Observable<Observable<T>> window(long timespan, long timeshift, TimeUnit unit) {
        return Observable.create(OperationWindow.window(this, timespan, timeshift, unit));
    }

    public final Observable<Observable<T>> window(long timespan, long timeshift, TimeUnit unit, Scheduler scheduler) {
        return Observable.create(OperationWindow.window(this, timespan, timeshift, unit, scheduler));
    }

    public final Observable<Observable<T>> window(long timespan, TimeUnit unit) {
        return Observable.create(OperationWindow.window(this, timespan, unit));
    }

    public final Observable<Observable<T>> window(long timespan, TimeUnit unit, int count) {
        return Observable.create(OperationWindow.window(this, timespan, unit, count));
    }

    public final Observable<Observable<T>> window(long timespan, TimeUnit unit, int count, Scheduler scheduler) {
        return Observable.create(OperationWindow.window(this, timespan, unit, count, scheduler));
    }

    public final Observable<Observable<T>> window(long timespan, TimeUnit unit, Scheduler scheduler) {
        return Observable.create(OperationWindow.window(this, timespan, unit, scheduler));
    }

    public final <TOpening, TClosing> Observable<Observable<T>> window(Observable<? extends TOpening> windowOpenings, Func1<? super TOpening, ? extends Observable<? extends TClosing>> closingSelector) {
        return Observable.create(OperationWindow.window(this, windowOpenings, closingSelector));
    }

    public final <U> Observable<Observable<T>> window(Observable<U> boundary) {
        return Observable.create(OperationWindow.window(this, boundary));
    }

    public final <T2, R> Observable<R> zip(Iterable<? extends T2> other, Func2<? super T, ? super T2, ? extends R> zipFunction) {
        return this.lift(new OperatorZipIterable<T, T2, R>(other, zipFunction));
    }

    public final <T2, R> Observable<R> zip(Observable<? extends T2> other, Func2<? super T, ? super T2, ? extends R> zipFunction) {
        return Observable.zip(this, other, zipFunction);
    }

    private static class ThrowObservable<T>
    extends Observable<T> {
        public ThrowObservable(final Throwable exception) {
            super(new OnSubscribe<T>(){

                @Override
                public void call(Subscriber<? super T> observer) {
                    observer.onError(exception);
                }
            });
        }
    }

    private static class NeverObservable<T>
    extends Observable<T> {
        public NeverObservable() {
            super(new OnSubscribe<T>(){

                @Override
                public void call(Subscriber<? super T> observer) {
                }
            });
        }
    }

    public static interface OnSubscribeFunc<T>
    extends Function {
        public Subscription onSubscribe(Observer<? super T> var1);
    }

    public static interface Operator<R, T>
    extends Func1<Subscriber<? super R>, Subscriber<? super T>> {
    }

    public static interface OnSubscribe<T>
    extends Action1<Subscriber<? super T>> {
    }
}

