/*
 * Decompiled with CFR 0.152.
 */
package rx;

import java.util.concurrent.TimeUnit;
import rx.Subscription;
import rx.functions.Action1;

public abstract class Scheduler {
    public abstract Subscription schedule(Action1<Inner> var1);

    public abstract Subscription schedule(Action1<Inner> var1, long var2, TimeUnit var4);

    public Subscription schedulePeriodically(final Action1<Inner> action, long initialDelay, long period, TimeUnit unit) {
        final long periodInNanos = unit.toNanos(period);
        Action1<Inner> recursiveAction = new Action1<Inner>(){

            @Override
            public void call(Inner inner) {
                if (!inner.isUnsubscribed()) {
                    long startedAt = Scheduler.this.now();
                    action.call(inner);
                    long timeTakenByActionInNanos = TimeUnit.MILLISECONDS.toNanos(Scheduler.this.now() - startedAt);
                    inner.schedule(this, periodInNanos - timeTakenByActionInNanos, TimeUnit.NANOSECONDS);
                }
            }
        };
        return this.schedule(recursiveAction, initialDelay, unit);
    }

    public final Subscription scheduleRecursive(final Action1<Recurse> action) {
        return this.schedule(new Action1<Inner>(){

            @Override
            public void call(Inner inner) {
                action.call(new Recurse(inner, action));
            }
        });
    }

    public int degreeOfParallelism() {
        return Runtime.getRuntime().availableProcessors();
    }

    public long now() {
        return System.currentTimeMillis();
    }

    public static abstract class Inner
    implements Subscription {
        public abstract void schedule(Action1<Inner> var1, long var2, TimeUnit var4);

        public abstract void schedule(Action1<Inner> var1);

        public long now() {
            return System.currentTimeMillis();
        }
    }

    public static final class Recurse {
        private final Action1<Recurse> action;
        private final Inner inner;

        private Recurse(Inner inner, Action1<Recurse> action) {
            this.inner = inner;
            this.action = action;
        }

        public final void schedule() {
            final Recurse self = this;
            this.inner.schedule(new Action1<Inner>(){

                @Override
                public void call(Inner _inner) {
                    Recurse.this.action.call(self);
                }
            });
        }

        public final void schedule(long delay, TimeUnit unit) {
            final Recurse self = this;
            this.inner.schedule(new Action1<Inner>(){

                @Override
                public void call(Inner _inner) {
                    Recurse.this.action.call(self);
                }
            }, delay, unit);
        }
    }
}

