/*
 * Decompiled with CFR 0.152.
 */
package rx.apache.http.consumers;

import java.io.IOException;
import java.io.InputStream;
import org.apache.http.nio.util.ExpandableBuffer;
import org.apache.http.nio.util.HeapByteBufferAllocator;

class ExpandableByteBuffer
extends ExpandableBuffer {
    public ExpandableByteBuffer(int size) {
        super(size, HeapByteBufferAllocator.INSTANCE);
    }

    public ExpandableByteBuffer() {
        super(4096, HeapByteBufferAllocator.INSTANCE);
    }

    public void addByte(byte b) {
        if (this.buffer.remaining() == 0) {
            this.expand();
        }
        this.buffer.put(b);
    }

    public boolean hasContent() {
        return this.buffer.position() > 0;
    }

    public byte[] getBytes() {
        byte[] data = new byte[this.buffer.position()];
        this.buffer.position(0);
        this.buffer.get(data);
        return data;
    }

    public void reset() {
        this.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void consumeInputStream(InputStream content) throws IOException {
        try {
            int b = -1;
            while ((b = content.read()) != -1) {
                this.addByte((byte)b);
            }
        }
        finally {
            content.close();
        }
    }
}

