/*
 * Decompiled with CFR 0.152.
 */
package rx.joins;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.atomic.AtomicBoolean;
import rx.Notification;
import rx.Observable;
import rx.Subscriber;
import rx.functions.Action1;
import rx.joins.ActivePlan0;
import rx.joins.JoinObserver;
import rx.observers.SafeSubscriber;

public final class JoinObserver1<T>
extends Subscriber<Notification<T>>
implements JoinObserver {
    private Object gate;
    private final Observable<T> source;
    private final Action1<Throwable> onError;
    private final List<ActivePlan0> activePlans;
    private final Queue<Notification<T>> queue;
    private final AtomicBoolean subscribed = new AtomicBoolean(false);
    private final SafeSubscriber<Notification<T>> safeObserver;

    public JoinObserver1(Observable<T> source, Action1<Throwable> onError) {
        this.source = source;
        this.onError = onError;
        this.queue = new LinkedList<Notification<T>>();
        this.activePlans = new ArrayList<ActivePlan0>();
        this.safeObserver = new SafeSubscriber(new InnerObserver());
        this.add(this.safeObserver);
    }

    public Queue<Notification<T>> queue() {
        return this.queue;
    }

    public void addActivePlan(ActivePlan0 activePlan) {
        this.activePlans.add(activePlan);
    }

    @Override
    public void subscribe(Object gate) {
        if (!this.subscribed.compareAndSet(false, true)) {
            throw new IllegalStateException("Can only be subscribed to once.");
        }
        this.gate = gate;
        this.source.materialize().unsafeSubscribe(this);
    }

    @Override
    public void dequeue() {
        this.queue.remove();
    }

    @Override
    public void onNext(Notification<T> args) {
        this.safeObserver.onNext(args);
    }

    @Override
    public void onError(Throwable e) {
        this.safeObserver.onError(e);
    }

    @Override
    public void onCompleted() {
        this.safeObserver.onCompleted();
    }

    void removeActivePlan(ActivePlan0 activePlan) {
        this.activePlans.remove(activePlan);
        if (this.activePlans.isEmpty()) {
            this.unsubscribe();
        }
    }

    private final class InnerObserver
    extends Subscriber<Notification<T>> {
        private InnerObserver() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onNext(Notification<T> args) {
            Object object = JoinObserver1.this.gate;
            synchronized (object) {
                if (!this.isUnsubscribed()) {
                    if (args.isOnError()) {
                        JoinObserver1.this.onError.call(args.getThrowable());
                        return;
                    }
                    JoinObserver1.this.queue.add(args);
                    for (ActivePlan0 a : new ArrayList(JoinObserver1.this.activePlans)) {
                        a.match();
                    }
                }
            }
        }

        @Override
        public void onError(Throwable e) {
        }

        @Override
        public void onCompleted() {
        }
    }
}

