/*
 * Decompiled with CFR 0.152.
 */
package rx.math.operators;

import rx.Observable;
import rx.Observer;
import rx.Subscription;
import rx.functions.Func1;
import rx.functions.Func2;

public final class OperationAverage {
    public static Observable<Integer> average(Observable<Integer> source) {
        return source.reduce(new Tuple2(0, 0), new Func2<Tuple2<Integer>, Integer, Tuple2<Integer>>(){

            @Override
            public Tuple2<Integer> call(Tuple2<Integer> accu, Integer next) {
                return new Tuple2<Integer>((Integer)((Tuple2)accu).current + next, ((Tuple2)accu).count + 1);
            }
        }).map(new Func1<Tuple2<Integer>, Integer>(){

            @Override
            public Integer call(Tuple2<Integer> result) {
                if (((Tuple2)result).count == 0) {
                    throw new IllegalArgumentException("Sequence contains no elements");
                }
                return (Integer)((Tuple2)result).current / ((Tuple2)result).count;
            }
        });
    }

    public static Observable<Long> averageLongs(Observable<Long> source) {
        return source.reduce(new Tuple2(0L, 0), new Func2<Tuple2<Long>, Long, Tuple2<Long>>(){

            @Override
            public Tuple2<Long> call(Tuple2<Long> accu, Long next) {
                return new Tuple2<Long>((Long)((Tuple2)accu).current + next, ((Tuple2)accu).count + 1);
            }
        }).map(new Func1<Tuple2<Long>, Long>(){

            @Override
            public Long call(Tuple2<Long> result) {
                if (((Tuple2)result).count == 0) {
                    throw new IllegalArgumentException("Sequence contains no elements");
                }
                return (Long)((Tuple2)result).current / (long)((Tuple2)result).count.intValue();
            }
        });
    }

    public static Observable<Float> averageFloats(Observable<Float> source) {
        return source.reduce(new Tuple2(Float.valueOf(0.0f), 0), new Func2<Tuple2<Float>, Float, Tuple2<Float>>(){

            @Override
            public Tuple2<Float> call(Tuple2<Float> accu, Float next) {
                return new Tuple2<Float>(Float.valueOf(((Float)((Tuple2)accu).current).floatValue() + next.floatValue()), ((Tuple2)accu).count + 1);
            }
        }).map(new Func1<Tuple2<Float>, Float>(){

            @Override
            public Float call(Tuple2<Float> result) {
                if (((Tuple2)result).count == 0) {
                    throw new IllegalArgumentException("Sequence contains no elements");
                }
                return Float.valueOf(((Float)((Tuple2)result).current).floatValue() / (float)((Tuple2)result).count.intValue());
            }
        });
    }

    public static Observable<Double> averageDoubles(Observable<Double> source) {
        return source.reduce(new Tuple2(0.0, 0), new Func2<Tuple2<Double>, Double, Tuple2<Double>>(){

            @Override
            public Tuple2<Double> call(Tuple2<Double> accu, Double next) {
                return new Tuple2<Double>((Double)((Tuple2)accu).current + next, ((Tuple2)accu).count + 1);
            }
        }).map(new Func1<Tuple2<Double>, Double>(){

            @Override
            public Double call(Tuple2<Double> result) {
                if (((Tuple2)result).count == 0) {
                    throw new IllegalArgumentException("Sequence contains no elements");
                }
                return (Double)((Tuple2)result).current / (double)((Tuple2)result).count.intValue();
            }
        });
    }

    public static final class AverageDoubleExtractor<T>
    implements Observable.OnSubscribeFunc<Double> {
        final Observable<? extends T> source;
        final Func1<? super T, Double> valueExtractor;

        public AverageDoubleExtractor(Observable<? extends T> source, Func1<? super T, Double> valueExtractor) {
            this.source = source;
            this.valueExtractor = valueExtractor;
        }

        @Override
        public Subscription onSubscribe(Observer<? super Double> t1) {
            return this.source.subscribe(new AverageObserver(t1));
        }

        private final class AverageObserver
        implements Observer<T> {
            final Observer<? super Double> observer;
            double sum;
            int count;

            public AverageObserver(Observer<? super Double> observer) {
                this.observer = observer;
            }

            @Override
            public void onNext(T args) {
                this.sum += AverageDoubleExtractor.this.valueExtractor.call(args).doubleValue();
                ++this.count;
            }

            @Override
            public void onError(Throwable e) {
                this.observer.onError(e);
            }

            @Override
            public void onCompleted() {
                if (this.count > 0) {
                    try {
                        this.observer.onNext((Double)(this.sum / (double)this.count));
                    }
                    catch (Throwable t) {
                        this.observer.onError(t);
                        return;
                    }
                    this.observer.onCompleted();
                } else {
                    this.observer.onError(new IllegalArgumentException("Sequence contains no elements"));
                }
            }
        }
    }

    public static final class AverageFloatExtractor<T>
    implements Observable.OnSubscribeFunc<Float> {
        final Observable<? extends T> source;
        final Func1<? super T, Float> valueExtractor;

        public AverageFloatExtractor(Observable<? extends T> source, Func1<? super T, Float> valueExtractor) {
            this.source = source;
            this.valueExtractor = valueExtractor;
        }

        @Override
        public Subscription onSubscribe(Observer<? super Float> t1) {
            return this.source.subscribe(new AverageObserver(t1));
        }

        private final class AverageObserver
        implements Observer<T> {
            final Observer<? super Float> observer;
            float sum;
            int count;

            public AverageObserver(Observer<? super Float> observer) {
                this.observer = observer;
            }

            @Override
            public void onNext(T args) {
                this.sum += AverageFloatExtractor.this.valueExtractor.call(args).floatValue();
                ++this.count;
            }

            @Override
            public void onError(Throwable e) {
                this.observer.onError(e);
            }

            @Override
            public void onCompleted() {
                if (this.count > 0) {
                    try {
                        this.observer.onNext(Float.valueOf(this.sum / (float)this.count));
                    }
                    catch (Throwable t) {
                        this.observer.onError(t);
                        return;
                    }
                    this.observer.onCompleted();
                } else {
                    this.observer.onError(new IllegalArgumentException("Sequence contains no elements"));
                }
            }
        }
    }

    public static final class AverageLongExtractor<T>
    implements Observable.OnSubscribeFunc<Long> {
        final Observable<? extends T> source;
        final Func1<? super T, Long> valueExtractor;

        public AverageLongExtractor(Observable<? extends T> source, Func1<? super T, Long> valueExtractor) {
            this.source = source;
            this.valueExtractor = valueExtractor;
        }

        @Override
        public Subscription onSubscribe(Observer<? super Long> t1) {
            return this.source.subscribe(new AverageObserver(t1));
        }

        private final class AverageObserver
        implements Observer<T> {
            final Observer<? super Long> observer;
            long sum;
            int count;

            public AverageObserver(Observer<? super Long> observer) {
                this.observer = observer;
            }

            @Override
            public void onNext(T args) {
                this.sum += AverageLongExtractor.this.valueExtractor.call(args).longValue();
                ++this.count;
            }

            @Override
            public void onError(Throwable e) {
                this.observer.onError(e);
            }

            @Override
            public void onCompleted() {
                if (this.count > 0) {
                    try {
                        this.observer.onNext((Long)(this.sum / (long)this.count));
                    }
                    catch (Throwable t) {
                        this.observer.onError(t);
                        return;
                    }
                    this.observer.onCompleted();
                } else {
                    this.observer.onError(new IllegalArgumentException("Sequence contains no elements"));
                }
            }
        }
    }

    public static final class AverageIntegerExtractor<T>
    implements Observable.OnSubscribeFunc<Integer> {
        final Observable<? extends T> source;
        final Func1<? super T, Integer> valueExtractor;

        public AverageIntegerExtractor(Observable<? extends T> source, Func1<? super T, Integer> valueExtractor) {
            this.source = source;
            this.valueExtractor = valueExtractor;
        }

        @Override
        public Subscription onSubscribe(Observer<? super Integer> t1) {
            return this.source.subscribe(new AverageObserver(t1));
        }

        private final class AverageObserver
        implements Observer<T> {
            final Observer<? super Integer> observer;
            int sum;
            int count;

            public AverageObserver(Observer<? super Integer> observer) {
                this.observer = observer;
            }

            @Override
            public void onNext(T args) {
                this.sum += AverageIntegerExtractor.this.valueExtractor.call(args).intValue();
                ++this.count;
            }

            @Override
            public void onError(Throwable e) {
                this.observer.onError(e);
            }

            @Override
            public void onCompleted() {
                if (this.count > 0) {
                    try {
                        this.observer.onNext((Integer)(this.sum / this.count));
                    }
                    catch (Throwable t) {
                        this.observer.onError(t);
                        return;
                    }
                    this.observer.onCompleted();
                } else {
                    this.observer.onError(new IllegalArgumentException("Sequence contains no elements"));
                }
            }
        }
    }

    private static final class Tuple2<T> {
        private final T current;
        private final Integer count;

        private Tuple2(T v1, Integer v2) {
            this.current = v1;
            this.count = v2;
        }
    }
}

