/*
 * Decompiled with CFR 0.152.
 */
package rx.math.operators;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import rx.Observable;
import rx.functions.Func1;
import rx.functions.Func2;

public class OperationMinMax {
    public static <T extends Comparable<? super T>> Observable<T> min(Observable<T> source) {
        return OperationMinMax.minMax(source, -1L);
    }

    public static <T> Observable<T> min(Observable<T> source, Comparator<? super T> comparator) {
        return OperationMinMax.minMax(source, comparator, -1L);
    }

    public static <T, R extends Comparable<? super R>> Observable<List<T>> minBy(Observable<T> source, Func1<T, R> selector) {
        return OperationMinMax.minMaxBy(source, selector, -1L);
    }

    public static <T, R> Observable<List<T>> minBy(Observable<T> source, Func1<T, R> selector, Comparator<? super R> comparator) {
        return OperationMinMax.minMaxBy(source, selector, comparator, -1L);
    }

    public static <T extends Comparable<? super T>> Observable<T> max(Observable<T> source) {
        return OperationMinMax.minMax(source, 1L);
    }

    public static <T> Observable<T> max(Observable<T> source, Comparator<? super T> comparator) {
        return OperationMinMax.minMax(source, comparator, 1L);
    }

    public static <T, R extends Comparable<? super R>> Observable<List<T>> maxBy(Observable<T> source, Func1<T, R> selector) {
        return OperationMinMax.minMaxBy(source, selector, 1L);
    }

    public static <T, R> Observable<List<T>> maxBy(Observable<T> source, Func1<T, R> selector, Comparator<? super R> comparator) {
        return OperationMinMax.minMaxBy(source, selector, comparator, 1L);
    }

    private static <T extends Comparable<? super T>> Observable<T> minMax(Observable<T> source, final long flag) {
        return source.reduce(new Func2<T, T, T>(){

            @Override
            public T call(T acc, T value) {
                if (flag * (long)acc.compareTo(value) > 0L) {
                    return acc;
                }
                return value;
            }
        });
    }

    private static <T> Observable<T> minMax(Observable<T> source, final Comparator<? super T> comparator, final long flag) {
        return source.reduce(new Func2<T, T, T>(){

            @Override
            public T call(T acc, T value) {
                if (flag * (long)comparator.compare(acc, value) > 0L) {
                    return acc;
                }
                return value;
            }
        });
    }

    private static <T, R extends Comparable<? super R>> Observable<List<T>> minMaxBy(Observable<T> source, final Func1<T, R> selector, final long flag) {
        return source.reduce(new ArrayList(), new Func2<List<T>, T, List<T>>(){

            @Override
            public List<T> call(List<T> acc, T value) {
                if (acc.isEmpty()) {
                    acc.add(value);
                } else {
                    int compareResult = ((Comparable)selector.call(acc.get(0))).compareTo(selector.call(value));
                    if (compareResult == 0) {
                        acc.add(value);
                    } else if (flag * (long)compareResult < 0L) {
                        acc.clear();
                        acc.add(value);
                    }
                }
                return acc;
            }
        });
    }

    private static <T, R> Observable<List<T>> minMaxBy(Observable<T> source, final Func1<T, R> selector, final Comparator<? super R> comparator, final long flag) {
        return source.reduce(new ArrayList(), new Func2<List<T>, T, List<T>>(){

            @Override
            public List<T> call(List<T> acc, T value) {
                if (acc.isEmpty()) {
                    acc.add(value);
                } else {
                    int compareResult = comparator.compare(selector.call(acc.get(0)), selector.call(value));
                    if (compareResult == 0) {
                        acc.add(value);
                    } else if (flag * (long)compareResult < 0L) {
                        acc.clear();
                        acc.add(value);
                    }
                }
                return acc;
            }
        });
    }
}

