/*
 * Decompiled with CFR 0.152.
 */
package rx.observables;

import java.util.Comparator;
import rx.Observable;
import rx.functions.Func1;
import rx.math.operators.OperationAverage;
import rx.math.operators.OperationMinMax;
import rx.math.operators.OperationSum;

public class MathObservable<T> {
    private final Observable<T> o;

    private MathObservable(Observable<T> o) {
        this.o = o;
    }

    public static <T> MathObservable<T> from(Observable<T> o) {
        return new MathObservable<T>(o);
    }

    public static final Observable<Double> averageDouble(Observable<Double> source) {
        return OperationAverage.averageDoubles(source);
    }

    public static final Observable<Float> averageFloat(Observable<Float> source) {
        return OperationAverage.averageFloats(source);
    }

    public static final Observable<Integer> averageInteger(Observable<Integer> source) {
        return OperationAverage.average(source);
    }

    public static final Observable<Long> averageLong(Observable<Long> source) {
        return OperationAverage.averageLongs(source);
    }

    public static final <T extends Comparable<? super T>> Observable<T> max(Observable<T> source) {
        return OperationMinMax.max(source);
    }

    public static final <T extends Comparable<? super T>> Observable<T> min(Observable<T> source) {
        return OperationMinMax.min(source);
    }

    public static final Observable<Double> sumDouble(Observable<Double> source) {
        return OperationSum.sumDoubles(source);
    }

    public static final Observable<Float> sumFloat(Observable<Float> source) {
        return OperationSum.sumFloats(source);
    }

    public static final Observable<Integer> sumInteger(Observable<Integer> source) {
        return OperationSum.sumIntegers(source);
    }

    public static final Observable<Long> sumLong(Observable<Long> source) {
        return OperationSum.sumLongs(source);
    }

    public final Observable<Double> averageDouble(Func1<? super T, Double> valueExtractor) {
        return Observable.create(new OperationAverage.AverageDoubleExtractor<T>(this.o, valueExtractor));
    }

    public final Observable<Float> averageFloat(Func1<? super T, Float> valueExtractor) {
        return Observable.create(new OperationAverage.AverageFloatExtractor<T>(this.o, valueExtractor));
    }

    public final Observable<Integer> averageInteger(Func1<? super T, Integer> valueExtractor) {
        return Observable.create(new OperationAverage.AverageIntegerExtractor<T>(this.o, valueExtractor));
    }

    public final Observable<Long> averageLong(Func1<? super T, Long> valueExtractor) {
        return Observable.create(new OperationAverage.AverageLongExtractor<T>(this.o, valueExtractor));
    }

    public final Observable<T> max(Comparator<? super T> comparator) {
        return OperationMinMax.max(this.o, comparator);
    }

    public final Observable<T> min(Comparator<? super T> comparator) {
        return OperationMinMax.min(this.o, comparator);
    }

    public final Observable<Double> sumDouble(Func1<? super T, Double> valueExtractor) {
        return OperationSum.sumAtLeastOneDoubles(this.o.map(valueExtractor));
    }

    public final Observable<Float> sumFloat(Func1<? super T, Float> valueExtractor) {
        return OperationSum.sumAtLeastOneFloats(this.o.map(valueExtractor));
    }

    public final Observable<Integer> sumInteger(Func1<? super T, Integer> valueExtractor) {
        return OperationSum.sumAtLeastOneIntegers(this.o.map(valueExtractor));
    }

    public final Observable<Long> sumLong(Func1<? super T, Long> valueExtractor) {
        return OperationSum.sumAtLeastOneLongs(this.o.map(valueExtractor));
    }
}

