/*
 * Decompiled with CFR 0.152.
 */
package rx.operators;

import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicReference;
import rx.Observable;
import rx.Observer;
import rx.Subscriber;

public class BufferUntilSubscriber<T>
extends Observable<T>
implements Observer<T> {
    private final AtomicReference<Observer<? super T>> observerRef;
    private static Sentinel NULL_SENTINEL = new Sentinel();
    private static Sentinel COMPLETE_SENTINEL = new Sentinel();

    public static <T> BufferUntilSubscriber<T> create() {
        return new BufferUntilSubscriber<T>(new AtomicReference<Observer<? super T>>(new BufferedObserver()));
    }

    private BufferUntilSubscriber(final AtomicReference<Observer<? super T>> observerRef) {
        super(new Observable.OnSubscribe<T>(){

            @Override
            public void call(Subscriber<? super T> s) {
                BufferedObserver buffered = (BufferedObserver)observerRef.get();
                Object o = null;
                while (true) {
                    Object e = buffered.buffer.poll();
                    o = e;
                    if (e == null) break;
                    BufferUntilSubscriber.emit(s, o);
                }
                observerRef.set(new PassThruObserver(s, buffered.buffer, observerRef));
            }
        });
        this.observerRef = observerRef;
    }

    @Override
    public void onCompleted() {
        this.observerRef.get().onCompleted();
    }

    @Override
    public void onError(Throwable e) {
        this.observerRef.get().onError(e);
    }

    @Override
    public void onNext(T t) {
        this.observerRef.get().onNext(t);
    }

    private static final <T> void emit(Observer<T> s, Object v) {
        if (v instanceof Sentinel) {
            if (v == NULL_SENTINEL) {
                s.onNext(null);
            } else if (v == COMPLETE_SENTINEL) {
                s.onCompleted();
            } else if (v instanceof ErrorSentinel) {
                s.onError(((ErrorSentinel)v).e);
            }
        } else {
            s.onNext(v);
        }
    }

    private static class ErrorSentinel
    extends Sentinel {
        final Throwable e;

        ErrorSentinel(Throwable e) {
            this.e = e;
        }
    }

    private static class Sentinel {
        private Sentinel() {
        }
    }

    private static class BufferedObserver<T>
    extends Subscriber<T> {
        private final ConcurrentLinkedQueue<Object> buffer = new ConcurrentLinkedQueue();

        private BufferedObserver() {
        }

        @Override
        public void onCompleted() {
            this.buffer.add(COMPLETE_SENTINEL);
        }

        @Override
        public void onError(Throwable e) {
            this.buffer.add(new ErrorSentinel(e));
        }

        @Override
        public void onNext(T t) {
            if (t == null) {
                this.buffer.add(NULL_SENTINEL);
            } else {
                this.buffer.add(t);
            }
        }
    }

    private static class PassThruObserver<T>
    extends Subscriber<T> {
        private final Observer<? super T> actual;
        private final ConcurrentLinkedQueue<Object> buffer;
        private final AtomicReference<Observer<? super T>> observerRef;

        PassThruObserver(Observer<? super T> actual, ConcurrentLinkedQueue<Object> buffer, AtomicReference<Observer<? super T>> observerRef) {
            this.actual = actual;
            this.buffer = buffer;
            this.observerRef = observerRef;
        }

        @Override
        public void onCompleted() {
            this.drainIfNeededAndSwitchToActual();
            this.actual.onCompleted();
        }

        @Override
        public void onError(Throwable e) {
            this.drainIfNeededAndSwitchToActual();
            this.actual.onError(e);
        }

        @Override
        public void onNext(T t) {
            this.drainIfNeededAndSwitchToActual();
            this.actual.onNext(t);
        }

        private void drainIfNeededAndSwitchToActual() {
            Object o = null;
            while ((o = this.buffer.poll()) != null) {
                BufferUntilSubscriber.emit(this, o);
            }
            this.observerRef.set(this.actual);
        }
    }
}

