/*
 * Decompiled with CFR 0.152.
 */
package rx.operators;

import java.util.concurrent.atomic.AtomicBoolean;
import rx.Observable;
import rx.Observer;
import rx.Subscriber;
import rx.Subscription;
import rx.functions.Func1;

public class OperationAll {
    public static <T> Observable.OnSubscribeFunc<Boolean> all(Observable<? extends T> sequence, Func1<? super T, Boolean> predicate) {
        return new AllObservable(sequence, predicate);
    }

    private static class AllObservable<T>
    implements Observable.OnSubscribeFunc<Boolean> {
        private final Observable<? extends T> sequence;
        private final Func1<? super T, Boolean> predicate;

        private AllObservable(Observable<? extends T> sequence, Func1<? super T, Boolean> predicate) {
            this.sequence = sequence;
            this.predicate = predicate;
        }

        @Override
        public Subscription onSubscribe(Observer<? super Boolean> observer) {
            return this.sequence.unsafeSubscribe(new AllObserver(observer));
        }

        private class AllObserver
        extends Subscriber<T> {
            private final Observer<? super Boolean> underlying;
            private final AtomicBoolean status = new AtomicBoolean(true);

            public AllObserver(Observer<? super Boolean> underlying) {
                this.underlying = underlying;
            }

            @Override
            public void onCompleted() {
                if (this.status.get()) {
                    this.underlying.onNext((Boolean)true);
                    this.underlying.onCompleted();
                }
            }

            @Override
            public void onError(Throwable e) {
                this.underlying.onError(e);
            }

            @Override
            public void onNext(T args) {
                boolean result = (Boolean)AllObservable.this.predicate.call(args);
                boolean changed = this.status.compareAndSet(true, result);
                if (changed && !result) {
                    this.underlying.onNext((Boolean)false);
                    this.underlying.onCompleted();
                    this.unsubscribe();
                }
            }
        }
    }
}

