/*
 * Decompiled with CFR 0.152.
 */
package rx.operators;

import java.util.concurrent.atomic.AtomicBoolean;
import rx.Observable;
import rx.Observer;
import rx.Subscriber;
import rx.Subscription;
import rx.functions.Func1;
import rx.functions.Functions;
import rx.operators.SafeObservableSubscription;

public final class OperationAny {
    public static <T> Observable.OnSubscribeFunc<Boolean> any(Observable<? extends T> source) {
        return new Any(source, Functions.alwaysTrue(), false);
    }

    public static <T> Observable.OnSubscribeFunc<Boolean> isEmpty(Observable<? extends T> source) {
        return new Any(source, Functions.alwaysTrue(), true);
    }

    public static <T> Observable.OnSubscribeFunc<Boolean> any(Observable<? extends T> source, Func1<? super T, Boolean> predicate) {
        return new Any(source, predicate, false);
    }

    public static <T> Observable.OnSubscribeFunc<Boolean> exists(Observable<? extends T> source, Func1<? super T, Boolean> predicate) {
        return OperationAny.any(source, predicate);
    }

    private static class Any<T>
    implements Observable.OnSubscribeFunc<Boolean> {
        private final Observable<? extends T> source;
        private final Func1<? super T, Boolean> predicate;
        private final boolean returnOnEmpty;

        private Any(Observable<? extends T> source, Func1<? super T, Boolean> predicate, boolean returnOnEmpty) {
            this.source = source;
            this.predicate = predicate;
            this.returnOnEmpty = returnOnEmpty;
        }

        @Override
        public Subscription onSubscribe(final Observer<? super Boolean> observer) {
            final SafeObservableSubscription subscription = new SafeObservableSubscription();
            return subscription.wrap(this.source.unsafeSubscribe(new Subscriber<T>(){
                private final AtomicBoolean hasEmitted = new AtomicBoolean(false);

                @Override
                public void onNext(T value) {
                    try {
                        if (!this.hasEmitted.get() && ((Boolean)Any.this.predicate.call(value)).booleanValue() && !this.hasEmitted.getAndSet(true)) {
                            observer.onNext(!Any.this.returnOnEmpty);
                            observer.onCompleted();
                            subscription.unsubscribe();
                        }
                    }
                    catch (Throwable ex) {
                        observer.onError(ex);
                        subscription.unsubscribe();
                    }
                }

                @Override
                public void onError(Throwable ex) {
                    observer.onError(ex);
                }

                @Override
                public void onCompleted() {
                    if (!this.hasEmitted.get()) {
                        observer.onNext(Any.this.returnOnEmpty);
                        observer.onCompleted();
                    }
                }
            }));
        }
    }
}

