/*
 * Decompiled with CFR 0.152.
 */
package rx.operators;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.List;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import rx.Observable;
import rx.Observer;
import rx.Subscriber;
import rx.Subscription;
import rx.functions.Func2;
import rx.functions.Func3;
import rx.functions.Func4;
import rx.functions.Func5;
import rx.functions.Func6;
import rx.functions.Func7;
import rx.functions.Func8;
import rx.functions.Func9;
import rx.functions.FuncN;
import rx.functions.Functions;
import rx.observers.Subscribers;
import rx.operators.SafeObservableSubscription;
import rx.subscriptions.CompositeSubscription;

public class OperationCombineLatest {
    public static <T0, T1, R> Observable.OnSubscribeFunc<R> combineLatest(Observable<? extends T0> w0, Observable<T1> w1, Func2<? super T0, ? super T1, ? extends R> combineLatestFunction) {
        return new CombineLatest(Arrays.asList(w0, w1), Functions.fromFunc(combineLatestFunction));
    }

    public static <T0, T1, T2, R> Observable.OnSubscribeFunc<R> combineLatest(Observable<? extends T0> w0, Observable<? extends T1> w1, Observable<? extends T2> w2, Func3<? super T0, ? super T1, ? super T2, ? extends R> combineLatestFunction) {
        return new CombineLatest(Arrays.asList(w0, w1, w2), Functions.fromFunc(combineLatestFunction));
    }

    public static <T0, T1, T2, T3, R> Observable.OnSubscribeFunc<R> combineLatest(Observable<? extends T0> w0, Observable<? extends T1> w1, Observable<? extends T2> w2, Observable<? extends T3> w3, Func4<? super T0, ? super T1, ? super T2, ? super T3, ? extends R> combineLatestFunction) {
        return new CombineLatest(Arrays.asList(w0, w1, w2, w3), Functions.fromFunc(combineLatestFunction));
    }

    public static <T0, T1, T2, T3, T4, R> Observable.OnSubscribeFunc<R> combineLatest(Observable<? extends T0> w0, Observable<? extends T1> w1, Observable<? extends T2> w2, Observable<? extends T3> w3, Observable<? extends T4> w4, Func5<? super T0, ? super T1, ? super T2, ? super T3, ? super T4, ? extends R> combineLatestFunction) {
        return new CombineLatest(Arrays.asList(w0, w1, w2, w3, w4), Functions.fromFunc(combineLatestFunction));
    }

    public static <T0, T1, T2, T3, T4, T5, R> Observable.OnSubscribeFunc<R> combineLatest(Observable<? extends T0> w0, Observable<? extends T1> w1, Observable<? extends T2> w2, Observable<? extends T3> w3, Observable<? extends T4> w4, Observable<? extends T5> w5, Func6<? super T0, ? super T1, ? super T2, ? super T3, ? super T4, ? super T5, ? extends R> combineLatestFunction) {
        return new CombineLatest(Arrays.asList(w0, w1, w2, w3, w4, w5), Functions.fromFunc(combineLatestFunction));
    }

    public static <T0, T1, T2, T3, T4, T5, T6, R> Observable.OnSubscribeFunc<R> combineLatest(Observable<? extends T0> w0, Observable<? extends T1> w1, Observable<? extends T2> w2, Observable<? extends T3> w3, Observable<? extends T4> w4, Observable<? extends T5> w5, Observable<? extends T6> w6, Func7<? super T0, ? super T1, ? super T2, ? super T3, ? super T4, ? super T5, ? super T6, ? extends R> combineLatestFunction) {
        return new CombineLatest(Arrays.asList(w0, w1, w2, w3, w4, w5, w6), Functions.fromFunc(combineLatestFunction));
    }

    public static <T0, T1, T2, T3, T4, T5, T6, T7, R> Observable.OnSubscribeFunc<R> combineLatest(Observable<? extends T0> w0, Observable<? extends T1> w1, Observable<? extends T2> w2, Observable<? extends T3> w3, Observable<? extends T4> w4, Observable<? extends T5> w5, Observable<? extends T6> w6, Observable<? extends T7> w7, Func8<? super T0, ? super T1, ? super T2, ? super T3, ? super T4, ? super T5, ? super T6, ? super T7, ? extends R> combineLatestFunction) {
        return new CombineLatest(Arrays.asList(w0, w1, w2, w3, w4, w5, w6, w7), Functions.fromFunc(combineLatestFunction));
    }

    public static <T0, T1, T2, T3, T4, T5, T6, T7, T8, R> Observable.OnSubscribeFunc<R> combineLatest(Observable<? extends T0> w0, Observable<? extends T1> w1, Observable<? extends T2> w2, Observable<? extends T3> w3, Observable<? extends T4> w4, Observable<? extends T5> w5, Observable<? extends T6> w6, Observable<? extends T7> w7, Observable<? extends T8> w8, Func9<? super T0, ? super T1, ? super T2, ? super T3, ? super T4, ? super T5, ? super T6, ? super T7, ? super T8, ? extends R> combineLatestFunction) {
        return new CombineLatest(Arrays.asList(w0, w1, w2, w3, w4, w5, w6, w7, w8), Functions.fromFunc(combineLatestFunction));
    }

    static final class CombineLatest<T, R>
    implements Observable.OnSubscribeFunc<R> {
        final List<Observable<? extends T>> sources = new ArrayList<Observable<? extends T>>();
        final FuncN<? extends R> combiner;

        public CombineLatest(Iterable<? extends Observable<? extends T>> sources, FuncN<? extends R> combiner) {
            this.combiner = combiner;
            for (Observable<T> observable : sources) {
                this.sources.add(observable);
            }
        }

        @Override
        public Subscription onSubscribe(Observer<? super R> t1) {
            CompositeSubscription csub = new CompositeSubscription();
            Collector collector = new Collector(t1, csub, this.sources.size());
            int index = 0;
            ArrayList<SourceObserver> observers = new ArrayList<SourceObserver>(this.sources.size() + 1);
            for (Observable<? extends T> observable : this.sources) {
                SafeObservableSubscription sas = new SafeObservableSubscription();
                csub.add(sas);
                observers.add(new SourceObserver(collector, sas, index, observable));
                ++index;
            }
            for (SourceObserver sourceObserver : observers) {
                if (csub.isUnsubscribed()) continue;
                sourceObserver.connect();
            }
            return csub;
        }

        final class SourceObserver
        extends Subscriber<T> {
            final SafeObservableSubscription self;
            final Collector collector;
            final int index;
            Observable<? extends T> source;

            public SourceObserver(Collector collector, SafeObservableSubscription self, int index, Observable<? extends T> source) {
                this.self = self;
                this.collector = collector;
                this.index = index;
                this.source = source;
            }

            @Override
            public void onNext(T args) {
                this.collector.next(this.index, args);
            }

            @Override
            public void onError(Throwable e) {
                this.collector.error(this.index, e);
            }

            @Override
            public void onCompleted() {
                this.collector.completed(this.index);
                this.self.unsubscribe();
            }

            void connect() {
                this.self.wrap(this.source.unsafeSubscribe(Subscribers.from(this)));
                this.source = null;
            }
        }

        final class Collector {
            final Observer<? super R> observer;
            final Subscription cancel;
            final Lock lock;
            final Object[] values;
            final BitSet hasValue;
            final BitSet completed;
            int hasCount;
            int completedCount;

            public Collector(Observer<? super R> observer, Subscription cancel, int count) {
                this.observer = observer;
                this.cancel = cancel;
                this.values = new Object[count];
                this.hasValue = new BitSet(count);
                this.completed = new BitSet(count);
                this.lock = new ReentrantLock();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void next(int index, T value) {
                Throwable err = null;
                this.lock.lock();
                try {
                    if (!this.isTerminated()) {
                        this.values[index] = value;
                        if (!this.hasValue.get(index)) {
                            this.hasValue.set(index);
                            ++this.hasCount;
                        }
                        if (this.hasCount == this.values.length) {
                            try {
                                this.observer.onNext(CombineLatest.this.combiner.call((Object[])this.values.clone()));
                            }
                            catch (Throwable t) {
                                this.terminate();
                                err = t;
                            }
                        }
                    }
                }
                finally {
                    this.lock.unlock();
                }
                if (err != null) {
                    this.observer.onError(err);
                    this.cancel.unsubscribe();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void error(int index, Throwable e) {
                boolean unsub = false;
                this.lock.lock();
                try {
                    if (!this.isTerminated()) {
                        this.terminate();
                        unsub = true;
                    }
                }
                finally {
                    this.lock.unlock();
                }
                if (unsub) {
                    this.observer.onError(e);
                    this.cancel.unsubscribe();
                }
            }

            boolean isTerminated() {
                return this.completedCount == this.values.length + 1;
            }

            void terminate() {
                this.completedCount = this.values.length + 1;
                Arrays.fill(this.values, null);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void completed(int index) {
                boolean unsub = false;
                this.lock.lock();
                try {
                    if (!this.completed.get(index)) {
                        this.completed.set(index);
                        ++this.completedCount;
                    }
                    if (!(this.hasValue.get(index) && this.completedCount != this.values.length || this.isTerminated())) {
                        this.terminate();
                        unsub = true;
                    }
                }
                finally {
                    this.lock.unlock();
                }
                if (unsub) {
                    this.observer.onCompleted();
                    this.cancel.unsubscribe();
                }
            }
        }
    }
}

