/*
 * Decompiled with CFR 0.152.
 */
package rx.operators;

import java.util.Map;
import rx.Observable;
import rx.Observer;
import rx.Subscription;
import rx.functions.Func0;
import rx.subscriptions.MultipleAssignmentSubscription;
import rx.subscriptions.Subscriptions;

public final class OperationConditionals {
    private static final Func0True TRUE = new Func0True();

    private OperationConditionals() {
        throw new IllegalStateException("No instances!");
    }

    public static <K, R> Observable.OnSubscribeFunc<R> switchCase(Func0<? extends K> caseSelector, Map<? super K, ? extends Observable<? extends R>> mapOfCases, Observable<? extends R> defaultCase) {
        return new SwitchCase<K, R>(caseSelector, mapOfCases, defaultCase);
    }

    public static <R> Observable.OnSubscribeFunc<R> ifThen(Func0<Boolean> condition, Observable<? extends R> then, Observable<? extends R> orElse) {
        return new IfThen<R>(condition, then, orElse);
    }

    public static <T> Observable.OnSubscribeFunc<T> doWhile(Observable<? extends T> source, Func0<Boolean> postCondition) {
        return new WhileDoWhile<T>(source, TRUE, postCondition);
    }

    public static <T> Observable.OnSubscribeFunc<T> whileDo(Observable<? extends T> source, Func0<Boolean> preCondition) {
        return new WhileDoWhile<T>(source, preCondition, preCondition);
    }

    private static final class WhileDoWhile<T>
    implements Observable.OnSubscribeFunc<T> {
        final Func0<Boolean> preCondition;
        final Func0<Boolean> postCondition;
        final Observable<? extends T> source;

        public WhileDoWhile(Observable<? extends T> source, Func0<Boolean> preCondition, Func0<Boolean> postCondition) {
            this.source = source;
            this.preCondition = preCondition;
            this.postCondition = postCondition;
        }

        @Override
        public Subscription onSubscribe(Observer<? super T> t1) {
            boolean first;
            try {
                first = this.preCondition.call();
            }
            catch (Throwable t) {
                t1.onError(t);
                return Subscriptions.empty();
            }
            if (first) {
                MultipleAssignmentSubscription ssub = new MultipleAssignmentSubscription();
                ssub.set(this.source.subscribe(new SourceObserver(t1, ssub)));
                return ssub;
            }
            t1.onCompleted();
            return Subscriptions.empty();
        }

        final class SourceObserver
        implements Observer<T> {
            final MultipleAssignmentSubscription cancel;
            final Observer<? super T> observer;

            public SourceObserver(Observer<? super T> observer, MultipleAssignmentSubscription cancel) {
                this.observer = observer;
                this.cancel = cancel;
            }

            @Override
            public void onNext(T args) {
                this.observer.onNext(args);
            }

            @Override
            public void onError(Throwable e) {
                this.observer.onError(e);
                this.cancel.unsubscribe();
            }

            @Override
            public void onCompleted() {
                boolean next;
                try {
                    next = WhileDoWhile.this.postCondition.call();
                }
                catch (Throwable t) {
                    this.observer.onError(t);
                    return;
                }
                if (next) {
                    this.cancel.set(WhileDoWhile.this.source.subscribe(this));
                } else {
                    this.observer.onCompleted();
                    this.cancel.unsubscribe();
                }
            }
        }
    }

    private static final class IfThen<R>
    implements Observable.OnSubscribeFunc<R> {
        final Func0<Boolean> condition;
        final Observable<? extends R> then;
        final Observable<? extends R> orElse;

        public IfThen(Func0<Boolean> condition, Observable<? extends R> then, Observable<? extends R> orElse) {
            this.condition = condition;
            this.then = then;
            this.orElse = orElse;
        }

        @Override
        public Subscription onSubscribe(Observer<? super R> t1) {
            Observable<R> target;
            try {
                target = this.condition.call().booleanValue() ? this.then : this.orElse;
            }
            catch (Throwable t) {
                t1.onError(t);
                return Subscriptions.empty();
            }
            return target.subscribe(t1);
        }
    }

    private static final class Func0True
    implements Func0<Boolean> {
        private Func0True() {
        }

        @Override
        public Boolean call() {
            return true;
        }
    }

    private static final class SwitchCase<K, R>
    implements Observable.OnSubscribeFunc<R> {
        final Func0<? extends K> caseSelector;
        final Map<? super K, ? extends Observable<? extends R>> mapOfCases;
        final Observable<? extends R> defaultCase;

        public SwitchCase(Func0<? extends K> caseSelector, Map<? super K, ? extends Observable<? extends R>> mapOfCases, Observable<? extends R> defaultCase) {
            this.caseSelector = caseSelector;
            this.mapOfCases = mapOfCases;
            this.defaultCase = defaultCase;
        }

        @Override
        public Subscription onSubscribe(Observer<? super R> t1) {
            Observable<R> target;
            try {
                K caseKey = this.caseSelector.call();
                target = this.mapOfCases.containsKey(caseKey) ? this.mapOfCases.get(caseKey) : this.defaultCase;
            }
            catch (Throwable t) {
                t1.onError(t);
                return Subscriptions.empty();
            }
            return target.subscribe(t1);
        }
    }
}

