/*
 * Decompiled with CFR 0.152.
 */
package rx.operators;

import rx.Observable;
import rx.Observer;
import rx.Subscriber;
import rx.Subscription;
import rx.operators.SafeObservableSubscription;

public class OperationDefaultIfEmpty {
    public static <T> Observable.OnSubscribeFunc<T> defaultIfEmpty(Observable<? extends T> source, T defaultValue) {
        return new DefaultIfEmpty(source, defaultValue);
    }

    private static class DefaultIfEmpty<T>
    implements Observable.OnSubscribeFunc<T> {
        private final Observable<? extends T> source;
        private final T defaultValue;

        private DefaultIfEmpty(Observable<? extends T> source, T defaultValue) {
            this.source = source;
            this.defaultValue = defaultValue;
        }

        @Override
        public Subscription onSubscribe(final Observer<? super T> observer) {
            final SafeObservableSubscription subscription = new SafeObservableSubscription();
            return subscription.wrap(this.source.unsafeSubscribe(new Subscriber<T>(){
                private volatile boolean hasEmitted = false;

                @Override
                public void onNext(T value) {
                    try {
                        this.hasEmitted = true;
                        observer.onNext(value);
                    }
                    catch (Throwable ex) {
                        observer.onError(ex);
                        subscription.unsubscribe();
                    }
                }

                @Override
                public void onError(Throwable ex) {
                    observer.onError(ex);
                }

                @Override
                public void onCompleted() {
                    if (this.hasEmitted) {
                        observer.onCompleted();
                    } else {
                        observer.onNext(DefaultIfEmpty.this.defaultValue);
                        observer.onCompleted();
                    }
                }
            }));
        }
    }
}

