/*
 * Decompiled with CFR 0.152.
 */
package rx.operators;

import java.util.concurrent.TimeUnit;
import rx.Observable;
import rx.Observer;
import rx.Scheduler;
import rx.Subscriber;
import rx.Subscription;
import rx.functions.Action1;
import rx.functions.Func0;
import rx.functions.Func1;
import rx.observables.ConnectableObservable;
import rx.observers.Subscribers;
import rx.subscriptions.CompositeSubscription;
import rx.subscriptions.SerialSubscription;
import rx.subscriptions.Subscriptions;

public final class OperationDelay {
    public static <T> Observable<T> delay(Observable<T> observable, final long delay, final TimeUnit unit, final Scheduler scheduler) {
        Observable seqs = observable.map(new Func1<T, Observable<T>>(){

            @Override
            public Observable<T> call(final T x) {
                ConnectableObservable co = Observable.timer(delay, unit, scheduler).map(new Func1<Long, T>(){

                    @Override
                    public T call(Long ignored) {
                        return x;
                    }
                }).replay();
                co.connect();
                return co;
            }
        });
        return Observable.concat(seqs);
    }

    public static <T> Observable.OnSubscribeFunc<T> delaySubscription(Observable<? extends T> source, long time, TimeUnit unit, Scheduler scheduler) {
        return new DelaySubscribeFunc<T>(source, time, unit, scheduler);
    }

    public static <T, U> Observable.OnSubscribeFunc<T> delay(Observable<? extends T> source, Func1<? super T, ? extends Observable<U>> itemDelay) {
        return new DelayViaObservable(source, null, itemDelay);
    }

    public static <T, U, V> Observable.OnSubscribeFunc<T> delay(Observable<? extends T> source, Func0<? extends Observable<U>> subscriptionDelay, Func1<? super T, ? extends Observable<V>> itemDelay) {
        return new DelayViaObservable(source, subscriptionDelay, itemDelay);
    }

    private static final class DelayViaObservable<T, U, V>
    implements Observable.OnSubscribeFunc<T> {
        final Observable<? extends T> source;
        final Func0<? extends Observable<U>> subscriptionDelay;
        final Func1<? super T, ? extends Observable<V>> itemDelay;

        public DelayViaObservable(Observable<? extends T> source, Func0<? extends Observable<U>> subscriptionDelay, Func1<? super T, ? extends Observable<V>> itemDelay) {
            this.source = source;
            this.subscriptionDelay = subscriptionDelay;
            this.itemDelay = itemDelay;
        }

        @Override
        public Subscription onSubscribe(Observer<? super T> t1) {
            CompositeSubscription csub = new CompositeSubscription();
            SerialSubscription sosub = new SerialSubscription();
            csub.add(sosub);
            SourceObserver so = new SourceObserver(t1, this.itemDelay, csub, sosub);
            if (this.subscriptionDelay == null) {
                sosub.set(this.source.unsafeSubscribe(so));
            } else {
                Observable<U> subscriptionSource;
                try {
                    subscriptionSource = this.subscriptionDelay.call();
                }
                catch (Throwable t) {
                    t1.onError(t);
                    return Subscriptions.empty();
                }
                SerialSubscription ssub = new SerialSubscription();
                csub.add(ssub);
                ssub.set(subscriptionSource.unsafeSubscribe(new SubscribeDelay(this.source, so, csub, ssub)));
            }
            return csub;
        }

        private static final class DelayObserver<T, U>
        extends Subscriber<U> {
            final T value;
            final SourceObserver<T, U> parent;
            final Subscription token;

            public DelayObserver(T value, SourceObserver<T, U> parent, Subscription token) {
                this.value = value;
                this.parent = parent;
                this.token = token;
            }

            @Override
            public void onNext(U args) {
                this.parent.emit(this.value, this.token);
            }

            @Override
            public void onError(Throwable e) {
                this.parent.onError(e);
            }

            @Override
            public void onCompleted() {
                this.parent.emit(this.value, this.token);
            }
        }

        private static final class SourceObserver<T, U>
        extends Subscriber<T> {
            final Observer<? super T> observer;
            final Func1<? super T, ? extends Observable<U>> itemDelay;
            final CompositeSubscription csub;
            final SerialSubscription self;
            final Object guard;
            boolean done;
            int wip;

            public SourceObserver(Observer<? super T> observer, Func1<? super T, ? extends Observable<U>> itemDelay, CompositeSubscription csub, SerialSubscription self) {
                this.observer = observer;
                this.itemDelay = itemDelay;
                this.csub = csub;
                this.guard = new Object();
                this.self = self;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onNext(T args) {
                Observable<U> delayer;
                try {
                    delayer = this.itemDelay.call(args);
                }
                catch (Throwable t) {
                    this.onError(t);
                    return;
                }
                Object t = this.guard;
                synchronized (t) {
                    ++this.wip;
                }
                SerialSubscription ssub = new SerialSubscription();
                this.csub.add(ssub);
                ssub.set(delayer.unsafeSubscribe(new DelayObserver(args, this, ssub)));
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onError(Throwable e) {
                Object object = this.guard;
                synchronized (object) {
                    this.observer.onError(e);
                }
                this.csub.unsubscribe();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onCompleted() {
                boolean b;
                Object object = this.guard;
                synchronized (object) {
                    this.done = true;
                    b = this.checkDone();
                }
                if (b) {
                    this.csub.unsubscribe();
                } else {
                    this.self.unsubscribe();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            void emit(T value, Subscription token) {
                boolean b;
                Object object = this.guard;
                synchronized (object) {
                    this.observer.onNext(value);
                    --this.wip;
                    b = this.checkDone();
                }
                if (b) {
                    this.csub.unsubscribe();
                } else {
                    this.csub.remove(token);
                }
            }

            boolean checkDone() {
                if (this.done && this.wip == 0) {
                    this.observer.onCompleted();
                    return true;
                }
                return false;
            }
        }

        private static final class SubscribeDelay<T, U, V>
        extends Subscriber<U> {
            final Observable<? extends T> source;
            final SourceObserver<T, V> so;
            final CompositeSubscription csub;
            final Subscription self;
            boolean subscribed;

            public SubscribeDelay(Observable<? extends T> source, SourceObserver<T, V> so, CompositeSubscription csub, Subscription self) {
                this.source = source;
                this.so = so;
                this.csub = csub;
                this.self = self;
            }

            @Override
            public void onNext(U args) {
                this.onCompleted();
            }

            @Override
            public void onError(Throwable e) {
                if (!this.subscribed) {
                    this.so.observer.onError(e);
                    this.csub.unsubscribe();
                }
            }

            @Override
            public void onCompleted() {
                this.subscribed = true;
                this.csub.remove(this.self);
                this.so.self.set(this.source.unsafeSubscribe(this.so));
            }
        }
    }

    private static final class DelaySubscribeFunc<T>
    implements Observable.OnSubscribeFunc<T> {
        final Observable<? extends T> source;
        final Scheduler scheduler;
        final long time;
        final TimeUnit unit;

        public DelaySubscribeFunc(Observable<? extends T> source, long time, TimeUnit unit, Scheduler scheduler) {
            this.source = source;
            this.scheduler = scheduler;
            this.time = time;
            this.unit = unit;
        }

        @Override
        public Subscription onSubscribe(final Observer<? super T> t1) {
            final SerialSubscription ssub = new SerialSubscription();
            ssub.set(this.scheduler.schedule(new Action1<Scheduler.Inner>(){

                @Override
                public void call(Scheduler.Inner inner) {
                    if (!ssub.isUnsubscribed()) {
                        ssub.set(DelaySubscribeFunc.this.source.unsafeSubscribe(Subscribers.from(t1)));
                    }
                }
            }, this.time, this.unit));
            return ssub;
        }
    }
}

