/*
 * Decompiled with CFR 0.152.
 */
package rx.operators;

import rx.Notification;
import rx.Observable;
import rx.Observer;
import rx.Subscriber;
import rx.Subscription;

public final class OperationDematerialize {
    public static <T> Observable.OnSubscribeFunc<T> dematerialize(Observable<? extends Notification<? extends T>> sequence) {
        return new DematerializeObservable(sequence);
    }

    private static class DematerializeObservable<T>
    implements Observable.OnSubscribeFunc<T> {
        private final Observable<? extends Notification<? extends T>> sequence;

        public DematerializeObservable(Observable<? extends Notification<? extends T>> sequence) {
            this.sequence = sequence;
        }

        @Override
        public Subscription onSubscribe(final Observer<? super T> observer) {
            return this.sequence.unsafeSubscribe(new Subscriber<Notification<? extends T>>(){

                @Override
                public void onCompleted() {
                    observer.onCompleted();
                }

                @Override
                public void onError(Throwable e) {
                    observer.onError(e);
                }

                @Override
                public void onNext(Notification<? extends T> value) {
                    switch (value.getKind()) {
                        case OnNext: {
                            observer.onNext(value.getValue());
                            break;
                        }
                        case OnError: {
                            observer.onError(value.getThrowable());
                            break;
                        }
                        case OnCompleted: {
                            observer.onCompleted();
                        }
                    }
                }
            });
        }
    }
}

