/*
 * Decompiled with CFR 0.152.
 */
package rx.operators;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import rx.Observable;
import rx.Observer;
import rx.Subscriber;
import rx.Subscription;
import rx.functions.Action0;
import rx.functions.Func1;
import rx.functions.Functions;
import rx.subscriptions.Subscriptions;

public final class OperationDistinct {
    public static <T, U> Observable.OnSubscribeFunc<T> distinct(Observable<? extends T> source, Func1<? super T, ? extends U> keySelector) {
        return new Distinct(source, keySelector);
    }

    public static <T> Observable.OnSubscribeFunc<T> distinct(Observable<? extends T> source, Comparator<T> equalityComparator) {
        return new DistinctWithComparator(source, Functions.identity(), equalityComparator);
    }

    public static <T, U> Observable.OnSubscribeFunc<T> distinct(Observable<? extends T> source, Func1<? super T, ? extends U> keySelector, Comparator<U> equalityComparator) {
        return new DistinctWithComparator(source, keySelector, equalityComparator);
    }

    public static <T> Observable.OnSubscribeFunc<T> distinct(Observable<? extends T> source) {
        return new Distinct(source, Functions.identity());
    }

    private static class DistinctWithComparator<T, U>
    implements Observable.OnSubscribeFunc<T> {
        private final Observable<? extends T> source;
        private final Func1<? super T, ? extends U> keySelector;
        private final Comparator<U> equalityComparator;

        private DistinctWithComparator(Observable<? extends T> source, Func1<? super T, ? extends U> keySelector, Comparator<U> equalityComparator) {
            this.source = source;
            this.keySelector = keySelector;
            this.equalityComparator = equalityComparator;
        }

        @Override
        public Subscription onSubscribe(final Observer<? super T> observer) {
            final Subscription sourceSub = this.source.unsafeSubscribe(new Subscriber<T>(){
                private final List<U> emittedKeys = new ArrayList();

                @Override
                public void onCompleted() {
                    observer.onCompleted();
                }

                @Override
                public void onError(Throwable e) {
                    observer.onError(e);
                }

                @Override
                public void onNext(T next) {
                    Object nextKey = DistinctWithComparator.this.keySelector.call(next);
                    if (!this.alreadyEmitted(nextKey)) {
                        this.emittedKeys.add(nextKey);
                        observer.onNext(next);
                    }
                }

                private boolean alreadyEmitted(U newKey) {
                    for (Object key : this.emittedKeys) {
                        if (DistinctWithComparator.this.equalityComparator.compare(key, newKey) != 0) continue;
                        return true;
                    }
                    return false;
                }
            });
            return Subscriptions.create(new Action0(){

                @Override
                public void call() {
                    sourceSub.unsubscribe();
                }
            });
        }
    }

    private static class Distinct<T, U>
    implements Observable.OnSubscribeFunc<T> {
        private final Observable<? extends T> source;
        private final Func1<? super T, ? extends U> keySelector;

        private Distinct(Observable<? extends T> source, Func1<? super T, ? extends U> keySelector) {
            this.source = source;
            this.keySelector = keySelector;
        }

        @Override
        public Subscription onSubscribe(final Observer<? super T> observer) {
            final Subscription sourceSub = this.source.unsafeSubscribe(new Subscriber<T>(){
                private final Set<U> emittedKeys = new HashSet();

                @Override
                public void onCompleted() {
                    observer.onCompleted();
                }

                @Override
                public void onError(Throwable e) {
                    observer.onError(e);
                }

                @Override
                public void onNext(T next) {
                    Object nextKey = Distinct.this.keySelector.call(next);
                    if (!this.emittedKeys.contains(nextKey)) {
                        this.emittedKeys.add(nextKey);
                        observer.onNext(next);
                    }
                }
            });
            return Subscriptions.create(new Action0(){

                @Override
                public void call() {
                    sourceSub.unsubscribe();
                }
            });
        }
    }
}

