/*
 * Decompiled with CFR 0.152.
 */
package rx.operators;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import rx.Observable;
import rx.Observer;
import rx.Subscriber;
import rx.Subscription;
import rx.functions.Func1;
import rx.functions.Func2;
import rx.subjects.PublishSubject;
import rx.subscriptions.CompositeSubscription;
import rx.subscriptions.RefCountSubscription;
import rx.subscriptions.SerialSubscription;

public class OperationGroupJoin<T1, T2, D1, D2, R>
implements Observable.OnSubscribeFunc<R> {
    protected final Observable<T1> left;
    protected final Observable<T2> right;
    protected final Func1<? super T1, ? extends Observable<D1>> leftDuration;
    protected final Func1<? super T2, ? extends Observable<D2>> rightDuration;
    protected final Func2<? super T1, ? super Observable<T2>, ? extends R> resultSelector;

    public OperationGroupJoin(Observable<T1> left, Observable<T2> right, Func1<? super T1, ? extends Observable<D1>> leftDuration, Func1<? super T2, ? extends Observable<D2>> rightDuration, Func2<? super T1, ? super Observable<T2>, ? extends R> resultSelector) {
        this.left = left;
        this.right = right;
        this.leftDuration = leftDuration;
        this.rightDuration = rightDuration;
        this.resultSelector = resultSelector;
    }

    @Override
    public Subscription onSubscribe(Observer<? super R> t1) {
        ResultManager ro = new ResultManager(t1);
        ro.init();
        return ro;
    }

    static class WindowObservableFunc<T>
    implements Observable.OnSubscribeFunc<T> {
        final RefCountSubscription refCount;
        final Observable<T> underlying;

        public WindowObservableFunc(Observable<T> underlying, RefCountSubscription refCount) {
            this.refCount = refCount;
            this.underlying = underlying;
        }

        @Override
        public Subscription onSubscribe(Observer<? super T> t1) {
            CompositeSubscription cs = new CompositeSubscription();
            cs.add(this.refCount.getSubscription());
            WindowObserver wo = new WindowObserver(t1, cs);
            cs.add(this.underlying.unsafeSubscribe(wo));
            return cs;
        }

        class WindowObserver
        extends Subscriber<T> {
            final Observer<? super T> observer;
            final Subscription self;

            public WindowObserver(Observer<? super T> observer, Subscription self) {
                this.observer = observer;
                this.self = self;
            }

            @Override
            public void onNext(T args) {
                this.observer.onNext(args);
            }

            @Override
            public void onError(Throwable e) {
                this.observer.onError(e);
                this.self.unsubscribe();
            }

            @Override
            public void onCompleted() {
                this.observer.onCompleted();
                this.self.unsubscribe();
            }
        }
    }

    class ResultManager
    implements Subscription {
        final RefCountSubscription cancel;
        final Observer<? super R> observer;
        final CompositeSubscription group;
        final Object guard = new Object();
        int leftIds;
        int rightIds;
        final Map<Integer, Observer<T2>> leftMap = new HashMap();
        final Map<Integer, T2> rightMap = new HashMap();
        boolean leftDone;
        boolean rightDone;

        public ResultManager(Observer<? super R> observer) {
            this.observer = observer;
            this.group = new CompositeSubscription();
            this.cancel = new RefCountSubscription(this.group);
        }

        public void init() {
            SerialSubscription s1 = new SerialSubscription();
            SerialSubscription s2 = new SerialSubscription();
            this.group.add(s1);
            this.group.add(s2);
            s1.setSubscription(OperationGroupJoin.this.left.unsafeSubscribe(new LeftObserver(s1)));
            s2.setSubscription(OperationGroupJoin.this.right.unsafeSubscribe(new RightObserver(s2)));
        }

        @Override
        public void unsubscribe() {
            this.cancel.unsubscribe();
        }

        @Override
        public boolean isUnsubscribed() {
            return this.cancel.isUnsubscribed();
        }

        void groupsOnCompleted() {
            ArrayList list = new ArrayList(this.leftMap.values());
            this.leftMap.clear();
            this.rightMap.clear();
            for (Observer observer : list) {
                observer.onCompleted();
            }
        }

        class RightDurationObserver
        extends Subscriber<D2> {
            final int id;
            final Subscription sduration;

            public RightDurationObserver(int id, Subscription sduration) {
                this.id = id;
                this.sduration = sduration;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onCompleted() {
                Object object = ResultManager.this.guard;
                synchronized (object) {
                    ResultManager.this.rightMap.remove(this.id);
                }
                ResultManager.this.group.remove(this.sduration);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onError(Throwable e) {
                Object object = ResultManager.this.guard;
                synchronized (object) {
                    ResultManager.this.observer.onError(e);
                }
                ResultManager.this.cancel.unsubscribe();
            }

            @Override
            public void onNext(D2 args) {
                this.onCompleted();
            }
        }

        class LeftDurationObserver
        extends Subscriber<D1> {
            final int id;
            final Subscription sduration;
            final Observer<T2> gr;

            public LeftDurationObserver(int id, Subscription sduration, Observer<T2> gr) {
                this.id = id;
                this.sduration = sduration;
                this.gr = gr;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onCompleted() {
                Object object = ResultManager.this.guard;
                synchronized (object) {
                    if (ResultManager.this.leftMap.remove(this.id) != null) {
                        this.gr.onCompleted();
                    }
                }
                ResultManager.this.group.remove(this.sduration);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onError(Throwable e) {
                Object object = ResultManager.this.guard;
                synchronized (object) {
                    ResultManager.this.observer.onError(e);
                }
                ResultManager.this.cancel.unsubscribe();
            }

            @Override
            public void onNext(D1 args) {
                this.onCompleted();
            }
        }

        class RightObserver
        extends Subscriber<T2> {
            final Subscription tosource;

            public RightObserver(Subscription tosource) {
                this.tosource = tosource;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onNext(T2 args) {
                try {
                    int id;
                    Object object = ResultManager.this.guard;
                    synchronized (object) {
                        id = ResultManager.this.rightIds++;
                        ResultManager.this.rightMap.put(id, args);
                    }
                    Observable duration = OperationGroupJoin.this.rightDuration.call(args);
                    SerialSubscription sduration = new SerialSubscription();
                    ResultManager.this.group.add(sduration);
                    sduration.setSubscription(duration.unsafeSubscribe(new RightDurationObserver(id, sduration)));
                    Object object2 = ResultManager.this.guard;
                    synchronized (object2) {
                        for (Observer o : ResultManager.this.leftMap.values()) {
                            o.onNext(args);
                        }
                    }
                }
                catch (Throwable t) {
                    this.onError(t);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onCompleted() {
                Object object = ResultManager.this.guard;
                synchronized (object) {
                    ResultManager.this.rightDone = true;
                    if (ResultManager.this.leftDone) {
                        ResultManager.this.groupsOnCompleted();
                        ResultManager.this.observer.onCompleted();
                        ResultManager.this.cancel.unsubscribe();
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onError(Throwable e) {
                Object object = ResultManager.this.guard;
                synchronized (object) {
                    for (Observer o : ResultManager.this.leftMap.values()) {
                        o.onError(e);
                    }
                    ResultManager.this.observer.onError(e);
                    ResultManager.this.cancel.unsubscribe();
                }
            }
        }

        class LeftObserver
        extends Subscriber<T1> {
            final Subscription tosource;

            public LeftObserver(Subscription tosource) {
                this.tosource = tosource;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onNext(T1 args) {
                try {
                    int id;
                    PublishSubject subj = PublishSubject.create();
                    Object object = ResultManager.this.guard;
                    synchronized (object) {
                        id = ResultManager.this.leftIds++;
                        ResultManager.this.leftMap.put(id, subj);
                    }
                    Observable window = Observable.create(new WindowObservableFunc(subj, ResultManager.this.cancel));
                    Observable duration = OperationGroupJoin.this.leftDuration.call(args);
                    SerialSubscription sduration = new SerialSubscription();
                    ResultManager.this.group.add(sduration);
                    sduration.setSubscription(duration.unsafeSubscribe(new LeftDurationObserver(id, sduration, subj)));
                    Object result = OperationGroupJoin.this.resultSelector.call(args, window);
                    Object object2 = ResultManager.this.guard;
                    synchronized (object2) {
                        ResultManager.this.observer.onNext(result);
                        for (Object t2 : ResultManager.this.rightMap.values()) {
                            subj.onNext(t2);
                        }
                    }
                }
                catch (Throwable t) {
                    this.onError(t);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onCompleted() {
                Object object = ResultManager.this.guard;
                synchronized (object) {
                    ResultManager.this.leftDone = true;
                    if (ResultManager.this.rightDone) {
                        ResultManager.this.groupsOnCompleted();
                        ResultManager.this.observer.onCompleted();
                        ResultManager.this.cancel.unsubscribe();
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onError(Throwable e) {
                Object object = ResultManager.this.guard;
                synchronized (object) {
                    for (Observer o : ResultManager.this.leftMap.values()) {
                        o.onError(e);
                    }
                    ResultManager.this.observer.onError(e);
                    ResultManager.this.cancel.unsubscribe();
                }
            }
        }
    }
}

