/*
 * Decompiled with CFR 0.152.
 */
package rx.operators;

import java.util.concurrent.TimeUnit;
import rx.Observable;
import rx.Observer;
import rx.Scheduler;
import rx.Subscription;
import rx.functions.Action0;
import rx.functions.Action1;
import rx.schedulers.Schedulers;
import rx.subscriptions.Subscriptions;

public final class OperationInterval {
    public static Observable.OnSubscribeFunc<Long> interval(long interval, TimeUnit unit) {
        return OperationInterval.interval(interval, unit, Schedulers.computation());
    }

    public static Observable.OnSubscribeFunc<Long> interval(final long interval, final TimeUnit unit, final Scheduler scheduler) {
        return new Observable.OnSubscribeFunc<Long>(){

            @Override
            public Subscription onSubscribe(Observer<? super Long> observer) {
                return new Interval(interval, unit, scheduler).onSubscribe(observer);
            }
        };
    }

    private static class Interval
    implements Observable.OnSubscribeFunc<Long> {
        private final long period;
        private final TimeUnit unit;
        private final Scheduler scheduler;
        private long currentValue;

        private Interval(long period, TimeUnit unit, Scheduler scheduler) {
            this.period = period;
            this.unit = unit;
            this.scheduler = scheduler;
        }

        @Override
        public Subscription onSubscribe(final Observer<? super Long> observer) {
            final Subscription wrapped = this.scheduler.schedulePeriodically(new Action1<Scheduler.Inner>(){

                @Override
                public void call(Scheduler.Inner inner) {
                    observer.onNext(Interval.this.currentValue);
                    Interval.this.currentValue++;
                }
            }, this.period, this.period, this.unit);
            return Subscriptions.create(new Action0(){

                @Override
                public void call() {
                    wrapped.unsubscribe();
                }
            });
        }
    }
}

