/*
 * Decompiled with CFR 0.152.
 */
package rx.operators;

import java.util.HashMap;
import java.util.Map;
import rx.Observable;
import rx.Observer;
import rx.Subscriber;
import rx.Subscription;
import rx.functions.Func1;
import rx.functions.Func2;
import rx.subscriptions.CompositeSubscription;
import rx.subscriptions.SerialSubscription;

public class OperationJoin<TLeft, TRight, TLeftDuration, TRightDuration, R>
implements Observable.OnSubscribeFunc<R> {
    final Observable<TLeft> left;
    final Observable<TRight> right;
    final Func1<TLeft, Observable<TLeftDuration>> leftDurationSelector;
    final Func1<TRight, Observable<TRightDuration>> rightDurationSelector;
    final Func2<TLeft, TRight, R> resultSelector;

    public OperationJoin(Observable<TLeft> left, Observable<TRight> right, Func1<TLeft, Observable<TLeftDuration>> leftDurationSelector, Func1<TRight, Observable<TRightDuration>> rightDurationSelector, Func2<TLeft, TRight, R> resultSelector) {
        this.left = left;
        this.right = right;
        this.leftDurationSelector = leftDurationSelector;
        this.rightDurationSelector = rightDurationSelector;
        this.resultSelector = resultSelector;
    }

    @Override
    public Subscription onSubscribe(Observer<? super R> t1) {
        SerialSubscription cancel = new SerialSubscription();
        ResultSink result = new ResultSink(t1, cancel);
        cancel.setSubscription(result.run());
        return cancel;
    }

    class ResultSink {
        final Object gate = new Object();
        final CompositeSubscription group = new CompositeSubscription();
        boolean leftDone;
        int leftId;
        final Map<Integer, TLeft> leftMap = new HashMap();
        boolean rightDone;
        int rightId;
        final Map<Integer, TRight> rightMap = new HashMap();
        final Observer<? super R> observer;
        final Subscription cancel;

        public ResultSink(Observer<? super R> observer, Subscription cancel) {
            this.observer = observer;
            this.cancel = cancel;
        }

        public Subscription run() {
            SerialSubscription leftCancel = new SerialSubscription();
            SerialSubscription rightCancel = new SerialSubscription();
            this.group.add(leftCancel);
            this.group.add(rightCancel);
            leftCancel.setSubscription(OperationJoin.this.left.unsafeSubscribe(new LeftObserver(leftCancel)));
            rightCancel.setSubscription(OperationJoin.this.right.unsafeSubscribe(new RightObserver(rightCancel)));
            return this.group;
        }

        class RightObserver
        extends Subscriber<TRight> {
            final Subscription self;

            public RightObserver(Subscription self) {
                this.self = self;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            void expire(int id, Subscription resource) {
                Object object = ResultSink.this.gate;
                synchronized (object) {
                    if (ResultSink.this.rightMap.remove(id) != null && ResultSink.this.rightMap.isEmpty() && ResultSink.this.rightDone) {
                        ResultSink.this.observer.onCompleted();
                        ResultSink.this.cancel.unsubscribe();
                    }
                }
                ResultSink.this.group.remove(resource);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onNext(TRight args) {
                Observable duration;
                int highLeftId;
                int id = 0;
                Object object = ResultSink.this.gate;
                synchronized (object) {
                    id = ResultSink.this.rightId++;
                    ResultSink.this.rightMap.put(id, args);
                    highLeftId = ResultSink.this.leftId;
                }
                SerialSubscription md = new SerialSubscription();
                ResultSink.this.group.add(md);
                try {
                    duration = OperationJoin.this.rightDurationSelector.call(args);
                }
                catch (Throwable t) {
                    ResultSink.this.observer.onError(t);
                    ResultSink.this.cancel.unsubscribe();
                    return;
                }
                md.setSubscription(duration.unsafeSubscribe(new RightDurationObserver(id, md)));
                Object object2 = ResultSink.this.gate;
                synchronized (object2) {
                    for (Map.Entry entry : ResultSink.this.leftMap.entrySet()) {
                        Object result;
                        if (entry.getKey() >= highLeftId) continue;
                        Object lv = entry.getValue();
                        try {
                            result = OperationJoin.this.resultSelector.call(lv, args);
                        }
                        catch (Throwable t) {
                            ResultSink.this.observer.onError(t);
                            ResultSink.this.cancel.unsubscribe();
                            return;
                        }
                        ResultSink.this.observer.onNext(result);
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onError(Throwable e) {
                Object object = ResultSink.this.gate;
                synchronized (object) {
                    ResultSink.this.observer.onError(e);
                    ResultSink.this.cancel.unsubscribe();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onCompleted() {
                Object object = ResultSink.this.gate;
                synchronized (object) {
                    ResultSink.this.rightDone = true;
                    if (ResultSink.this.leftDone || ResultSink.this.rightMap.isEmpty()) {
                        ResultSink.this.observer.onCompleted();
                        ResultSink.this.cancel.unsubscribe();
                    } else {
                        this.self.unsubscribe();
                    }
                }
            }

            class RightDurationObserver
            extends Subscriber<TRightDuration> {
                final int id;
                final Subscription handle;

                public RightDurationObserver(int id, Subscription handle) {
                    this.id = id;
                    this.handle = handle;
                }

                @Override
                public void onNext(TRightDuration args) {
                    RightObserver.this.expire(this.id, this.handle);
                }

                @Override
                public void onError(Throwable e) {
                    RightObserver.this.onError(e);
                }

                @Override
                public void onCompleted() {
                    RightObserver.this.expire(this.id, this.handle);
                }
            }
        }

        class LeftObserver
        extends Subscriber<TLeft> {
            final Subscription self;

            public LeftObserver(Subscription self) {
                this.self = self;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected void expire(int id, Subscription resource) {
                Object object = ResultSink.this.gate;
                synchronized (object) {
                    if (ResultSink.this.leftMap.remove(id) != null && ResultSink.this.leftMap.isEmpty() && ResultSink.this.leftDone) {
                        ResultSink.this.observer.onCompleted();
                        ResultSink.this.cancel.unsubscribe();
                    }
                }
                ResultSink.this.group.remove(resource);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onNext(TLeft args) {
                Observable duration;
                int highRightId;
                int id;
                Object object = ResultSink.this.gate;
                synchronized (object) {
                    id = ResultSink.this.leftId++;
                    ResultSink.this.leftMap.put(id, args);
                    highRightId = ResultSink.this.rightId;
                }
                SerialSubscription md = new SerialSubscription();
                ResultSink.this.group.add(md);
                try {
                    duration = OperationJoin.this.leftDurationSelector.call(args);
                }
                catch (Throwable t) {
                    ResultSink.this.observer.onError(t);
                    ResultSink.this.cancel.unsubscribe();
                    return;
                }
                md.setSubscription(duration.unsafeSubscribe(new LeftDurationObserver(id, md)));
                Object object2 = ResultSink.this.gate;
                synchronized (object2) {
                    for (Map.Entry entry : ResultSink.this.rightMap.entrySet()) {
                        Object result;
                        if (entry.getKey() >= highRightId) continue;
                        Object r = entry.getValue();
                        try {
                            result = OperationJoin.this.resultSelector.call(args, r);
                        }
                        catch (Throwable t) {
                            ResultSink.this.observer.onError(t);
                            ResultSink.this.cancel.unsubscribe();
                            return;
                        }
                        ResultSink.this.observer.onNext(result);
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onError(Throwable e) {
                Object object = ResultSink.this.gate;
                synchronized (object) {
                    ResultSink.this.observer.onError(e);
                    ResultSink.this.cancel.unsubscribe();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onCompleted() {
                Object object = ResultSink.this.gate;
                synchronized (object) {
                    ResultSink.this.leftDone = true;
                    if (ResultSink.this.rightDone || ResultSink.this.leftMap.isEmpty()) {
                        ResultSink.this.observer.onCompleted();
                        ResultSink.this.cancel.unsubscribe();
                    } else {
                        this.self.unsubscribe();
                    }
                }
            }

            class LeftDurationObserver
            extends Subscriber<TLeftDuration> {
                final int id;
                final Subscription handle;

                public LeftDurationObserver(int id, Subscription handle) {
                    this.id = id;
                    this.handle = handle;
                }

                @Override
                public void onNext(TLeftDuration args) {
                    LeftObserver.this.expire(this.id, this.handle);
                }

                @Override
                public void onError(Throwable e) {
                    LeftObserver.this.onError(e);
                }

                @Override
                public void onCompleted() {
                    LeftObserver.this.expire(this.id, this.handle);
                }
            }
        }
    }
}

