/*
 * Decompiled with CFR 0.152.
 */
package rx.operators;

import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import rx.Observable;
import rx.Observer;
import rx.Subscriber;
import rx.Subscription;
import rx.exceptions.CompositeException;
import rx.observers.SerializedObserver;
import rx.subscriptions.BooleanSubscription;
import rx.subscriptions.CompositeSubscription;

public final class OperationMergeDelayError {
    public static <T> Observable.OnSubscribeFunc<T> mergeDelayError(final Observable<? extends Observable<? extends T>> sequences) {
        return new Observable.OnSubscribeFunc<T>(){

            @Override
            public Subscription onSubscribe(Observer<? super T> observer) {
                return new MergeDelayErrorObservable(sequences).onSubscribe(observer);
            }
        };
    }

    public static <T> Observable.OnSubscribeFunc<T> mergeDelayError(final Observable<? extends T> ... sequences) {
        return OperationMergeDelayError.mergeDelayError(Observable.create(new Observable.OnSubscribeFunc<Observable<? extends T>>(){
            private final BooleanSubscription s = new BooleanSubscription();

            @Override
            public Subscription onSubscribe(Observer<? super Observable<? extends T>> observer) {
                for (Observable o : sequences) {
                    if (this.s.isUnsubscribed()) break;
                    observer.onNext(o);
                }
                if (!this.s.isUnsubscribed()) {
                    observer.onCompleted();
                }
                return this.s;
            }
        }));
    }

    public static <T> Observable.OnSubscribeFunc<T> mergeDelayError(final List<? extends Observable<? extends T>> sequences) {
        return OperationMergeDelayError.mergeDelayError(Observable.create(new Observable.OnSubscribeFunc<Observable<? extends T>>(){
            private final BooleanSubscription s = new BooleanSubscription();

            @Override
            public Subscription onSubscribe(Observer<? super Observable<? extends T>> observer) {
                for (Observable o : sequences) {
                    if (this.s.isUnsubscribed()) break;
                    observer.onNext(o);
                }
                if (!this.s.isUnsubscribed()) {
                    observer.onCompleted();
                }
                return this.s;
            }
        }));
    }

    private static final class MergeDelayErrorObservable<T>
    implements Observable.OnSubscribeFunc<T> {
        private final Observable<? extends Observable<? extends T>> sequences;
        private final MergeSubscription ourSubscription = new MergeSubscription();
        private AtomicBoolean stopped = new AtomicBoolean(false);
        private volatile boolean parentCompleted = false;
        private final ConcurrentHashMap<ChildObserver, ChildObserver> childObservers = new ConcurrentHashMap();
        private final ConcurrentHashMap<ChildObserver, Subscription> childSubscriptions = new ConcurrentHashMap();
        private ConcurrentLinkedQueue<Throwable> onErrorReceived = new ConcurrentLinkedQueue();

        private MergeDelayErrorObservable(Observable<? extends Observable<? extends T>> sequences) {
            this.sequences = sequences;
        }

        @Override
        public Subscription onSubscribe(Observer<? super T> actualObserver) {
            CompositeSubscription completeSubscription = new CompositeSubscription();
            SerializedObserver<? super T> synchronizedObserver = new SerializedObserver<T>(actualObserver);
            completeSubscription.add(this.sequences.unsafeSubscribe(new ParentObserver(synchronizedObserver)));
            return completeSubscription;
        }

        private class ChildObserver
        extends Subscriber<T> {
            private final Observer<? super T> actualObserver;
            private volatile boolean finished = false;

            public ChildObserver(Observer<? super T> actualObserver) {
                this.actualObserver = actualObserver;
            }

            @Override
            public void onCompleted() {
                MergeDelayErrorObservable.this.childObservers.remove(this);
                if (!MergeDelayErrorObservable.this.stopped.get()) {
                    this.finishObserver();
                }
            }

            @Override
            public void onError(Throwable e) {
                if (!MergeDelayErrorObservable.this.stopped.get()) {
                    MergeDelayErrorObservable.this.onErrorReceived.add(e);
                    MergeDelayErrorObservable.this.childObservers.remove(this);
                    this.finished = true;
                    this.finishObserver();
                }
            }

            private void finishObserver() {
                if (MergeDelayErrorObservable.this.childObservers.size() == 0 && MergeDelayErrorObservable.this.parentCompleted && MergeDelayErrorObservable.this.ourSubscription.stop()) {
                    if (MergeDelayErrorObservable.this.onErrorReceived.size() == 1) {
                        this.actualObserver.onError((Throwable)MergeDelayErrorObservable.this.onErrorReceived.peek());
                    } else if (MergeDelayErrorObservable.this.onErrorReceived.size() > 1) {
                        this.actualObserver.onError(new CompositeException(MergeDelayErrorObservable.this.onErrorReceived));
                    } else {
                        this.actualObserver.onCompleted();
                    }
                }
            }

            @Override
            public void onNext(T args) {
                if (!MergeDelayErrorObservable.this.stopped.get() && !this.finished) {
                    this.actualObserver.onNext(args);
                }
            }
        }

        private class ParentObserver
        extends Subscriber<Observable<? extends T>> {
            private final Observer<? super T> actualObserver;

            public ParentObserver(Observer<? super T> actualObserver) {
                this.actualObserver = actualObserver;
            }

            @Override
            public void onCompleted() {
                MergeDelayErrorObservable.this.parentCompleted = true;
                if (MergeDelayErrorObservable.this.childObservers.size() == 0 && !MergeDelayErrorObservable.this.stopped.get() && MergeDelayErrorObservable.this.ourSubscription.stop()) {
                    if (MergeDelayErrorObservable.this.onErrorReceived.size() == 1) {
                        this.actualObserver.onError((Throwable)MergeDelayErrorObservable.this.onErrorReceived.peek());
                    } else if (MergeDelayErrorObservable.this.onErrorReceived.size() > 1) {
                        this.actualObserver.onError(new CompositeException(MergeDelayErrorObservable.this.onErrorReceived));
                    } else {
                        this.actualObserver.onCompleted();
                    }
                }
            }

            @Override
            public void onError(Throwable e) {
                this.actualObserver.onError(e);
            }

            @Override
            public void onNext(Observable<? extends T> childObservable) {
                if (MergeDelayErrorObservable.this.stopped.get()) {
                    return;
                }
                if (childObservable == null) {
                    throw new IllegalArgumentException("Observable<T> can not be null.");
                }
                ChildObserver _w = new ChildObserver(this.actualObserver);
                MergeDelayErrorObservable.this.childObservers.put(_w, _w);
                Subscription _subscription = childObservable.unsafeSubscribe(_w);
                MergeDelayErrorObservable.this.childSubscriptions.put(_w, _subscription);
            }
        }

        private class MergeSubscription
        implements Subscription {
            private MergeSubscription() {
            }

            @Override
            public void unsubscribe() {
                this.stop();
            }

            public boolean stop() {
                boolean didSet = MergeDelayErrorObservable.this.stopped.compareAndSet(false, true);
                if (didSet) {
                    for (Subscription _s : MergeDelayErrorObservable.this.childSubscriptions.values()) {
                        _s.unsubscribe();
                    }
                    return true;
                }
                return false;
            }

            @Override
            public boolean isUnsubscribed() {
                return MergeDelayErrorObservable.this.stopped.get();
            }
        }
    }
}

