/*
 * Decompiled with CFR 0.152.
 */
package rx.operators;

import java.util.LinkedList;
import rx.Observable;
import rx.Observer;
import rx.Subscriber;
import rx.Subscription;
import rx.observers.SerializedObserver;
import rx.operators.SafeObservableSubscription;
import rx.operators.SafeObserver;
import rx.subscriptions.CompositeSubscription;

public final class OperationMergeMaxConcurrent {
    public static <T> Observable.OnSubscribeFunc<T> merge(final Observable<? extends Observable<? extends T>> o, final int maxConcurrent) {
        if (maxConcurrent <= 0) {
            throw new IllegalArgumentException("maxConcurrent must be positive");
        }
        return new Observable.OnSubscribeFunc<T>(){

            @Override
            public Subscription onSubscribe(Observer<? super T> observer) {
                return new MergeObservable(o, maxConcurrent).onSubscribe(observer);
            }
        };
    }

    private static final class MergeObservable<T>
    implements Observable.OnSubscribeFunc<T> {
        private final Observable<? extends Observable<? extends T>> sequences;
        private final CompositeSubscription ourSubscription = new CompositeSubscription();
        private volatile boolean parentCompleted = false;
        private final LinkedList<Observable<? extends T>> pendingObservables = new LinkedList();
        private volatile int activeObservableCount = 0;
        private final int maxConcurrent;
        private final Object gate = new Object();

        private MergeObservable(Observable<? extends Observable<? extends T>> sequences, int maxConcurrent) {
            this.sequences = sequences;
            this.maxConcurrent = maxConcurrent;
        }

        @Override
        public Subscription onSubscribe(Observer<? super T> actualObserver) {
            SafeObservableSubscription subscription = new SafeObservableSubscription(this.ourSubscription);
            SerializedObserver<? super T> synchronizedObserver = new SerializedObserver<T>(new SafeObserver<T>(subscription, actualObserver));
            this.ourSubscription.add(this.sequences.unsafeSubscribe(new ParentObserver(synchronizedObserver)));
            return subscription;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean isStopped() {
            Object object = this.gate;
            synchronized (object) {
                return this.parentCompleted && this.activeObservableCount == 0 && this.pendingObservables.size() == 0;
            }
        }

        private class ChildObserver
        extends Subscriber<T> {
            private final SerializedObserver<T> serializedObserver;

            public ChildObserver(SerializedObserver<T> serializedObserver) {
                this.serializedObserver = serializedObserver;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onCompleted() {
                if (MergeObservable.this.ourSubscription.isUnsubscribed()) {
                    return;
                }
                Observable childObservable = null;
                Object object = MergeObservable.this.gate;
                synchronized (object) {
                    childObservable = (Observable)MergeObservable.this.pendingObservables.poll();
                    if (childObservable == null) {
                        MergeObservable.this.activeObservableCount--;
                    }
                }
                if (childObservable != null) {
                    MergeObservable.this.ourSubscription.add(childObservable.unsafeSubscribe(this));
                } else if (MergeObservable.this.isStopped()) {
                    this.serializedObserver.onCompleted();
                }
            }

            @Override
            public void onError(Throwable e) {
                this.serializedObserver.onError(e);
            }

            @Override
            public void onNext(T args) {
                this.serializedObserver.onNext(args);
            }
        }

        private class ParentObserver
        extends Subscriber<Observable<? extends T>> {
            private final SerializedObserver<T> serializedObserver;

            public ParentObserver(SerializedObserver<T> serializedObserver) {
                this.serializedObserver = serializedObserver;
            }

            @Override
            public void onCompleted() {
                MergeObservable.this.parentCompleted = true;
                if (MergeObservable.this.ourSubscription.isUnsubscribed()) {
                    return;
                }
                if (MergeObservable.this.isStopped()) {
                    this.serializedObserver.onCompleted();
                }
            }

            @Override
            public void onError(Throwable e) {
                this.serializedObserver.onError(e);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onNext(Observable<? extends T> childObservable) {
                if (MergeObservable.this.ourSubscription.isUnsubscribed()) {
                    return;
                }
                if (childObservable == null) {
                    throw new IllegalArgumentException("Observable<T> can not be null.");
                }
                Observable observable = null;
                Object object = MergeObservable.this.gate;
                synchronized (object) {
                    if (MergeObservable.this.activeObservableCount >= MergeObservable.this.maxConcurrent) {
                        MergeObservable.this.pendingObservables.add(childObservable);
                    } else {
                        observable = childObservable;
                        MergeObservable.this.activeObservableCount++;
                    }
                }
                if (observable != null) {
                    MergeObservable.this.ourSubscription.add(observable.unsafeSubscribe(new ChildObserver(this.serializedObserver)));
                }
            }
        }
    }
}

